<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketingInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Minimum information about ticketing required to complete the booking transaction.
 * @subpackage Structs
 */
class TicketingInfoType extends AbstractStructBase
{
    /**
     * The TicketAdvisory
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\TicketAdvisory[]
     */
    public $TicketAdvisory;
    /**
     * The TicketingVendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TicketingVendor
     */
    public $TicketingVendor;
    /**
     * The PricingSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PricingSystem
     */
    public $PricingSystem;
    /**
     * The TotalFare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalFare
     */
    public $TotalFare;
    /**
     * The TicketTimeLimit
     * Meta information extracted from the WSDL
     * - documentation: TicketTimeLimit - Indicates the ticketing arrangement, and allows for the requirement that an itinerary must be ticketed by a certain date and time.
     * - use: optional
     * @var string
     */
    public $TicketTimeLimit;
    /**
     * The CancelOnExpiryInd
     * Meta information extracted from the WSDL
     * - documentation: When true, unticketed bookings should be cancelled when the TicketTimeLimit has expired.
     * - use: optional
     * @var bool
     */
    public $CancelOnExpiryInd;
    /**
     * The TicketType
     * Meta information extracted from the WSDL
     * - documentation: TicketType - Indicates the type of ticket (Paper, eTicket)
     * - use: optional
     * @var string
     */
    public $TicketType;
    /**
     * The TicketingStatus
     * Meta information extracted from the WSDL
     * - documentation: Code for setting and displaying detailed ticketing information. Refer to OpenTravel Code List Ticketing Status (TST). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $TicketingStatus;
    /**
     * The FlightSegmentRefNumber
     * Meta information extracted from the WSDL
     * - documentation: Specifies one or more segment numbers for ticketing purposes. This RPH is associated with the RPH contained in the FlightSegment element in AirBookRQ. | The Reference Place Holder (RPH) is an index code used to identify an instance
     * in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $FlightSegmentRefNumber;
    /**
     * The TravelerRefNumber
     * Meta information extracted from the WSDL
     * - documentation: Specifies one or more traveler names for ticketing purposes. This RPH is associated with the RPH contained in the TravelerRefNumber element in AirBookRQ. | The Reference Place Holder (RPH) is an index code used to identify an
     * instance in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $TravelerRefNumber;
    /**
     * The ReverseTktgSegmentsInd
     * Meta information extracted from the WSDL
     * - documentation: Applies a reverse sequence of the outbound travel to the inbound travel.
     * - use: optional
     * @var bool
     */
    public $ReverseTktgSegmentsInd;
    /**
     * The PseudoCityCode
     * Meta information extracted from the WSDL
     * - documentation: An identification code assigned to an office/agency by a reservation system. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The RequestedTicketingDate
     * Meta information extracted from the WSDL
     * - documentation: The date on which ticketing should occur. | A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $RequestedTicketingDate;
    /**
     * The TimeLimitMinutes
     * Meta information extracted from the WSDL
     * - documentation: The number of minutes until the ticket must be issued for the itinerary. | Used for Numeric values, from 1 to 99 inclusive.
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $TimeLimitMinutes;
    /**
     * The BookingChangeType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BookingChangeType;
    /**
     * The TicketDocumentNbr
     * Meta information extracted from the WSDL
     * - documentation: The ticket document number including the airline code, the form code, and the serial number. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TicketDocumentNbr;
    /**
     * The PassengerTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code used to indicate the ticketing-relevant type of traveler that has been quoted (e.g., MIL, CHD, INF, SEN). | Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: optional
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * The MiscTicketingCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies one or more ticketing relevant codes. Refer to OpenTravel code list Misc Ticketing Code (MTC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X. | List of
     * OpenTravel Codes.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string[]
     */
    public $MiscTicketingCode;
    /**
     * Constructor method for TicketingInfoType
     * @uses TicketingInfoType::setTicketAdvisory()
     * @uses TicketingInfoType::setTicketingVendor()
     * @uses TicketingInfoType::setPricingSystem()
     * @uses TicketingInfoType::setTotalFare()
     * @uses TicketingInfoType::setTicketTimeLimit()
     * @uses TicketingInfoType::setCancelOnExpiryInd()
     * @uses TicketingInfoType::setTicketType()
     * @uses TicketingInfoType::setTicketingStatus()
     * @uses TicketingInfoType::setFlightSegmentRefNumber()
     * @uses TicketingInfoType::setTravelerRefNumber()
     * @uses TicketingInfoType::setReverseTktgSegmentsInd()
     * @uses TicketingInfoType::setPseudoCityCode()
     * @uses TicketingInfoType::setRequestedTicketingDate()
     * @uses TicketingInfoType::setTimeLimitMinutes()
     * @uses TicketingInfoType::setBookingChangeType()
     * @uses TicketingInfoType::setTicketDocumentNbr()
     * @uses TicketingInfoType::setPassengerTypeCode()
     * @uses TicketingInfoType::setOperation()
     * @uses TicketingInfoType::setMiscTicketingCode()
     * @param \StructType\TicketAdvisory[] $ticketAdvisory
     * @param \StructType\TicketingVendor $ticketingVendor
     * @param \StructType\PricingSystem $pricingSystem
     * @param \StructType\TotalFare $totalFare
     * @param string $ticketTimeLimit
     * @param bool $cancelOnExpiryInd
     * @param string $ticketType
     * @param string $ticketingStatus
     * @param string[] $flightSegmentRefNumber
     * @param string[] $travelerRefNumber
     * @param bool $reverseTktgSegmentsInd
     * @param string $pseudoCityCode
     * @param string $requestedTicketingDate
     * @param int $timeLimitMinutes
     * @param string $bookingChangeType
     * @param string $ticketDocumentNbr
     * @param string $passengerTypeCode
     * @param string $operation
     * @param string[] $miscTicketingCode
     */
    public function __construct(array $ticketAdvisory = array(), \StructType\TicketingVendor $ticketingVendor = null, \StructType\PricingSystem $pricingSystem = null, \StructType\TotalFare $totalFare = null, $ticketTimeLimit = null, $cancelOnExpiryInd = null, $ticketType = null, $ticketingStatus = null, array $flightSegmentRefNumber = array(), array $travelerRefNumber = array(), $reverseTktgSegmentsInd = null, $pseudoCityCode = null, $requestedTicketingDate = null, $timeLimitMinutes = null, $bookingChangeType = null, $ticketDocumentNbr = null, $passengerTypeCode = null, $operation = null, array $miscTicketingCode = array())
    {
        $this
            ->setTicketAdvisory($ticketAdvisory)
            ->setTicketingVendor($ticketingVendor)
            ->setPricingSystem($pricingSystem)
            ->setTotalFare($totalFare)
            ->setTicketTimeLimit($ticketTimeLimit)
            ->setCancelOnExpiryInd($cancelOnExpiryInd)
            ->setTicketType($ticketType)
            ->setTicketingStatus($ticketingStatus)
            ->setFlightSegmentRefNumber($flightSegmentRefNumber)
            ->setTravelerRefNumber($travelerRefNumber)
            ->setReverseTktgSegmentsInd($reverseTktgSegmentsInd)
            ->setPseudoCityCode($pseudoCityCode)
            ->setRequestedTicketingDate($requestedTicketingDate)
            ->setTimeLimitMinutes($timeLimitMinutes)
            ->setBookingChangeType($bookingChangeType)
            ->setTicketDocumentNbr($ticketDocumentNbr)
            ->setPassengerTypeCode($passengerTypeCode)
            ->setOperation($operation)
            ->setMiscTicketingCode($miscTicketingCode);
    }
    /**
     * Get TicketAdvisory value
     * @return \StructType\TicketAdvisory[]|null
     */
    public function getTicketAdvisory()
    {
        return $this->TicketAdvisory;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketAdvisory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketAdvisory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketAdvisoryForArrayConstraintsFromSetTicketAdvisory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketingInfoTypeTicketAdvisoryItem) {
            // validation for constraint: itemType
            if (!$ticketingInfoTypeTicketAdvisoryItem instanceof \StructType\TicketAdvisory) {
                $invalidValues[] = is_object($ticketingInfoTypeTicketAdvisoryItem) ? get_class($ticketingInfoTypeTicketAdvisoryItem) : sprintf('%s(%s)', gettype($ticketingInfoTypeTicketAdvisoryItem), var_export($ticketingInfoTypeTicketAdvisoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketAdvisory property can only contain items of type \StructType\TicketAdvisory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketAdvisory value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketAdvisory[] $ticketAdvisory
     * @return \StructType\TicketingInfoType
     */
    public function setTicketAdvisory(array $ticketAdvisory = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketAdvisoryArrayErrorMessage = self::validateTicketAdvisoryForArrayConstraintsFromSetTicketAdvisory($ticketAdvisory))) {
            throw new \InvalidArgumentException($ticketAdvisoryArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($ticketAdvisory) && count($ticketAdvisory) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($ticketAdvisory)), __LINE__);
        }
        $this->TicketAdvisory = $ticketAdvisory;
        return $this;
    }
    /**
     * Add item to TicketAdvisory value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketAdvisory $item
     * @return \StructType\TicketingInfoType
     */
    public function addToTicketAdvisory(\StructType\TicketAdvisory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TicketAdvisory) {
            throw new \InvalidArgumentException(sprintf('The TicketAdvisory property can only contain items of type \StructType\TicketAdvisory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->TicketAdvisory) && count($this->TicketAdvisory) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->TicketAdvisory)), __LINE__);
        }
        $this->TicketAdvisory[] = $item;
        return $this;
    }
    /**
     * Get TicketingVendor value
     * @return \StructType\TicketingVendor|null
     */
    public function getTicketingVendor()
    {
        return $this->TicketingVendor;
    }
    /**
     * Set TicketingVendor value
     * @param \StructType\TicketingVendor $ticketingVendor
     * @return \StructType\TicketingInfoType
     */
    public function setTicketingVendor(\StructType\TicketingVendor $ticketingVendor = null)
    {
        $this->TicketingVendor = $ticketingVendor;
        return $this;
    }
    /**
     * Get PricingSystem value
     * @return \StructType\PricingSystem|null
     */
    public function getPricingSystem()
    {
        return $this->PricingSystem;
    }
    /**
     * Set PricingSystem value
     * @param \StructType\PricingSystem $pricingSystem
     * @return \StructType\TicketingInfoType
     */
    public function setPricingSystem(\StructType\PricingSystem $pricingSystem = null)
    {
        $this->PricingSystem = $pricingSystem;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return \StructType\TotalFare|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param \StructType\TotalFare $totalFare
     * @return \StructType\TicketingInfoType
     */
    public function setTotalFare(\StructType\TotalFare $totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get TicketTimeLimit value
     * @return string|null
     */
    public function getTicketTimeLimit()
    {
        return $this->TicketTimeLimit;
    }
    /**
     * Set TicketTimeLimit value
     * @param string $ticketTimeLimit
     * @return \StructType\TicketingInfoType
     */
    public function setTicketTimeLimit($ticketTimeLimit = null)
    {
        // validation for constraint: string
        if (!is_null($ticketTimeLimit) && !is_string($ticketTimeLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketTimeLimit, true), gettype($ticketTimeLimit)), __LINE__);
        }
        $this->TicketTimeLimit = $ticketTimeLimit;
        return $this;
    }
    /**
     * Get CancelOnExpiryInd value
     * @return bool|null
     */
    public function getCancelOnExpiryInd()
    {
        return $this->CancelOnExpiryInd;
    }
    /**
     * Set CancelOnExpiryInd value
     * @param bool $cancelOnExpiryInd
     * @return \StructType\TicketingInfoType
     */
    public function setCancelOnExpiryInd($cancelOnExpiryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancelOnExpiryInd) && !is_bool($cancelOnExpiryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancelOnExpiryInd, true), gettype($cancelOnExpiryInd)), __LINE__);
        }
        $this->CancelOnExpiryInd = $cancelOnExpiryInd;
        return $this;
    }
    /**
     * Get TicketType value
     * @return string|null
     */
    public function getTicketType()
    {
        return $this->TicketType;
    }
    /**
     * Set TicketType value
     * @uses \EnumType\TicketType::valueIsValid()
     * @uses \EnumType\TicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketType
     * @return \StructType\TicketingInfoType
     */
    public function setTicketType($ticketType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TicketType::valueIsValid($ticketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TicketType', is_array($ticketType) ? implode(', ', $ticketType) : var_export($ticketType, true), implode(', ', \EnumType\TicketType::getValidValues())), __LINE__);
        }
        $this->TicketType = $ticketType;
        return $this;
    }
    /**
     * Get TicketingStatus value
     * @return string|null
     */
    public function getTicketingStatus()
    {
        return $this->TicketingStatus;
    }
    /**
     * Set TicketingStatus value
     * @param string $ticketingStatus
     * @return \StructType\TicketingInfoType
     */
    public function setTicketingStatus($ticketingStatus = null)
    {
        // validation for constraint: string
        if (!is_null($ticketingStatus) && !is_string($ticketingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketingStatus, true), gettype($ticketingStatus)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($ticketingStatus) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $ticketingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($ticketingStatus, true)), __LINE__);
        }
        $this->TicketingStatus = $ticketingStatus;
        return $this;
    }
    /**
     * Get FlightSegmentRefNumber value
     * @return string[]|null
     */
    public function getFlightSegmentRefNumber()
    {
        return $this->FlightSegmentRefNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightSegmentRefNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightSegmentRefNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightSegmentRefNumberForArrayConstraintsFromSetFlightSegmentRefNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketingInfoTypeFlightSegmentRefNumberItem) {
            // validation for constraint: itemType
            if (!is_string($ticketingInfoTypeFlightSegmentRefNumberItem)) {
                $invalidValues[] = is_object($ticketingInfoTypeFlightSegmentRefNumberItem) ? get_class($ticketingInfoTypeFlightSegmentRefNumberItem) : sprintf('%s(%s)', gettype($ticketingInfoTypeFlightSegmentRefNumberItem), var_export($ticketingInfoTypeFlightSegmentRefNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightSegmentRefNumber property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightSegmentRefNumber value
     * @param string[] $flightSegmentRefNumber
     * @return \StructType\TicketingInfoType
     */
    public function setFlightSegmentRefNumber(array $flightSegmentRefNumber = array())
    {
        // validation for constraint: list
        if ('' !== ($flightSegmentRefNumberArrayErrorMessage = self::validateFlightSegmentRefNumberForArrayConstraintsFromSetFlightSegmentRefNumber($flightSegmentRefNumber))) {
            throw new \InvalidArgumentException($flightSegmentRefNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($flightSegmentRefNumber) && !preg_match('/[0-9]{1,8}/', $flightSegmentRefNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($flightSegmentRefNumber, true)), __LINE__);
        }
        $this->FlightSegmentRefNumber = is_array($flightSegmentRefNumber) ? implode(' ', $flightSegmentRefNumber) : null;
        return $this;
    }
    /**
     * Get TravelerRefNumber value
     * @return string[]|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelerRefNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelerRefNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelerRefNumberForArrayConstraintsFromSetTravelerRefNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketingInfoTypeTravelerRefNumberItem) {
            // validation for constraint: itemType
            if (!is_string($ticketingInfoTypeTravelerRefNumberItem)) {
                $invalidValues[] = is_object($ticketingInfoTypeTravelerRefNumberItem) ? get_class($ticketingInfoTypeTravelerRefNumberItem) : sprintf('%s(%s)', gettype($ticketingInfoTypeTravelerRefNumberItem), var_export($ticketingInfoTypeTravelerRefNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelerRefNumber property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelerRefNumber value
     * @param string[] $travelerRefNumber
     * @return \StructType\TicketingInfoType
     */
    public function setTravelerRefNumber(array $travelerRefNumber = array())
    {
        // validation for constraint: list
        if ('' !== ($travelerRefNumberArrayErrorMessage = self::validateTravelerRefNumberForArrayConstraintsFromSetTravelerRefNumber($travelerRefNumber))) {
            throw new \InvalidArgumentException($travelerRefNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($travelerRefNumber) && !preg_match('/[0-9]{1,8}/', $travelerRefNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($travelerRefNumber, true)), __LINE__);
        }
        $this->TravelerRefNumber = is_array($travelerRefNumber) ? implode(' ', $travelerRefNumber) : null;
        return $this;
    }
    /**
     * Get ReverseTktgSegmentsInd value
     * @return bool|null
     */
    public function getReverseTktgSegmentsInd()
    {
        return $this->ReverseTktgSegmentsInd;
    }
    /**
     * Set ReverseTktgSegmentsInd value
     * @param bool $reverseTktgSegmentsInd
     * @return \StructType\TicketingInfoType
     */
    public function setReverseTktgSegmentsInd($reverseTktgSegmentsInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($reverseTktgSegmentsInd) && !is_bool($reverseTktgSegmentsInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reverseTktgSegmentsInd, true), gettype($reverseTktgSegmentsInd)), __LINE__);
        }
        $this->ReverseTktgSegmentsInd = $reverseTktgSegmentsInd;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \StructType\TicketingInfoType
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($pseudoCityCode) && !is_string($pseudoCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pseudoCityCode, true), gettype($pseudoCityCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($pseudoCityCode) && mb_strlen($pseudoCityCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($pseudoCityCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pseudoCityCode) && mb_strlen($pseudoCityCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pseudoCityCode)), __LINE__);
        }
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get RequestedTicketingDate value
     * @return string|null
     */
    public function getRequestedTicketingDate()
    {
        return $this->RequestedTicketingDate;
    }
    /**
     * This method is responsible for validating the value passed to the setRequestedTicketingDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequestedTicketingDate method
     * This is a set of validation rules based on the union types associated to the property being set by the setRequestedTicketingDate method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequestedTicketingDateForUnionConstraintsFromSetRequestedTicketingDate($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set RequestedTicketingDate value
     * @param string $requestedTicketingDate
     * @return \StructType\TicketingInfoType
     */
    public function setRequestedTicketingDate($requestedTicketingDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestedTicketingDate) && !is_string($requestedTicketingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedTicketingDate, true), gettype($requestedTicketingDate)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($requestedTicketingDateUnionErrorMessage = self::validateRequestedTicketingDateForUnionConstraintsFromSetRequestedTicketingDate($requestedTicketingDate))) {
            throw new \InvalidArgumentException($requestedTicketingDateUnionErrorMessage, __LINE__);
        }
        $this->RequestedTicketingDate = $requestedTicketingDate;
        return $this;
    }
    /**
     * Get TimeLimitMinutes value
     * @return int|null
     */
    public function getTimeLimitMinutes()
    {
        return $this->TimeLimitMinutes;
    }
    /**
     * Set TimeLimitMinutes value
     * @param int $timeLimitMinutes
     * @return \StructType\TicketingInfoType
     */
    public function setTimeLimitMinutes($timeLimitMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($timeLimitMinutes) && !(is_int($timeLimitMinutes) || ctype_digit($timeLimitMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeLimitMinutes, true), gettype($timeLimitMinutes)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($timeLimitMinutes) && $timeLimitMinutes > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($timeLimitMinutes, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($timeLimitMinutes) && $timeLimitMinutes < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($timeLimitMinutes, true)), __LINE__);
        }
        $this->TimeLimitMinutes = $timeLimitMinutes;
        return $this;
    }
    /**
     * Get BookingChangeType value
     * @return string|null
     */
    public function getBookingChangeType()
    {
        return $this->BookingChangeType;
    }
    /**
     * Set BookingChangeType value
     * @param string $bookingChangeType
     * @return \StructType\TicketingInfoType
     */
    public function setBookingChangeType($bookingChangeType = null)
    {
        // validation for constraint: string
        if (!is_null($bookingChangeType) && !is_string($bookingChangeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingChangeType, true), gettype($bookingChangeType)), __LINE__);
        }
        $this->BookingChangeType = $bookingChangeType;
        return $this;
    }
    /**
     * Get TicketDocumentNbr value
     * @return string|null
     */
    public function getTicketDocumentNbr()
    {
        return $this->TicketDocumentNbr;
    }
    /**
     * Set TicketDocumentNbr value
     * @param string $ticketDocumentNbr
     * @return \StructType\TicketingInfoType
     */
    public function setTicketDocumentNbr($ticketDocumentNbr = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDocumentNbr) && !is_string($ticketDocumentNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDocumentNbr, true), gettype($ticketDocumentNbr)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($ticketDocumentNbr) && mb_strlen($ticketDocumentNbr) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($ticketDocumentNbr)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ticketDocumentNbr) && mb_strlen($ticketDocumentNbr) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ticketDocumentNbr)), __LINE__);
        }
        $this->TicketDocumentNbr = $ticketDocumentNbr;
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \StructType\TicketingInfoType
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($passengerTypeCode) && !is_string($passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerTypeCode, true), gettype($passengerTypeCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($passengerTypeCode) && !preg_match('/[a-zA-Z]{3}/', $passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($passengerTypeCode, true)), __LINE__);
        }
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\TicketingInfoType
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get MiscTicketingCode value
     * @return string[]|null
     */
    public function getMiscTicketingCode()
    {
        return $this->MiscTicketingCode;
    }
    /**
     * This method is responsible for validating the values passed to the setMiscTicketingCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiscTicketingCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiscTicketingCodeForArrayConstraintsFromSetMiscTicketingCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketingInfoTypeMiscTicketingCodeItem) {
            // validation for constraint: itemType
            if (!is_string($ticketingInfoTypeMiscTicketingCodeItem)) {
                $invalidValues[] = is_object($ticketingInfoTypeMiscTicketingCodeItem) ? get_class($ticketingInfoTypeMiscTicketingCodeItem) : sprintf('%s(%s)', gettype($ticketingInfoTypeMiscTicketingCodeItem), var_export($ticketingInfoTypeMiscTicketingCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MiscTicketingCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MiscTicketingCode value
     * @param string[] $miscTicketingCode
     * @return \StructType\TicketingInfoType
     */
    public function setMiscTicketingCode(array $miscTicketingCode = array())
    {
        // validation for constraint: list
        if ('' !== ($miscTicketingCodeArrayErrorMessage = self::validateMiscTicketingCodeForArrayConstraintsFromSetMiscTicketingCode($miscTicketingCode))) {
            throw new \InvalidArgumentException($miscTicketingCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($miscTicketingCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $miscTicketingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($miscTicketingCode, true)), __LINE__);
        }
        $this->MiscTicketingCode = is_array($miscTicketingCode) ? implode(' ', $miscTicketingCode) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketingInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
