<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TelephoneInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about a telephone number, including the actual number and its usage. | Information on a telephone number. | Provides details of a telephone number. | Information on a telephone number for the company.
 * @subpackage Structs
 */
class TelephoneInfo extends AbstractStructBase
{
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - documentation: Telephone number assigned to a single location. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: required
     * @var string
     */
    public $PhoneNumber;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Used elsewhere in the message to reference a specific telephone number (including faxes). | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual
     * passengers or clients to particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - type: RPH_Type
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The PhoneLocationType
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Phone Location Type (PLT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $PhoneLocationType;
    /**
     * The PhoneTechType
     * Meta information extracted from the WSDL
     * - documentation: Indicates type of technology associated with this telephone number, such as Voice, Data, Fax, Pager, Mobile, TTY, etc. Refer to OpenTravel Code List Phone Technology Type (PTT). | Used for codes in the OpenTravel Code tables.
     * Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $PhoneTechType;
    /**
     * The PhoneUseType
     * Meta information extracted from the WSDL
     * - documentation: Describes the type of telephone number, in the context of its general use (e.g. Home, Business, Emergency Contact, Travel Arranger, Day, Evening). Refer to OpenTravel Code List Phone Use Type (PUT). | Used for codes in the OpenTravel
     * Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $PhoneUseType;
    /**
     * The CountryAccessCode
     * Meta information extracted from the WSDL
     * - documentation: Code assigned by telecommunications authorities for international country access identifier. | Used for Numeric Strings length 1 to 3.
     * - base: xs:string
     * - pattern: [0-9]{1,3}
     * - type: NumericStringLength1to3
     * - use: optional
     * @var string
     */
    public $CountryAccessCode;
    /**
     * The AreaCityCode
     * Meta information extracted from the WSDL
     * - documentation: Code assigned for telephones in a specific region, city, or area. | Used for Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - type: NumericStringLength1to8
     * - use: optional
     * @var string
     */
    public $AreaCityCode;
    /**
     * The Extension
     * Meta information extracted from the WSDL
     * - documentation: Extension to reach a specific party at the phone number. | Used for Numeric Strings, length 1 to 5.
     * - base: xs:string
     * - pattern: [0-9]{1,5}
     * - type: NumericStringLength1to5
     * - use: optional
     * @var string
     */
    public $Extension;
    /**
     * The PIN
     * Meta information extracted from the WSDL
     * - documentation: Additional codes used for pager or telephone access rights. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $PIN;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: A remark associated with the telephone number. | Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * - type: StringLength1to128
     * - use: optional
     * @var string
     */
    public $Remark;
    /**
     * The FormattedInd
     * Meta information extracted from the WSDL
     * - documentation: false | Specifies if the associated data is formatted or not. When true, then it is formatted; when false, then not formatted.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $FormattedInd;
    /**
     * The DefaultInd
     * Meta information extracted from the WSDL
     * - documentation: false | When true, indicates a default value should be used.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $DefaultInd;
    /**
     * The TransferAction
     * Meta information extracted from the WSDL
     * - documentation: Indicates under what conditions the element will be transfered to the booking.
     * - use: optional
     * @var string
     */
    public $TransferAction;
    /**
     * Constructor method for TelephoneInfo
     * @uses TelephoneInfo::setPhoneNumber()
     * @uses TelephoneInfo::setRPH()
     * @uses TelephoneInfo::setShareSynchInd()
     * @uses TelephoneInfo::setShareMarketInd()
     * @uses TelephoneInfo::setPhoneLocationType()
     * @uses TelephoneInfo::setPhoneTechType()
     * @uses TelephoneInfo::setPhoneUseType()
     * @uses TelephoneInfo::setCountryAccessCode()
     * @uses TelephoneInfo::setAreaCityCode()
     * @uses TelephoneInfo::setExtension()
     * @uses TelephoneInfo::setPIN()
     * @uses TelephoneInfo::setRemark()
     * @uses TelephoneInfo::setFormattedInd()
     * @uses TelephoneInfo::setDefaultInd()
     * @uses TelephoneInfo::setTransferAction()
     * @param string $phoneNumber
     * @param string $rPH
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $phoneLocationType
     * @param string $phoneTechType
     * @param string $phoneUseType
     * @param string $countryAccessCode
     * @param string $areaCityCode
     * @param string $extension
     * @param string $pIN
     * @param string $remark
     * @param bool $formattedInd
     * @param bool $defaultInd
     * @param string $transferAction
     */
    public function __construct($phoneNumber = null, $rPH = null, $shareSynchInd = null, $shareMarketInd = null, $phoneLocationType = null, $phoneTechType = null, $phoneUseType = null, $countryAccessCode = null, $areaCityCode = null, $extension = null, $pIN = null, $remark = null, $formattedInd = null, $defaultInd = null, $transferAction = null)
    {
        $this
            ->setPhoneNumber($phoneNumber)
            ->setRPH($rPH)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setPhoneLocationType($phoneLocationType)
            ->setPhoneTechType($phoneTechType)
            ->setPhoneUseType($phoneUseType)
            ->setCountryAccessCode($countryAccessCode)
            ->setAreaCityCode($areaCityCode)
            ->setExtension($extension)
            ->setPIN($pIN)
            ->setRemark($remark)
            ->setFormattedInd($formattedInd)
            ->setDefaultInd($defaultInd)
            ->setTransferAction($transferAction);
    }
    /**
     * Get PhoneNumber value
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\TelephoneInfo
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($phoneNumber) && mb_strlen($phoneNumber) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($phoneNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($phoneNumber) && mb_strlen($phoneNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\TelephoneInfo
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\TelephoneInfo
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\TelephoneInfo
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get PhoneLocationType value
     * @return string|null
     */
    public function getPhoneLocationType()
    {
        return $this->PhoneLocationType;
    }
    /**
     * Set PhoneLocationType value
     * @param string $phoneLocationType
     * @return \StructType\TelephoneInfo
     */
    public function setPhoneLocationType($phoneLocationType = null)
    {
        // validation for constraint: string
        if (!is_null($phoneLocationType) && !is_string($phoneLocationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneLocationType, true), gettype($phoneLocationType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($phoneLocationType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $phoneLocationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($phoneLocationType, true)), __LINE__);
        }
        $this->PhoneLocationType = $phoneLocationType;
        return $this;
    }
    /**
     * Get PhoneTechType value
     * @return string|null
     */
    public function getPhoneTechType()
    {
        return $this->PhoneTechType;
    }
    /**
     * Set PhoneTechType value
     * @param string $phoneTechType
     * @return \StructType\TelephoneInfo
     */
    public function setPhoneTechType($phoneTechType = null)
    {
        // validation for constraint: string
        if (!is_null($phoneTechType) && !is_string($phoneTechType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneTechType, true), gettype($phoneTechType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($phoneTechType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $phoneTechType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($phoneTechType, true)), __LINE__);
        }
        $this->PhoneTechType = $phoneTechType;
        return $this;
    }
    /**
     * Get PhoneUseType value
     * @return string|null
     */
    public function getPhoneUseType()
    {
        return $this->PhoneUseType;
    }
    /**
     * Set PhoneUseType value
     * @param string $phoneUseType
     * @return \StructType\TelephoneInfo
     */
    public function setPhoneUseType($phoneUseType = null)
    {
        // validation for constraint: string
        if (!is_null($phoneUseType) && !is_string($phoneUseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneUseType, true), gettype($phoneUseType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($phoneUseType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $phoneUseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($phoneUseType, true)), __LINE__);
        }
        $this->PhoneUseType = $phoneUseType;
        return $this;
    }
    /**
     * Get CountryAccessCode value
     * @return string|null
     */
    public function getCountryAccessCode()
    {
        return $this->CountryAccessCode;
    }
    /**
     * Set CountryAccessCode value
     * @param string $countryAccessCode
     * @return \StructType\TelephoneInfo
     */
    public function setCountryAccessCode($countryAccessCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryAccessCode) && !is_string($countryAccessCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryAccessCode, true), gettype($countryAccessCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,3})
        if (!is_null($countryAccessCode) && !preg_match('/[0-9]{1,3}/', $countryAccessCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,3}', var_export($countryAccessCode, true)), __LINE__);
        }
        $this->CountryAccessCode = $countryAccessCode;
        return $this;
    }
    /**
     * Get AreaCityCode value
     * @return string|null
     */
    public function getAreaCityCode()
    {
        return $this->AreaCityCode;
    }
    /**
     * Set AreaCityCode value
     * @param string $areaCityCode
     * @return \StructType\TelephoneInfo
     */
    public function setAreaCityCode($areaCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($areaCityCode) && !is_string($areaCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaCityCode, true), gettype($areaCityCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($areaCityCode) && !preg_match('/[0-9]{1,8}/', $areaCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($areaCityCode, true)), __LINE__);
        }
        $this->AreaCityCode = $areaCityCode;
        return $this;
    }
    /**
     * Get Extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->Extension;
    }
    /**
     * Set Extension value
     * @param string $extension
     * @return \StructType\TelephoneInfo
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension, true), gettype($extension)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,5})
        if (!is_null($extension) && !preg_match('/[0-9]{1,5}/', $extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,5}', var_export($extension, true)), __LINE__);
        }
        $this->Extension = $extension;
        return $this;
    }
    /**
     * Get PIN value
     * @return string|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param string $pIN
     * @return \StructType\TelephoneInfo
     */
    public function setPIN($pIN = null)
    {
        // validation for constraint: string
        if (!is_null($pIN) && !is_string($pIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIN, true), gettype($pIN)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($pIN) && mb_strlen($pIN) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($pIN)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pIN) && mb_strlen($pIN) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pIN)), __LINE__);
        }
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\TelephoneInfo
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($remark) && mb_strlen($remark) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($remark)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($remark) && mb_strlen($remark) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get FormattedInd value
     * @return bool|null
     */
    public function getFormattedInd()
    {
        return $this->FormattedInd;
    }
    /**
     * Set FormattedInd value
     * @param bool $formattedInd
     * @return \StructType\TelephoneInfo
     */
    public function setFormattedInd($formattedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($formattedInd) && !is_bool($formattedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($formattedInd, true), gettype($formattedInd)), __LINE__);
        }
        $this->FormattedInd = $formattedInd;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \StructType\TelephoneInfo
     */
    public function setDefaultInd($defaultInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultInd, true), gettype($defaultInd)), __LINE__);
        }
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Get TransferAction value
     * @return string|null
     */
    public function getTransferAction()
    {
        return $this->TransferAction;
    }
    /**
     * Set TransferAction value
     * @uses \EnumType\TransferActionType::valueIsValid()
     * @uses \EnumType\TransferActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferAction
     * @return \StructType\TelephoneInfo
     */
    public function setTransferAction($transferAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransferActionType::valueIsValid($transferAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransferActionType', is_array($transferAction) ? implode(', ', $transferAction) : var_export($transferAction, true), implode(', ', \EnumType\TransferActionType::getValidValues())), __LINE__);
        }
        $this->TransferAction = $transferAction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TelephoneInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
