<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxRegistrationDetails StructType
 * Meta information extracted from the WSDL
 * - documentation: Ticketing Goods and Services Tax (GST) details (typically the Australian market).
 * @subpackage Structs
 */
class TaxRegistrationDetails extends AbstractStructBase
{
    /**
     * The TaxID
     * Meta information extracted from the WSDL
     * - documentation: The tax registration identifier e.g., Australian Business Number (ABN). | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TaxID;
    /**
     * The RecipientName
     * Meta information extracted from the WSDL
     * - documentation: The recipient's name. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RecipientName;
    /**
     * The RecipientAddress
     * Meta information extracted from the WSDL
     * - documentation: Free text for the recipient's address. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RecipientAddress;
    /**
     * Constructor method for TaxRegistrationDetails
     * @uses TaxRegistrationDetails::setTaxID()
     * @uses TaxRegistrationDetails::setRecipientName()
     * @uses TaxRegistrationDetails::setRecipientAddress()
     * @param string $taxID
     * @param string $recipientName
     * @param string $recipientAddress
     */
    public function __construct($taxID = null, $recipientName = null, $recipientAddress = null)
    {
        $this
            ->setTaxID($taxID)
            ->setRecipientName($recipientName)
            ->setRecipientAddress($recipientAddress);
    }
    /**
     * Get TaxID value
     * @return string|null
     */
    public function getTaxID()
    {
        return $this->TaxID;
    }
    /**
     * Set TaxID value
     * @param string $taxID
     * @return \StructType\TaxRegistrationDetails
     */
    public function setTaxID($taxID = null)
    {
        // validation for constraint: string
        if (!is_null($taxID) && !is_string($taxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxID, true), gettype($taxID)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($taxID) && mb_strlen($taxID) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($taxID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($taxID) && mb_strlen($taxID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($taxID)), __LINE__);
        }
        $this->TaxID = $taxID;
        return $this;
    }
    /**
     * Get RecipientName value
     * @return string|null
     */
    public function getRecipientName()
    {
        return $this->RecipientName;
    }
    /**
     * Set RecipientName value
     * @param string $recipientName
     * @return \StructType\TaxRegistrationDetails
     */
    public function setRecipientName($recipientName = null)
    {
        // validation for constraint: string
        if (!is_null($recipientName) && !is_string($recipientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientName, true), gettype($recipientName)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($recipientName) && mb_strlen($recipientName) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($recipientName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($recipientName) && mb_strlen($recipientName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($recipientName)), __LINE__);
        }
        $this->RecipientName = $recipientName;
        return $this;
    }
    /**
     * Get RecipientAddress value
     * @return string|null
     */
    public function getRecipientAddress()
    {
        return $this->RecipientAddress;
    }
    /**
     * Set RecipientAddress value
     * @param string $recipientAddress
     * @return \StructType\TaxRegistrationDetails
     */
    public function setRecipientAddress($recipientAddress = null)
    {
        // validation for constraint: string
        if (!is_null($recipientAddress) && !is_string($recipientAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientAddress, true), gettype($recipientAddress)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($recipientAddress) && mb_strlen($recipientAddress) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($recipientAddress)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($recipientAddress) && mb_strlen($recipientAddress) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($recipientAddress)), __LINE__);
        }
        $this->RecipientAddress = $recipientAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxRegistrationDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
