<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxAmounts StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of one or more taxes associated with a specific charge.
 * @subpackage Structs
 */
class TaxAmounts extends AbstractStructBase
{
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\TaxAmount[]
     */
    public $TaxAmount;
    /**
     * Constructor method for TaxAmounts
     * @uses TaxAmounts::setTaxAmount()
     * @param \StructType\TaxAmount[] $taxAmount
     */
    public function __construct(array $taxAmount = array())
    {
        $this
            ->setTaxAmount($taxAmount);
    }
    /**
     * Get TaxAmount value
     * @return \StructType\TaxAmount[]|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxAmountForArrayConstraintsFromSetTaxAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxAmountsTaxAmountItem) {
            // validation for constraint: itemType
            if (!$taxAmountsTaxAmountItem instanceof \StructType\TaxAmount) {
                $invalidValues[] = is_object($taxAmountsTaxAmountItem) ? get_class($taxAmountsTaxAmountItem) : sprintf('%s(%s)', gettype($taxAmountsTaxAmountItem), var_export($taxAmountsTaxAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxAmount property can only contain items of type \StructType\TaxAmount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxAmount[] $taxAmount
     * @return \StructType\TaxAmounts
     */
    public function setTaxAmount(array $taxAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($taxAmountArrayErrorMessage = self::validateTaxAmountForArrayConstraintsFromSetTaxAmount($taxAmount))) {
            throw new \InvalidArgumentException($taxAmountArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($taxAmount) && count($taxAmount) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Add item to TaxAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxAmount $item
     * @return \StructType\TaxAmounts
     */
    public function addToTaxAmount(\StructType\TaxAmount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxAmount) {
            throw new \InvalidArgumentException(sprintf('The TaxAmount property can only contain items of type \StructType\TaxAmount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->TaxAmount) && count($this->TaxAmount) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->TaxAmount)), __LINE__);
        }
        $this->TaxAmount[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxAmounts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
