<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax StructType
 * Meta information extracted from the WSDL
 * - documentation: This element is used to describe one specific tax that may apply.
 * @subpackage Structs
 */
class Tax extends AbstractStructBase
{
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - documentation: Information on this one specific tax, including a description, etc.
     * - minOccurs: 0
     * @var \StructType\FormattedTextType
     */
    public $Info;
    /**
     * The TaxCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TaxCode;
    /**
     * The Percentage
     * Meta information extracted from the WSDL
     * - documentation: Used for percentage values.
     * - base: xs:decimal
     * - maxInclusive: 100.00
     * - minInclusive: 0.00
     * - type: Percentage
     * - use: optional
     * @var float
     */
    public $Percentage;
    /**
     * Constructor method for Tax
     * @uses Tax::setInfo()
     * @uses Tax::setTaxCode()
     * @uses Tax::setPercentage()
     * @param \StructType\FormattedTextType $info
     * @param string $taxCode
     * @param float $percentage
     */
    public function __construct(\StructType\FormattedTextType $info = null, $taxCode = null, $percentage = null)
    {
        $this
            ->setInfo($info)
            ->setTaxCode($taxCode)
            ->setPercentage($percentage);
    }
    /**
     * Get Info value
     * @return \StructType\FormattedTextType|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param \StructType\FormattedTextType $info
     * @return \StructType\Tax
     */
    public function setInfo(\StructType\FormattedTextType $info = null)
    {
        $this->Info = $info;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \StructType\Tax
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCode, true), gettype($taxCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($taxCode) && mb_strlen($taxCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($taxCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($taxCode) && mb_strlen($taxCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($taxCode)), __LINE__);
        }
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get Percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param float $percentage
     * @return \StructType\Tax
     */
    public function setPercentage($percentage = null)
    {
        // validation for constraint: float
        if (!is_null($percentage) && !(is_float($percentage) || is_numeric($percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentage, true), gettype($percentage)), __LINE__);
        }
        // validation for constraint: maxInclusive(100.00)
        if (!is_null($percentage) && $percentage > 100.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100.00', var_export($percentage, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($percentage) && $percentage < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($percentage, true)), __LINE__);
        }
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Tax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
