<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StreetNmbr StructType
 * Meta information extracted from the WSDL
 * - documentation: May contain the street number and optionally the street name.
 * @subpackage Structs
 */
class StreetNmbr extends StreetNmbrType
{
    /**
     * The _
     * @var \StructType\StreetNmbrType
     */
    public $_;
    /**
     * The StreetNmbrSuffix
     * Meta information extracted from the WSDL
     * - documentation: Usually a letter right after the street number (A in 66-A, B in 123-B etc). | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $StreetNmbrSuffix;
    /**
     * The StreetDirection
     * Meta information extracted from the WSDL
     * - documentation: Street direction of an address (e.g., N, E, S, NW, SW). | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $StreetDirection;
    /**
     * The RuralRouteNmbr
     * Meta information extracted from the WSDL
     * - documentation: Numerical equivalent of a rural township as defined within a given area (e.g., 12, 99). | Used for Numeric Strings, length 1 to 5.
     * - base: xs:string
     * - pattern: [0-9]{1,5}
     * - use: optional
     * @var string
     */
    public $RuralRouteNmbr;
    /**
     * Constructor method for StreetNmbr
     * @uses StreetNmbr::set_()
     * @uses StreetNmbr::setStreetNmbrSuffix()
     * @uses StreetNmbr::setStreetDirection()
     * @uses StreetNmbr::setRuralRouteNmbr()
     * @param \StructType\StreetNmbrType $_
     * @param string $streetNmbrSuffix
     * @param string $streetDirection
     * @param string $ruralRouteNmbr
     */
    public function __construct(\StructType\StreetNmbrType $_ = null, $streetNmbrSuffix = null, $streetDirection = null, $ruralRouteNmbr = null)
    {
        $this
            ->set_($_)
            ->setStreetNmbrSuffix($streetNmbrSuffix)
            ->setStreetDirection($streetDirection)
            ->setRuralRouteNmbr($ruralRouteNmbr);
    }
    /**
     * Get _ value
     * @return \StructType\StreetNmbrType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\StreetNmbrType $_
     * @return \StructType\StreetNmbr
     */
    public function set_(\StructType\StreetNmbrType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get StreetNmbrSuffix value
     * @return string|null
     */
    public function getStreetNmbrSuffix()
    {
        return $this->StreetNmbrSuffix;
    }
    /**
     * Set StreetNmbrSuffix value
     * @param string $streetNmbrSuffix
     * @return \StructType\StreetNmbr
     */
    public function setStreetNmbrSuffix($streetNmbrSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($streetNmbrSuffix) && !is_string($streetNmbrSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetNmbrSuffix, true), gettype($streetNmbrSuffix)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($streetNmbrSuffix) && mb_strlen($streetNmbrSuffix) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($streetNmbrSuffix)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($streetNmbrSuffix) && mb_strlen($streetNmbrSuffix) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($streetNmbrSuffix)), __LINE__);
        }
        $this->StreetNmbrSuffix = $streetNmbrSuffix;
        return $this;
    }
    /**
     * Get StreetDirection value
     * @return string|null
     */
    public function getStreetDirection()
    {
        return $this->StreetDirection;
    }
    /**
     * Set StreetDirection value
     * @param string $streetDirection
     * @return \StructType\StreetNmbr
     */
    public function setStreetDirection($streetDirection = null)
    {
        // validation for constraint: string
        if (!is_null($streetDirection) && !is_string($streetDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetDirection, true), gettype($streetDirection)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($streetDirection) && mb_strlen($streetDirection) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($streetDirection)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($streetDirection) && mb_strlen($streetDirection) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($streetDirection)), __LINE__);
        }
        $this->StreetDirection = $streetDirection;
        return $this;
    }
    /**
     * Get RuralRouteNmbr value
     * @return string|null
     */
    public function getRuralRouteNmbr()
    {
        return $this->RuralRouteNmbr;
    }
    /**
     * Set RuralRouteNmbr value
     * @param string $ruralRouteNmbr
     * @return \StructType\StreetNmbr
     */
    public function setRuralRouteNmbr($ruralRouteNmbr = null)
    {
        // validation for constraint: string
        if (!is_null($ruralRouteNmbr) && !is_string($ruralRouteNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruralRouteNmbr, true), gettype($ruralRouteNmbr)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,5})
        if (!is_null($ruralRouteNmbr) && !preg_match('/[0-9]{1,5}/', $ruralRouteNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,5}', var_export($ruralRouteNmbr, true)), __LINE__);
        }
        $this->RuralRouteNmbr = $ruralRouteNmbr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StreetNmbr
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
