<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StayInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: The StayInfo class contains the guest revenue and stay data to be sent to the central server.
 * @subpackage Structs
 */
class StayInfoType extends AbstractStructBase
{
    /**
     * The LoyaltyPointsAccruals
     * Meta information extracted from the WSDL
     * - documentation: A collection of loyalty points accruals.
     * - minOccurs: 0
     * @var \StructType\LoyaltyPointsAccrualsType
     */
    public $LoyaltyPointsAccruals;
    /**
     * The RevenueCategories
     * Meta information extracted from the WSDL
     * - documentation: A collection of RevenueCategory classes that detail the categories of revenue data associated with the StayInfo report.
     * - minOccurs: 0
     * @var \StructType\RevenueCategoriesType
     */
    public $RevenueCategories;
    /**
     * The ReservationID
     * Meta information extracted from the WSDL
     * - documentation: The confirmation number of the reservation associated with the stay.
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $ReservationID;
    /**
     * The HotelReservation
     * Meta information extracted from the WSDL
     * - documentation: Contains the reservation details associated with the stay information.
     * - minOccurs: 0
     * @var \StructType\HotelReservationType
     */
    public $HotelReservation;
    /**
     * The SequenceNumber
     * Meta information extracted from the WSDL
     * - documentation: Used to sequence the guest revenue blocks of data used to verify transmission.
     * - use: optional
     * @var int
     */
    public $SequenceNumber;
    /**
     * The RoomStayRPH
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $RoomStayRPH;
    /**
     * Constructor method for StayInfoType
     * @uses StayInfoType::setLoyaltyPointsAccruals()
     * @uses StayInfoType::setRevenueCategories()
     * @uses StayInfoType::setReservationID()
     * @uses StayInfoType::setHotelReservation()
     * @uses StayInfoType::setSequenceNumber()
     * @uses StayInfoType::setRoomStayRPH()
     * @param \StructType\LoyaltyPointsAccrualsType $loyaltyPointsAccruals
     * @param \StructType\RevenueCategoriesType $revenueCategories
     * @param \StructType\UniqueID_Type $reservationID
     * @param \StructType\HotelReservationType $hotelReservation
     * @param int $sequenceNumber
     * @param int $roomStayRPH
     */
    public function __construct(\StructType\LoyaltyPointsAccrualsType $loyaltyPointsAccruals = null, \StructType\RevenueCategoriesType $revenueCategories = null, \StructType\UniqueID_Type $reservationID = null, \StructType\HotelReservationType $hotelReservation = null, $sequenceNumber = null, $roomStayRPH = null)
    {
        $this
            ->setLoyaltyPointsAccruals($loyaltyPointsAccruals)
            ->setRevenueCategories($revenueCategories)
            ->setReservationID($reservationID)
            ->setHotelReservation($hotelReservation)
            ->setSequenceNumber($sequenceNumber)
            ->setRoomStayRPH($roomStayRPH);
    }
    /**
     * Get LoyaltyPointsAccruals value
     * @return \StructType\LoyaltyPointsAccrualsType|null
     */
    public function getLoyaltyPointsAccruals()
    {
        return $this->LoyaltyPointsAccruals;
    }
    /**
     * Set LoyaltyPointsAccruals value
     * @param \StructType\LoyaltyPointsAccrualsType $loyaltyPointsAccruals
     * @return \StructType\StayInfoType
     */
    public function setLoyaltyPointsAccruals(\StructType\LoyaltyPointsAccrualsType $loyaltyPointsAccruals = null)
    {
        $this->LoyaltyPointsAccruals = $loyaltyPointsAccruals;
        return $this;
    }
    /**
     * Get RevenueCategories value
     * @return \StructType\RevenueCategoriesType|null
     */
    public function getRevenueCategories()
    {
        return $this->RevenueCategories;
    }
    /**
     * Set RevenueCategories value
     * @param \StructType\RevenueCategoriesType $revenueCategories
     * @return \StructType\StayInfoType
     */
    public function setRevenueCategories(\StructType\RevenueCategoriesType $revenueCategories = null)
    {
        $this->RevenueCategories = $revenueCategories;
        return $this;
    }
    /**
     * Get ReservationID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getReservationID()
    {
        return $this->ReservationID;
    }
    /**
     * Set ReservationID value
     * @param \StructType\UniqueID_Type $reservationID
     * @return \StructType\StayInfoType
     */
    public function setReservationID(\StructType\UniqueID_Type $reservationID = null)
    {
        $this->ReservationID = $reservationID;
        return $this;
    }
    /**
     * Get HotelReservation value
     * @return \StructType\HotelReservationType|null
     */
    public function getHotelReservation()
    {
        return $this->HotelReservation;
    }
    /**
     * Set HotelReservation value
     * @param \StructType\HotelReservationType $hotelReservation
     * @return \StructType\StayInfoType
     */
    public function setHotelReservation(\StructType\HotelReservationType $hotelReservation = null)
    {
        $this->HotelReservation = $hotelReservation;
        return $this;
    }
    /**
     * Get SequenceNumber value
     * @return int|null
     */
    public function getSequenceNumber()
    {
        return $this->SequenceNumber;
    }
    /**
     * Set SequenceNumber value
     * @param int $sequenceNumber
     * @return \StructType\StayInfoType
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNumber) && !(is_int($sequenceNumber) || ctype_digit($sequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenceNumber, true), gettype($sequenceNumber)), __LINE__);
        }
        $this->SequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Get RoomStayRPH value
     * @return int|null
     */
    public function getRoomStayRPH()
    {
        return $this->RoomStayRPH;
    }
    /**
     * Set RoomStayRPH value
     * @param int $roomStayRPH
     * @return \StructType\StayInfoType
     */
    public function setRoomStayRPH($roomStayRPH = null)
    {
        // validation for constraint: int
        if (!is_null($roomStayRPH) && !(is_int($roomStayRPH) || ctype_digit($roomStayRPH))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roomStayRPH, true), gettype($roomStayRPH)), __LINE__);
        }
        $this->RoomStayRPH = $roomStayRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StayInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
