<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialRemarkType StructType
 * Meta information extracted from the WSDL
 * - documentation: Itinerary Remarks, Invoice Remarks, etc.
 * @subpackage Structs
 */
class SpecialRemarkType extends AbstractStructBase
{
    /**
     * The RemarkType
     * Meta information extracted from the WSDL
     * - documentation: Type of special remark used (e.g., itinerary remark, invoice remark). Refer to OpenTravel Code List Special Remark Option Type (SRO). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101,
     * 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: required
     * @var string
     */
    public $RemarkType;
    /**
     * The TravelerRefNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TravelerRefNumber[]
     */
    public $TravelerRefNumber;
    /**
     * The FlightRefNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\FlightRefNumber[]
     */
    public $FlightRefNumber;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: Text associated with remark
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The Airline
     * Meta information extracted from the WSDL
     * - documentation: Denotes the receiver (or target) airline(s) for the remark.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\CompanyNameType[]
     */
    public $Airline;
    /**
     * The AuthorizedViewers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AuthorizedViewers
     */
    public $AuthorizedViewers;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Used to further define the remark type. | Used for Alpha-Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,8}
     * - use: optional
     * @var string
     */
    public $ID;
    /**
     * Constructor method for SpecialRemarkType
     * @uses SpecialRemarkType::setRemarkType()
     * @uses SpecialRemarkType::setTravelerRefNumber()
     * @uses SpecialRemarkType::setFlightRefNumber()
     * @uses SpecialRemarkType::setText()
     * @uses SpecialRemarkType::setAirline()
     * @uses SpecialRemarkType::setAuthorizedViewers()
     * @uses SpecialRemarkType::setID()
     * @param string $remarkType
     * @param \StructType\TravelerRefNumber[] $travelerRefNumber
     * @param \StructType\FlightRefNumber[] $flightRefNumber
     * @param string $text
     * @param \StructType\CompanyNameType[] $airline
     * @param \StructType\AuthorizedViewers $authorizedViewers
     * @param string $iD
     */
    public function __construct($remarkType = null, array $travelerRefNumber = array(), array $flightRefNumber = array(), $text = null, array $airline = array(), \StructType\AuthorizedViewers $authorizedViewers = null, $iD = null)
    {
        $this
            ->setRemarkType($remarkType)
            ->setTravelerRefNumber($travelerRefNumber)
            ->setFlightRefNumber($flightRefNumber)
            ->setText($text)
            ->setAirline($airline)
            ->setAuthorizedViewers($authorizedViewers)
            ->setID($iD);
    }
    /**
     * Get RemarkType value
     * @return string
     */
    public function getRemarkType()
    {
        return $this->RemarkType;
    }
    /**
     * Set RemarkType value
     * @param string $remarkType
     * @return \StructType\SpecialRemarkType
     */
    public function setRemarkType($remarkType = null)
    {
        // validation for constraint: string
        if (!is_null($remarkType) && !is_string($remarkType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarkType, true), gettype($remarkType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($remarkType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $remarkType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($remarkType, true)), __LINE__);
        }
        $this->RemarkType = $remarkType;
        return $this;
    }
    /**
     * Get TravelerRefNumber value
     * @return \StructType\TravelerRefNumber[]|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelerRefNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelerRefNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelerRefNumberForArrayConstraintsFromSetTravelerRefNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specialRemarkTypeTravelerRefNumberItem) {
            // validation for constraint: itemType
            if (!$specialRemarkTypeTravelerRefNumberItem instanceof \StructType\TravelerRefNumber) {
                $invalidValues[] = is_object($specialRemarkTypeTravelerRefNumberItem) ? get_class($specialRemarkTypeTravelerRefNumberItem) : sprintf('%s(%s)', gettype($specialRemarkTypeTravelerRefNumberItem), var_export($specialRemarkTypeTravelerRefNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelerRefNumber property can only contain items of type \StructType\TravelerRefNumber, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelerRefNumber[] $travelerRefNumber
     * @return \StructType\SpecialRemarkType
     */
    public function setTravelerRefNumber(array $travelerRefNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($travelerRefNumberArrayErrorMessage = self::validateTravelerRefNumberForArrayConstraintsFromSetTravelerRefNumber($travelerRefNumber))) {
            throw new \InvalidArgumentException($travelerRefNumberArrayErrorMessage, __LINE__);
        }
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Add item to TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelerRefNumber $item
     * @return \StructType\SpecialRemarkType
     */
    public function addToTravelerRefNumber(\StructType\TravelerRefNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TravelerRefNumber) {
            throw new \InvalidArgumentException(sprintf('The TravelerRefNumber property can only contain items of type \StructType\TravelerRefNumber, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelerRefNumber[] = $item;
        return $this;
    }
    /**
     * Get FlightRefNumber value
     * @return \StructType\FlightRefNumber[]|null
     */
    public function getFlightRefNumber()
    {
        return $this->FlightRefNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightRefNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightRefNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightRefNumberForArrayConstraintsFromSetFlightRefNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specialRemarkTypeFlightRefNumberItem) {
            // validation for constraint: itemType
            if (!$specialRemarkTypeFlightRefNumberItem instanceof \StructType\FlightRefNumber) {
                $invalidValues[] = is_object($specialRemarkTypeFlightRefNumberItem) ? get_class($specialRemarkTypeFlightRefNumberItem) : sprintf('%s(%s)', gettype($specialRemarkTypeFlightRefNumberItem), var_export($specialRemarkTypeFlightRefNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightRefNumber property can only contain items of type \StructType\FlightRefNumber, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightRefNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightRefNumber[] $flightRefNumber
     * @return \StructType\SpecialRemarkType
     */
    public function setFlightRefNumber(array $flightRefNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($flightRefNumberArrayErrorMessage = self::validateFlightRefNumberForArrayConstraintsFromSetFlightRefNumber($flightRefNumber))) {
            throw new \InvalidArgumentException($flightRefNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($flightRefNumber) && count($flightRefNumber) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($flightRefNumber)), __LINE__);
        }
        $this->FlightRefNumber = $flightRefNumber;
        return $this;
    }
    /**
     * Add item to FlightRefNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightRefNumber $item
     * @return \StructType\SpecialRemarkType
     */
    public function addToFlightRefNumber(\StructType\FlightRefNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightRefNumber) {
            throw new \InvalidArgumentException(sprintf('The FlightRefNumber property can only contain items of type \StructType\FlightRefNumber, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->FlightRefNumber) && count($this->FlightRefNumber) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->FlightRefNumber)), __LINE__);
        }
        $this->FlightRefNumber[] = $item;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\SpecialRemarkType
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Airline value
     * @return \StructType\CompanyNameType[]|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * This method is responsible for validating the values passed to the setAirline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineForArrayConstraintsFromSetAirline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specialRemarkTypeAirlineItem) {
            // validation for constraint: itemType
            if (!$specialRemarkTypeAirlineItem instanceof \StructType\CompanyNameType) {
                $invalidValues[] = is_object($specialRemarkTypeAirlineItem) ? get_class($specialRemarkTypeAirlineItem) : sprintf('%s(%s)', gettype($specialRemarkTypeAirlineItem), var_export($specialRemarkTypeAirlineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Airline property can only contain items of type \StructType\CompanyNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Airline value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNameType[] $airline
     * @return \StructType\SpecialRemarkType
     */
    public function setAirline(array $airline = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineArrayErrorMessage = self::validateAirlineForArrayConstraintsFromSetAirline($airline))) {
            throw new \InvalidArgumentException($airlineArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($airline) && count($airline) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($airline)), __LINE__);
        }
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Add item to Airline value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNameType $item
     * @return \StructType\SpecialRemarkType
     */
    public function addToAirline(\StructType\CompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The Airline property can only contain items of type \StructType\CompanyNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Airline) && count($this->Airline) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Airline)), __LINE__);
        }
        $this->Airline[] = $item;
        return $this;
    }
    /**
     * Get AuthorizedViewers value
     * @return \StructType\AuthorizedViewers|null
     */
    public function getAuthorizedViewers()
    {
        return $this->AuthorizedViewers;
    }
    /**
     * Set AuthorizedViewers value
     * @param \StructType\AuthorizedViewers $authorizedViewers
     * @return \StructType\SpecialRemarkType
     */
    public function setAuthorizedViewers(\StructType\AuthorizedViewers $authorizedViewers = null)
    {
        $this->AuthorizedViewers = $authorizedViewers;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\SpecialRemarkType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,8})
        if (!is_null($iD) && !preg_match('/[0-9a-zA-Z]{1,8}/', $iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,8}', var_export($iD, true)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialRemarkType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
