<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialEquipPref StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates a preference for special equipment in a rented car. | A preference for one specific piece of equipment
 * @subpackage Structs
 */
class SpecialEquipPref extends AbstractStructBase
{
    /**
     * The EquipType
     * Meta information extracted from the WSDL
     * - documentation: Identifies the specific type of special equipment. Refer to OpenTravel Code List Equipment Type (EQP). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: required
     * @var string
     */
    public $EquipType;
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - documentation: Identifes an action to take place. Typically used to modify the EquipType and/or Quantity.
     * - type: ActionType
     * - use: optional
     * @var string
     */
    public $Action;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - type: xs:positiveInteger
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for SpecialEquipPref
     * @uses SpecialEquipPref::setEquipType()
     * @uses SpecialEquipPref::setAction()
     * @uses SpecialEquipPref::setQuantity()
     * @uses SpecialEquipPref::setPreferLevel()
     * @param string $equipType
     * @param string $action
     * @param int $quantity
     * @param string $preferLevel
     */
    public function __construct($equipType = null, $action = null, $quantity = null, $preferLevel = null)
    {
        $this
            ->setEquipType($equipType)
            ->setAction($action)
            ->setQuantity($quantity)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get EquipType value
     * @return string
     */
    public function getEquipType()
    {
        return $this->EquipType;
    }
    /**
     * Set EquipType value
     * @param string $equipType
     * @return \StructType\SpecialEquipPref
     */
    public function setEquipType($equipType = null)
    {
        // validation for constraint: string
        if (!is_null($equipType) && !is_string($equipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($equipType, true), gettype($equipType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($equipType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $equipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($equipType, true)), __LINE__);
        }
        $this->EquipType = $equipType;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\SpecialEquipPref
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\SpecialEquipPref
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\SpecialEquipPref
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialEquipPref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
