<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Service StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies services of interest.
 * @subpackage Structs
 */
class Service extends AbstractStructBase
{
    /**
     * The BusinessServiceCode
     * Meta information extracted from the WSDL
     * - documentation: Used to identify a specific business service. Refer to OpenTravel Code list Business Srvc Type (BUS). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $BusinessServiceCode;
    /**
     * The ServiceInventoryCode
     * Meta information extracted from the WSDL
     * - documentation: The representation of the specific service being reserved. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ServiceInventoryCode;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The number of services (e.g., tickets, rounds of golf). | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for Service
     * @uses Service::setBusinessServiceCode()
     * @uses Service::setServiceInventoryCode()
     * @uses Service::setQuantity()
     * @param string $businessServiceCode
     * @param string $serviceInventoryCode
     * @param int $quantity
     */
    public function __construct($businessServiceCode = null, $serviceInventoryCode = null, $quantity = null)
    {
        $this
            ->setBusinessServiceCode($businessServiceCode)
            ->setServiceInventoryCode($serviceInventoryCode)
            ->setQuantity($quantity);
    }
    /**
     * Get BusinessServiceCode value
     * @return string|null
     */
    public function getBusinessServiceCode()
    {
        return $this->BusinessServiceCode;
    }
    /**
     * Set BusinessServiceCode value
     * @param string $businessServiceCode
     * @return \StructType\Service
     */
    public function setBusinessServiceCode($businessServiceCode = null)
    {
        // validation for constraint: string
        if (!is_null($businessServiceCode) && !is_string($businessServiceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessServiceCode, true), gettype($businessServiceCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($businessServiceCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $businessServiceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($businessServiceCode, true)), __LINE__);
        }
        $this->BusinessServiceCode = $businessServiceCode;
        return $this;
    }
    /**
     * Get ServiceInventoryCode value
     * @return string|null
     */
    public function getServiceInventoryCode()
    {
        return $this->ServiceInventoryCode;
    }
    /**
     * Set ServiceInventoryCode value
     * @param string $serviceInventoryCode
     * @return \StructType\Service
     */
    public function setServiceInventoryCode($serviceInventoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceInventoryCode) && !is_string($serviceInventoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceInventoryCode, true), gettype($serviceInventoryCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($serviceInventoryCode) && mb_strlen($serviceInventoryCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($serviceInventoryCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($serviceInventoryCode) && mb_strlen($serviceInventoryCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($serviceInventoryCode)), __LINE__);
        }
        $this->ServiceInventoryCode = $serviceInventoryCode;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\Service
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($quantity) && $quantity > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($quantity, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($quantity) && $quantity < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($quantity, true)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Service
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
