<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SegmentOverride StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to specify a segment that should be overridden.
 * @subpackage Structs
 */
class SegmentOverride extends AbstractStructBase
{
    /**
     * The SegmentNumber
     * Meta information extracted from the WSDL
     * - documentation: Used to specify a segment that should be overridden. | Used for Numeric values, from 1 to 99 inclusive.
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 1
     * - use: required
     * @var int
     */
    public $SegmentNumber;
    /**
     * The SegmentType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $SegmentType;
    /**
     * Constructor method for SegmentOverride
     * @uses SegmentOverride::setSegmentNumber()
     * @uses SegmentOverride::setSegmentType()
     * @param int $segmentNumber
     * @param string $segmentType
     */
    public function __construct($segmentNumber = null, $segmentType = null)
    {
        $this
            ->setSegmentNumber($segmentNumber)
            ->setSegmentType($segmentType);
    }
    /**
     * Get SegmentNumber value
     * @return int
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param int $segmentNumber
     * @return \StructType\SegmentOverride
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($segmentNumber) && !(is_int($segmentNumber) || ctype_digit($segmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($segmentNumber, true), gettype($segmentNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($segmentNumber) && $segmentNumber > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($segmentNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($segmentNumber) && $segmentNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($segmentNumber, true)), __LINE__);
        }
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get SegmentType value
     * @return string
     */
    public function getSegmentType()
    {
        return $this->SegmentType;
    }
    /**
     * Set SegmentType value
     * @param string $segmentType
     * @return \StructType\SegmentOverride
     */
    public function setSegmentType($segmentType = null)
    {
        // validation for constraint: string
        if (!is_null($segmentType) && !is_string($segmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($segmentType, true), gettype($segmentType)), __LINE__);
        }
        $this->SegmentType = $segmentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SegmentOverride
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
