<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatingPrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to indicate a level of preference for seat information. | Identifies a seating preference. | Used for Character Strings, length 0 to 64.
 * - base: xs:string
 * - maxLength: 64
 * - minLength: 0
 * @subpackage Structs
 */
class SeatingPrefType extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 0 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 0
     * @var string
     */
    public $_;
    /**
     * The SeatDirection
     * Meta information extracted from the WSDL
     * - documentation: Direction seat faces during travel, when conveyance allows. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $SeatDirection;
    /**
     * The SeatLocation
     * Meta information extracted from the WSDL
     * - documentation: Location of seat in cabin of conveyance. Suggested values include: Forward, Middle, Aft, ExitRow, Bulkhead, Right or Left Side, etc.
     * - use: optional
     * @var string
     */
    public $SeatLocation;
    /**
     * The SeatPosition
     * Meta information extracted from the WSDL
     * - documentation: Preferred position of seat in a row, such as Aisle, Middle, Center, Window, etc.
     * - use: optional
     * @var string
     */
    public $SeatPosition;
    /**
     * The SeatRow
     * Meta information extracted from the WSDL
     * - documentation: Preferred row for seating, indicates specific row number and/or seat identifier.
     * - use: optional
     * @var string
     */
    public $SeatRow;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for SeatingPrefType
     * @uses SeatingPrefType::set_()
     * @uses SeatingPrefType::setSeatDirection()
     * @uses SeatingPrefType::setSeatLocation()
     * @uses SeatingPrefType::setSeatPosition()
     * @uses SeatingPrefType::setSeatRow()
     * @uses SeatingPrefType::setPreferLevel()
     * @param string $_
     * @param string $seatDirection
     * @param string $seatLocation
     * @param string $seatPosition
     * @param string $seatRow
     * @param string $preferLevel
     */
    public function __construct($_ = null, $seatDirection = null, $seatLocation = null, $seatPosition = null, $seatRow = null, $preferLevel = null)
    {
        $this
            ->set_($_)
            ->setSeatDirection($seatDirection)
            ->setSeatLocation($seatLocation)
            ->setSeatPosition($seatPosition)
            ->setSeatRow($seatRow)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\SeatingPrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($_) && mb_strlen($_) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($_) && mb_strlen($_) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get SeatDirection value
     * @return string|null
     */
    public function getSeatDirection()
    {
        return $this->SeatDirection;
    }
    /**
     * Set SeatDirection value
     * @param string $seatDirection
     * @return \StructType\SeatingPrefType
     */
    public function setSeatDirection($seatDirection = null)
    {
        // validation for constraint: string
        if (!is_null($seatDirection) && !is_string($seatDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatDirection, true), gettype($seatDirection)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($seatDirection) && mb_strlen($seatDirection) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($seatDirection)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($seatDirection) && mb_strlen($seatDirection) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($seatDirection)), __LINE__);
        }
        $this->SeatDirection = $seatDirection;
        return $this;
    }
    /**
     * Get SeatLocation value
     * @return string|null
     */
    public function getSeatLocation()
    {
        return $this->SeatLocation;
    }
    /**
     * Set SeatLocation value
     * @param string $seatLocation
     * @return \StructType\SeatingPrefType
     */
    public function setSeatLocation($seatLocation = null)
    {
        // validation for constraint: string
        if (!is_null($seatLocation) && !is_string($seatLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatLocation, true), gettype($seatLocation)), __LINE__);
        }
        $this->SeatLocation = $seatLocation;
        return $this;
    }
    /**
     * Get SeatPosition value
     * @return string|null
     */
    public function getSeatPosition()
    {
        return $this->SeatPosition;
    }
    /**
     * Set SeatPosition value
     * @param string $seatPosition
     * @return \StructType\SeatingPrefType
     */
    public function setSeatPosition($seatPosition = null)
    {
        // validation for constraint: string
        if (!is_null($seatPosition) && !is_string($seatPosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatPosition, true), gettype($seatPosition)), __LINE__);
        }
        $this->SeatPosition = $seatPosition;
        return $this;
    }
    /**
     * Get SeatRow value
     * @return string|null
     */
    public function getSeatRow()
    {
        return $this->SeatRow;
    }
    /**
     * Set SeatRow value
     * @param string $seatRow
     * @return \StructType\SeatingPrefType
     */
    public function setSeatRow($seatRow = null)
    {
        // validation for constraint: string
        if (!is_null($seatRow) && !is_string($seatRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatRow, true), gettype($seatRow)), __LINE__);
        }
        $this->SeatRow = $seatRow;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\SeatingPrefType
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatingPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
