<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Attributes for seat request. Note: you can choose a specific seat or just a general preference | Object to hold a passengers' seat request
 * @subpackage Structs
 */
class SeatRequestType extends AbstractStructBase
{
    /**
     * The DepartureAirport
     * Meta information extracted from the WSDL
     * - documentation: Departure point of flight segment.
     * - minOccurs: 0
     * @var \StructType\LocationType
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta information extracted from the WSDL
     * - documentation: Arrival point of flight segment.
     * - minOccurs: 0
     * @var \StructType\LocationType
     */
    public $ArrivalAirport;
    /**
     * The Airline
     * Meta information extracted from the WSDL
     * - documentation: Specify the airline the seat was requested for.
     * - minOccurs: 0
     * @var \StructType\CompanyNameType
     */
    public $Airline;
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - documentation: The departure date of the flight for the seat requested. | A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $DepartureDate;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - documentation: The number of the flight for which this seat is requested.
     * - use: optional
     * @var string
     */
    public $FlightNumber;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Code providing status information for this seat request. Refer to OpenTravel Code List Status (STS). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The SeatNumber
     * @var string
     */
    public $SeatNumber;
    /**
     * The SeatPreference
     * Meta information extracted from the WSDL
     * - documentation: Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X. | List of OpenTravel Codes.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string[]
     */
    public $SeatPreference;
    /**
     * The DeckNumber
     * Meta information extracted from the WSDL
     * - documentation: Used for Numeric values, from 1 to 99 inclusive.
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 1
     * @var int
     */
    public $DeckNumber;
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - documentation: Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * @var int
     */
    public $RowNumber;
    /**
     * The SeatInRow
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 1.
     * - base: xs:string
     * - pattern: [a-zA-Z]{1}
     * @var string
     */
    public $SeatInRow;
    /**
     * The SmokingAllowed
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * Constructor method for SeatRequestType
     * @uses SeatRequestType::setDepartureAirport()
     * @uses SeatRequestType::setArrivalAirport()
     * @uses SeatRequestType::setAirline()
     * @uses SeatRequestType::setDepartureDate()
     * @uses SeatRequestType::setFlightNumber()
     * @uses SeatRequestType::setStatus()
     * @uses SeatRequestType::setSeatNumber()
     * @uses SeatRequestType::setSeatPreference()
     * @uses SeatRequestType::setDeckNumber()
     * @uses SeatRequestType::setRowNumber()
     * @uses SeatRequestType::setSeatInRow()
     * @uses SeatRequestType::setSmokingAllowed()
     * @param \StructType\LocationType $departureAirport
     * @param \StructType\LocationType $arrivalAirport
     * @param \StructType\CompanyNameType $airline
     * @param string $departureDate
     * @param string $flightNumber
     * @param string $status
     * @param string $seatNumber
     * @param string[] $seatPreference
     * @param int $deckNumber
     * @param int $rowNumber
     * @param string $seatInRow
     * @param bool $smokingAllowed
     */
    public function __construct(\StructType\LocationType $departureAirport = null, \StructType\LocationType $arrivalAirport = null, \StructType\CompanyNameType $airline = null, $departureDate = null, $flightNumber = null, $status = null, $seatNumber = null, array $seatPreference = array(), $deckNumber = null, $rowNumber = null, $seatInRow = null, $smokingAllowed = null)
    {
        $this
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setAirline($airline)
            ->setDepartureDate($departureDate)
            ->setFlightNumber($flightNumber)
            ->setStatus($status)
            ->setSeatNumber($seatNumber)
            ->setSeatPreference($seatPreference)
            ->setDeckNumber($deckNumber)
            ->setRowNumber($rowNumber)
            ->setSeatInRow($seatInRow)
            ->setSmokingAllowed($smokingAllowed);
    }
    /**
     * Get DepartureAirport value
     * @return \StructType\LocationType|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \StructType\LocationType $departureAirport
     * @return \StructType\SeatRequestType
     */
    public function setDepartureAirport(\StructType\LocationType $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return \StructType\LocationType|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \StructType\LocationType $arrivalAirport
     * @return \StructType\SeatRequestType
     */
    public function setArrivalAirport(\StructType\LocationType $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get Airline value
     * @return \StructType\CompanyNameType|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param \StructType\CompanyNameType $airline
     * @return \StructType\SeatRequestType
     */
    public function setAirline(\StructType\CompanyNameType $airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * This method is responsible for validating the value passed to the setDepartureDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepartureDate method
     * This is a set of validation rules based on the union types associated to the property being set by the setDepartureDate method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepartureDateForUnionConstraintsFromSetDepartureDate($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\SeatRequestType
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($departureDateUnionErrorMessage = self::validateDepartureDateForUnionConstraintsFromSetDepartureDate($departureDate))) {
            throw new \InvalidArgumentException($departureDateUnionErrorMessage, __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @uses \EnumType\FlightNumberType::valueIsValid()
     * @uses \EnumType\FlightNumberType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flightNumber
     * @return \StructType\SeatRequestType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FlightNumberType::valueIsValid($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FlightNumberType', is_array($flightNumber) ? implode(', ', $flightNumber) : var_export($flightNumber, true), implode(', ', \EnumType\FlightNumberType::getValidValues())), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\SeatRequestType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($status) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($status, true)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get SeatNumber value
     * @return string|null
     */
    public function getSeatNumber()
    {
        return $this->SeatNumber;
    }
    /**
     * Set SeatNumber value
     * @param string $seatNumber
     * @return \StructType\SeatRequestType
     */
    public function setSeatNumber($seatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seatNumber) && !is_string($seatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatNumber, true), gettype($seatNumber)), __LINE__);
        }
        $this->SeatNumber = $seatNumber;
        return $this;
    }
    /**
     * Get SeatPreference value
     * @return string[]|null
     */
    public function getSeatPreference()
    {
        return $this->SeatPreference;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatPreference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatPreference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatPreferenceForArrayConstraintsFromSetSeatPreference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatRequestTypeSeatPreferenceItem) {
            // validation for constraint: itemType
            if (!is_string($seatRequestTypeSeatPreferenceItem)) {
                $invalidValues[] = is_object($seatRequestTypeSeatPreferenceItem) ? get_class($seatRequestTypeSeatPreferenceItem) : sprintf('%s(%s)', gettype($seatRequestTypeSeatPreferenceItem), var_export($seatRequestTypeSeatPreferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatPreference property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatPreference value
     * @param string[] $seatPreference
     * @return \StructType\SeatRequestType
     */
    public function setSeatPreference(array $seatPreference = array())
    {
        // validation for constraint: list
        if ('' !== ($seatPreferenceArrayErrorMessage = self::validateSeatPreferenceForArrayConstraintsFromSetSeatPreference($seatPreference))) {
            throw new \InvalidArgumentException($seatPreferenceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($seatPreference) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $seatPreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($seatPreference, true)), __LINE__);
        }
        $this->SeatPreference = is_array($seatPreference) ? implode(' ', $seatPreference) : null;
        return $this;
    }
    /**
     * Get DeckNumber value
     * @return int|null
     */
    public function getDeckNumber()
    {
        return $this->DeckNumber;
    }
    /**
     * Set DeckNumber value
     * @param int $deckNumber
     * @return \StructType\SeatRequestType
     */
    public function setDeckNumber($deckNumber = null)
    {
        // validation for constraint: int
        if (!is_null($deckNumber) && !(is_int($deckNumber) || ctype_digit($deckNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deckNumber, true), gettype($deckNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($deckNumber) && $deckNumber > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($deckNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($deckNumber) && $deckNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($deckNumber, true)), __LINE__);
        }
        $this->DeckNumber = $deckNumber;
        return $this;
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\SeatRequestType
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($rowNumber) && $rowNumber > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($rowNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($rowNumber) && $rowNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($rowNumber, true)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get SeatInRow value
     * @return string|null
     */
    public function getSeatInRow()
    {
        return $this->SeatInRow;
    }
    /**
     * Set SeatInRow value
     * @param string $seatInRow
     * @return \StructType\SeatRequestType
     */
    public function setSeatInRow($seatInRow = null)
    {
        // validation for constraint: string
        if (!is_null($seatInRow) && !is_string($seatInRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatInRow, true), gettype($seatInRow)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{1})
        if (!is_null($seatInRow) && !preg_match('/[a-zA-Z]{1}/', $seatInRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{1}', var_export($seatInRow, true)), __LINE__);
        }
        $this->SeatInRow = $seatInRow;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \StructType\SeatRequestType
     */
    public function setSmokingAllowed($smokingAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($smokingAllowed, true), gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
