<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: AWG to revisit. | Seating requests for each passenger for each air leg of this trip.
 * @subpackage Structs
 */
class SeatRequest extends SeatRequestType
{
    /**
     * The TravelerRefNumberRPHList
     * Meta information extracted from the WSDL
     * - documentation: One or more travelers to whom this request applies. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular
     * itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $TravelerRefNumberRPHList;
    /**
     * The FlightRefNumberRPHList
     * Meta information extracted from the WSDL
     * - documentation: One or more flights to whom this request applies. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular
     * itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $FlightRefNumberRPHList;
    /**
     * The PartialSeatingInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the carrier supports partial seating. When false, the carrier does not support partial seating.
     * - use: optional
     * @var bool
     */
    public $PartialSeatingInd;
    /**
     * Constructor method for SeatRequest
     * @uses SeatRequest::setTravelerRefNumberRPHList()
     * @uses SeatRequest::setFlightRefNumberRPHList()
     * @uses SeatRequest::setPartialSeatingInd()
     * @param string[] $travelerRefNumberRPHList
     * @param string[] $flightRefNumberRPHList
     * @param bool $partialSeatingInd
     */
    public function __construct(array $travelerRefNumberRPHList = array(), array $flightRefNumberRPHList = array(), $partialSeatingInd = null)
    {
        $this
            ->setTravelerRefNumberRPHList($travelerRefNumberRPHList)
            ->setFlightRefNumberRPHList($flightRefNumberRPHList)
            ->setPartialSeatingInd($partialSeatingInd);
    }
    /**
     * Get TravelerRefNumberRPHList value
     * @return string[]|null
     */
    public function getTravelerRefNumberRPHList()
    {
        return $this->TravelerRefNumberRPHList;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelerRefNumberRPHList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelerRefNumberRPHList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelerRefNumberRPHListForArrayConstraintsFromSetTravelerRefNumberRPHList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatRequestTravelerRefNumberRPHListItem) {
            // validation for constraint: itemType
            if (!is_string($seatRequestTravelerRefNumberRPHListItem)) {
                $invalidValues[] = is_object($seatRequestTravelerRefNumberRPHListItem) ? get_class($seatRequestTravelerRefNumberRPHListItem) : sprintf('%s(%s)', gettype($seatRequestTravelerRefNumberRPHListItem), var_export($seatRequestTravelerRefNumberRPHListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelerRefNumberRPHList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelerRefNumberRPHList value
     * @param string[] $travelerRefNumberRPHList
     * @return \StructType\SeatRequest
     */
    public function setTravelerRefNumberRPHList(array $travelerRefNumberRPHList = array())
    {
        // validation for constraint: list
        if ('' !== ($travelerRefNumberRPHListArrayErrorMessage = self::validateTravelerRefNumberRPHListForArrayConstraintsFromSetTravelerRefNumberRPHList($travelerRefNumberRPHList))) {
            throw new \InvalidArgumentException($travelerRefNumberRPHListArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($travelerRefNumberRPHList) && !preg_match('/[0-9]{1,8}/', $travelerRefNumberRPHList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($travelerRefNumberRPHList, true)), __LINE__);
        }
        $this->TravelerRefNumberRPHList = is_array($travelerRefNumberRPHList) ? implode(' ', $travelerRefNumberRPHList) : null;
        return $this;
    }
    /**
     * Get FlightRefNumberRPHList value
     * @return string[]|null
     */
    public function getFlightRefNumberRPHList()
    {
        return $this->FlightRefNumberRPHList;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightRefNumberRPHList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightRefNumberRPHList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightRefNumberRPHListForArrayConstraintsFromSetFlightRefNumberRPHList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatRequestFlightRefNumberRPHListItem) {
            // validation for constraint: itemType
            if (!is_string($seatRequestFlightRefNumberRPHListItem)) {
                $invalidValues[] = is_object($seatRequestFlightRefNumberRPHListItem) ? get_class($seatRequestFlightRefNumberRPHListItem) : sprintf('%s(%s)', gettype($seatRequestFlightRefNumberRPHListItem), var_export($seatRequestFlightRefNumberRPHListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightRefNumberRPHList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightRefNumberRPHList value
     * @param string[] $flightRefNumberRPHList
     * @return \StructType\SeatRequest
     */
    public function setFlightRefNumberRPHList(array $flightRefNumberRPHList = array())
    {
        // validation for constraint: list
        if ('' !== ($flightRefNumberRPHListArrayErrorMessage = self::validateFlightRefNumberRPHListForArrayConstraintsFromSetFlightRefNumberRPHList($flightRefNumberRPHList))) {
            throw new \InvalidArgumentException($flightRefNumberRPHListArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($flightRefNumberRPHList) && !preg_match('/[0-9]{1,8}/', $flightRefNumberRPHList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($flightRefNumberRPHList, true)), __LINE__);
        }
        $this->FlightRefNumberRPHList = is_array($flightRefNumberRPHList) ? implode(' ', $flightRefNumberRPHList) : null;
        return $this;
    }
    /**
     * Get PartialSeatingInd value
     * @return bool|null
     */
    public function getPartialSeatingInd()
    {
        return $this->PartialSeatingInd;
    }
    /**
     * Set PartialSeatingInd value
     * @param bool $partialSeatingInd
     * @return \StructType\SeatRequest
     */
    public function setPartialSeatingInd($partialSeatingInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($partialSeatingInd) && !is_bool($partialSeatingInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($partialSeatingInd, true), gettype($partialSeatingInd)), __LINE__);
        }
        $this->PartialSeatingInd = $partialSeatingInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
