<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatMapDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Details of a seat map for a particular aircraft
 * @subpackage Structs
 */
class SeatMapDetailsType extends AbstractStructBase
{
    /**
     * The CabinClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * @var \StructType\CabinClass[]
     */
    public $CabinClass;
    /**
     * The TravelerRefNumberRPHs
     * Meta information extracted from the WSDL
     * - documentation: The reference number is used as a cross reference between the AirTravelerType and the SeatMapDetails. This will be used only if different seat maps are valid for different passengers for the same flight segment. | The Reference Place
     * Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $TravelerRefNumberRPHs;
    /**
     * Constructor method for SeatMapDetailsType
     * @uses SeatMapDetailsType::setCabinClass()
     * @uses SeatMapDetailsType::setTravelerRefNumberRPHs()
     * @param \StructType\CabinClass[] $cabinClass
     * @param string[] $travelerRefNumberRPHs
     */
    public function __construct(array $cabinClass = array(), array $travelerRefNumberRPHs = array())
    {
        $this
            ->setCabinClass($cabinClass)
            ->setTravelerRefNumberRPHs($travelerRefNumberRPHs);
    }
    /**
     * Get CabinClass value
     * @return \StructType\CabinClass[]|null
     */
    public function getCabinClass()
    {
        return $this->CabinClass;
    }
    /**
     * This method is responsible for validating the values passed to the setCabinClass method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinClass method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinClassForArrayConstraintsFromSetCabinClass(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatMapDetailsTypeCabinClassItem) {
            // validation for constraint: itemType
            if (!$seatMapDetailsTypeCabinClassItem instanceof \StructType\CabinClass) {
                $invalidValues[] = is_object($seatMapDetailsTypeCabinClassItem) ? get_class($seatMapDetailsTypeCabinClassItem) : sprintf('%s(%s)', gettype($seatMapDetailsTypeCabinClassItem), var_export($seatMapDetailsTypeCabinClassItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CabinClass property can only contain items of type \StructType\CabinClass, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CabinClass value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinClass[] $cabinClass
     * @return \StructType\SeatMapDetailsType
     */
    public function setCabinClass(array $cabinClass = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinClassArrayErrorMessage = self::validateCabinClassForArrayConstraintsFromSetCabinClass($cabinClass))) {
            throw new \InvalidArgumentException($cabinClassArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($cabinClass) && count($cabinClass) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($cabinClass)), __LINE__);
        }
        $this->CabinClass = $cabinClass;
        return $this;
    }
    /**
     * Add item to CabinClass value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinClass $item
     * @return \StructType\SeatMapDetailsType
     */
    public function addToCabinClass(\StructType\CabinClass $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CabinClass) {
            throw new \InvalidArgumentException(sprintf('The CabinClass property can only contain items of type \StructType\CabinClass, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->CabinClass) && count($this->CabinClass) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->CabinClass)), __LINE__);
        }
        $this->CabinClass[] = $item;
        return $this;
    }
    /**
     * Get TravelerRefNumberRPHs value
     * @return string[]|null
     */
    public function getTravelerRefNumberRPHs()
    {
        return $this->TravelerRefNumberRPHs;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelerRefNumberRPHs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelerRefNumberRPHs method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelerRefNumberRPHsForArrayConstraintsFromSetTravelerRefNumberRPHs(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatMapDetailsTypeTravelerRefNumberRPHsItem) {
            // validation for constraint: itemType
            if (!is_string($seatMapDetailsTypeTravelerRefNumberRPHsItem)) {
                $invalidValues[] = is_object($seatMapDetailsTypeTravelerRefNumberRPHsItem) ? get_class($seatMapDetailsTypeTravelerRefNumberRPHsItem) : sprintf('%s(%s)', gettype($seatMapDetailsTypeTravelerRefNumberRPHsItem), var_export($seatMapDetailsTypeTravelerRefNumberRPHsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelerRefNumberRPHs property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelerRefNumberRPHs value
     * @param string[] $travelerRefNumberRPHs
     * @return \StructType\SeatMapDetailsType
     */
    public function setTravelerRefNumberRPHs(array $travelerRefNumberRPHs = array())
    {
        // validation for constraint: list
        if ('' !== ($travelerRefNumberRPHsArrayErrorMessage = self::validateTravelerRefNumberRPHsForArrayConstraintsFromSetTravelerRefNumberRPHs($travelerRefNumberRPHs))) {
            throw new \InvalidArgumentException($travelerRefNumberRPHsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($travelerRefNumberRPHs) && !preg_match('/[0-9]{1,8}/', $travelerRefNumberRPHs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($travelerRefNumberRPHs, true)), __LINE__);
        }
        $this->TravelerRefNumberRPHs = is_array($travelerRefNumberRPHs) ? implode(' ', $travelerRefNumberRPHs) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatMapDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
