<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RowDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes the row details in a seat map
 * @subpackage Structs
 */
class RowDetailsType extends AbstractStructBase
{
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - documentation: Specifies the actual row number in the seat map.
     * - use: required
     * @var int
     */
    public $RowNumber;
    /**
     * The AirSeats
     * @var \StructType\AirSeats
     */
    public $AirSeats;
    /**
     * The AirRowCharacteristics
     * @var \StructType\AirRowCharacteristics
     */
    public $AirRowCharacteristics;
    /**
     * The MaxNumberOfSeats
     * Meta information extracted from the WSDL
     * - documentation: Maximum number of seats per row. | Used for Numeric values, from 0 to 99 inclusive.
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 0
     * @var int
     */
    public $MaxNumberOfSeats;
    /**
     * The AirBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Allows that a seat may be assigned a class code. | Used for an Alpha String, length 1 to 2 (for letter codes).
     * - base: xs:string
     * - pattern: [A-Z]{1,2}
     * - use: optional
     * @var string
     */
    public $AirBookDesigCode;
    /**
     * Constructor method for RowDetailsType
     * @uses RowDetailsType::setRowNumber()
     * @uses RowDetailsType::setAirSeats()
     * @uses RowDetailsType::setAirRowCharacteristics()
     * @uses RowDetailsType::setMaxNumberOfSeats()
     * @uses RowDetailsType::setAirBookDesigCode()
     * @param int $rowNumber
     * @param \StructType\AirSeats $airSeats
     * @param \StructType\AirRowCharacteristics $airRowCharacteristics
     * @param int $maxNumberOfSeats
     * @param string $airBookDesigCode
     */
    public function __construct($rowNumber = null, \StructType\AirSeats $airSeats = null, \StructType\AirRowCharacteristics $airRowCharacteristics = null, $maxNumberOfSeats = null, $airBookDesigCode = null)
    {
        $this
            ->setRowNumber($rowNumber)
            ->setAirSeats($airSeats)
            ->setAirRowCharacteristics($airRowCharacteristics)
            ->setMaxNumberOfSeats($maxNumberOfSeats)
            ->setAirBookDesigCode($airBookDesigCode);
    }
    /**
     * Get RowNumber value
     * @return int
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\RowDetailsType
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get AirSeats value
     * @return \StructType\AirSeats|null
     */
    public function getAirSeats()
    {
        return $this->AirSeats;
    }
    /**
     * Set AirSeats value
     * @param \StructType\AirSeats $airSeats
     * @return \StructType\RowDetailsType
     */
    public function setAirSeats(\StructType\AirSeats $airSeats = null)
    {
        $this->AirSeats = $airSeats;
        return $this;
    }
    /**
     * Get AirRowCharacteristics value
     * @return \StructType\AirRowCharacteristics|null
     */
    public function getAirRowCharacteristics()
    {
        return $this->AirRowCharacteristics;
    }
    /**
     * Set AirRowCharacteristics value
     * @param \StructType\AirRowCharacteristics $airRowCharacteristics
     * @return \StructType\RowDetailsType
     */
    public function setAirRowCharacteristics(\StructType\AirRowCharacteristics $airRowCharacteristics = null)
    {
        $this->AirRowCharacteristics = $airRowCharacteristics;
        return $this;
    }
    /**
     * Get MaxNumberOfSeats value
     * @return int|null
     */
    public function getMaxNumberOfSeats()
    {
        return $this->MaxNumberOfSeats;
    }
    /**
     * Set MaxNumberOfSeats value
     * @param int $maxNumberOfSeats
     * @return \StructType\RowDetailsType
     */
    public function setMaxNumberOfSeats($maxNumberOfSeats = null)
    {
        // validation for constraint: int
        if (!is_null($maxNumberOfSeats) && !(is_int($maxNumberOfSeats) || ctype_digit($maxNumberOfSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNumberOfSeats, true), gettype($maxNumberOfSeats)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($maxNumberOfSeats) && $maxNumberOfSeats > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($maxNumberOfSeats, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($maxNumberOfSeats) && $maxNumberOfSeats < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($maxNumberOfSeats, true)), __LINE__);
        }
        $this->MaxNumberOfSeats = $maxNumberOfSeats;
        return $this;
    }
    /**
     * Get AirBookDesigCode value
     * @return string|null
     */
    public function getAirBookDesigCode()
    {
        return $this->AirBookDesigCode;
    }
    /**
     * Set AirBookDesigCode value
     * @param string $airBookDesigCode
     * @return \StructType\RowDetailsType
     */
    public function setAirBookDesigCode($airBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($airBookDesigCode) && !is_string($airBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airBookDesigCode, true), gettype($airBookDesigCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{1,2})
        if (!is_null($airBookDesigCode) && !preg_match('/[A-Z]{1,2}/', $airBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{1,2}', var_export($airBookDesigCode, true)), __LINE__);
        }
        $this->AirBookDesigCode = $airBookDesigCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RowDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
