<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomTypeAllocation StructType
 * Meta information extracted from the WSDL
 * - documentation: This is the date range to which rooms are allocated for availability by room type. | This is the number of rooms blocked for a specific room type for specific dates.
 * @subpackage Structs
 */
class RoomTypeAllocation extends AbstractStructBase
{
    /**
     * The NumberOfUnits
     * Meta information extracted from the WSDL
     * - documentation: The number of rooms allocated as available for the dates specified in the DateTimeSpanGroup.
     * - use: optional
     * @var int
     */
    public $NumberOfUnits;
    /**
     * The CompRoomQuantity
     * Meta information extracted from the WSDL
     * - documentation: The number of complimentary rooms allocated as part of the inventory block. This may be a flat number of rooms or it may be used in conjunction with CompRoomFactor. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $CompRoomQuantity;
    /**
     * The CompRoomFactor
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate how many rooms need to be sold before a complimentary room is granted (e.g. CompRoomQuantity="1" and CompRoomFactor="100" means 1 complimentary room is granted per 100 rooms sold). | Used for Numeric values, from 1
     * to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $CompRoomFactor;
    /**
     * The EndDateIndicator
     * Meta information extracted from the WSDL
     * - documentation: If true, this indicator designates that the room allocation is applied through to the End date in the RoomType DateTimeSpanGroup if it exists or to the End date in the InvBlock DateTimeSpanGroup. This would be used in place of
     * RoomTypeAllocation/Duration and RoomTypeAllocation/End.
     * - use: optional
     * @var bool
     */
    public $EndDateIndicator;
    /**
     * The SellLimit
     * Meta information extracted from the WSDL
     * - documentation: The contracted quantity or ceiling of inventory, which may differ from the NumberOfUnits allocated.
     * - use: optional
     * @var int
     */
    public $SellLimit;
    /**
     * The ProcureBlockCode
     * Meta information extracted from the WSDL
     * - documentation: The block from which to take inventory when NumberOfUnits is depleted. This is used in conjunction with the SellLimit attribute. If this attribute is not present, inventory is taken from general inventory. | Used for Character
     * Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ProcureBlockCode;
    /**
     * The AllocationID
     * Meta information extracted from the WSDL
     * - documentation: Used to refer to a specific allocation already in the receiving system. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $AllocationID;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Allows for the specification of a night duration.
     * - union: duration | NightDurationType
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $End;
    /**
     * Constructor method for RoomTypeAllocation
     * @uses RoomTypeAllocation::setNumberOfUnits()
     * @uses RoomTypeAllocation::setCompRoomQuantity()
     * @uses RoomTypeAllocation::setCompRoomFactor()
     * @uses RoomTypeAllocation::setEndDateIndicator()
     * @uses RoomTypeAllocation::setSellLimit()
     * @uses RoomTypeAllocation::setProcureBlockCode()
     * @uses RoomTypeAllocation::setAllocationID()
     * @uses RoomTypeAllocation::setStart()
     * @uses RoomTypeAllocation::setDuration()
     * @uses RoomTypeAllocation::setEnd()
     * @param int $numberOfUnits
     * @param int $compRoomQuantity
     * @param int $compRoomFactor
     * @param bool $endDateIndicator
     * @param int $sellLimit
     * @param string $procureBlockCode
     * @param string $allocationID
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct($numberOfUnits = null, $compRoomQuantity = null, $compRoomFactor = null, $endDateIndicator = null, $sellLimit = null, $procureBlockCode = null, $allocationID = null, $start = null, $duration = null, $end = null)
    {
        $this
            ->setNumberOfUnits($numberOfUnits)
            ->setCompRoomQuantity($compRoomQuantity)
            ->setCompRoomFactor($compRoomFactor)
            ->setEndDateIndicator($endDateIndicator)
            ->setSellLimit($sellLimit)
            ->setProcureBlockCode($procureBlockCode)
            ->setAllocationID($allocationID)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \StructType\RoomTypeAllocation
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !(is_int($numberOfUnits) || ctype_digit($numberOfUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUnits, true), gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get CompRoomQuantity value
     * @return int|null
     */
    public function getCompRoomQuantity()
    {
        return $this->CompRoomQuantity;
    }
    /**
     * Set CompRoomQuantity value
     * @param int $compRoomQuantity
     * @return \StructType\RoomTypeAllocation
     */
    public function setCompRoomQuantity($compRoomQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($compRoomQuantity) && !(is_int($compRoomQuantity) || ctype_digit($compRoomQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($compRoomQuantity, true), gettype($compRoomQuantity)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($compRoomQuantity) && $compRoomQuantity > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($compRoomQuantity, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($compRoomQuantity) && $compRoomQuantity < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($compRoomQuantity, true)), __LINE__);
        }
        $this->CompRoomQuantity = $compRoomQuantity;
        return $this;
    }
    /**
     * Get CompRoomFactor value
     * @return int|null
     */
    public function getCompRoomFactor()
    {
        return $this->CompRoomFactor;
    }
    /**
     * Set CompRoomFactor value
     * @param int $compRoomFactor
     * @return \StructType\RoomTypeAllocation
     */
    public function setCompRoomFactor($compRoomFactor = null)
    {
        // validation for constraint: int
        if (!is_null($compRoomFactor) && !(is_int($compRoomFactor) || ctype_digit($compRoomFactor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($compRoomFactor, true), gettype($compRoomFactor)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($compRoomFactor) && $compRoomFactor > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($compRoomFactor, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($compRoomFactor) && $compRoomFactor < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($compRoomFactor, true)), __LINE__);
        }
        $this->CompRoomFactor = $compRoomFactor;
        return $this;
    }
    /**
     * Get EndDateIndicator value
     * @return bool|null
     */
    public function getEndDateIndicator()
    {
        return $this->EndDateIndicator;
    }
    /**
     * Set EndDateIndicator value
     * @param bool $endDateIndicator
     * @return \StructType\RoomTypeAllocation
     */
    public function setEndDateIndicator($endDateIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($endDateIndicator) && !is_bool($endDateIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($endDateIndicator, true), gettype($endDateIndicator)), __LINE__);
        }
        $this->EndDateIndicator = $endDateIndicator;
        return $this;
    }
    /**
     * Get SellLimit value
     * @return int|null
     */
    public function getSellLimit()
    {
        return $this->SellLimit;
    }
    /**
     * Set SellLimit value
     * @param int $sellLimit
     * @return \StructType\RoomTypeAllocation
     */
    public function setSellLimit($sellLimit = null)
    {
        // validation for constraint: int
        if (!is_null($sellLimit) && !(is_int($sellLimit) || ctype_digit($sellLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sellLimit, true), gettype($sellLimit)), __LINE__);
        }
        $this->SellLimit = $sellLimit;
        return $this;
    }
    /**
     * Get ProcureBlockCode value
     * @return string|null
     */
    public function getProcureBlockCode()
    {
        return $this->ProcureBlockCode;
    }
    /**
     * Set ProcureBlockCode value
     * @param string $procureBlockCode
     * @return \StructType\RoomTypeAllocation
     */
    public function setProcureBlockCode($procureBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($procureBlockCode) && !is_string($procureBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($procureBlockCode, true), gettype($procureBlockCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($procureBlockCode) && mb_strlen($procureBlockCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($procureBlockCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($procureBlockCode) && mb_strlen($procureBlockCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($procureBlockCode)), __LINE__);
        }
        $this->ProcureBlockCode = $procureBlockCode;
        return $this;
    }
    /**
     * Get AllocationID value
     * @return string|null
     */
    public function getAllocationID()
    {
        return $this->AllocationID;
    }
    /**
     * Set AllocationID value
     * @param string $allocationID
     * @return \StructType\RoomTypeAllocation
     */
    public function setAllocationID($allocationID = null)
    {
        // validation for constraint: string
        if (!is_null($allocationID) && !is_string($allocationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationID, true), gettype($allocationID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($allocationID) && mb_strlen($allocationID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($allocationID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($allocationID) && mb_strlen($allocationID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($allocationID)), __LINE__);
        }
        $this->AllocationID = $allocationID;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\RoomTypeAllocation
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This is a set of validation rules based on the union types associated to the property being set by the setDuration method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurationForUnionConstraintsFromSetDuration($value)
    {
        $message = '';
        // validation for constraint: pattern(P[0-9]{1,3}N)
        if (!is_null($value) && !preg_match('/P[0-9]{1,3}N/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression P[0-9]{1,3}N', var_export($value, true)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: duration, NightDurationType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\RoomTypeAllocation
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: union(duration, NightDurationType)
        if ('' !== ($durationUnionErrorMessage = self::validateDurationForUnionConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationUnionErrorMessage, __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndForUnionConstraintsFromSetEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\RoomTypeAllocation
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($endUnionErrorMessage = self::validateEndForUnionConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endUnionErrorMessage, __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomTypeAllocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
