<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStayType StructType
 * Meta information extracted from the WSDL
 * - documentation: Details on the Room Stay including Guest Counts, Time Span of this Room Stay, pointers to Res Guests, guest Memberships, Comments and Special Requests pertaining to this particular Room Stay and finally finacial information related
 * to the Room Stay, including Guarantee, Deposit and Payment and Cancellation Penalties.
 * @subpackage Structs
 */
class RoomStayType extends AbstractStructBase
{
    /**
     * The RoomTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RoomTypes
     */
    public $RoomTypes;
    /**
     * The RatePlans
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RatePlans
     */
    public $RatePlans;
    /**
     * The RoomRates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RoomRates
     */
    public $RoomRates;
    /**
     * The GuestCounts
     * Meta information extracted from the WSDL
     * - documentation: A collection of Guest Counts associated with Room Stay. A child Guest Count element is required for each distinct age group.
     * - minOccurs: 0
     * @var \StructType\GuestCountType
     */
    public $GuestCounts;
    /**
     * The TimeSpan
     * Meta information extracted from the WSDL
     * - documentation: The Time Span which covers the Room Stay.
     * - minOccurs: 0
     * @var \StructType\DateTimeSpanType
     */
    public $TimeSpan;
    /**
     * The Guarantee
     * Meta information extracted from the WSDL
     * - documentation: The guarantee information associated to the Room Stay. A maximum of 5 occurances are available for use depending on the context.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\GuaranteeType[]
     */
    public $Guarantee;
    /**
     * The DepositPayments
     * Meta information extracted from the WSDL
     * - documentation: A collection of deposit and/or payments for the Room Stay.
     * - minOccurs: 0
     * @var \StructType\RequiredPaymentsType
     */
    public $DepositPayments;
    /**
     * The CancelPenalties
     * Meta information extracted from the WSDL
     * - documentation: A collection of Cancellation Penalties objects for the Room Stay.
     * - minOccurs: 0
     * @var \StructType\CancelPenaltiesType
     */
    public $CancelPenalties;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - documentation: Discount percentage and/or Amount, code and textual reason for discount.
     * - minOccurs: 0
     * @var \StructType\DiscountType
     */
    public $Discount;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - documentation: The total amount charged for the Room Stay including additional occupant amounts and fees. If TaxInclusive is set to True, then taxes are included in the total amount.
     * - minOccurs: 0
     * @var \StructType\TotalType
     */
    public $Total;
    /**
     * The BasicPropertyInfo
     * Meta information extracted from the WSDL
     * - documentation: Property Information for the Room Stay.
     * - minOccurs: 0
     * @var \StructType\BasicPropertyInfoType
     */
    public $BasicPropertyInfo;
    /**
     * The MapURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MapURL
     */
    public $MapURL;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The MarketCode
     * Meta information extracted from the WSDL
     * - documentation: The code that relates to the market being sold to (e.g., the corporate market, packages). | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $MarketCode;
    /**
     * The SourceOfBusiness
     * Meta information extracted from the WSDL
     * - documentation: To specify where the business came from e.g. radio, newspaper ad, etc. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $SourceOfBusiness;
    /**
     * The DiscountCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $DiscountCode;
    /**
     * The RoomStayStatus
     * Meta information extracted from the WSDL
     * - documentation: Identifies the status of the room stay. | A union between TransactionActionType and PMS_ResStatusType. Used in messages that communicate between reservation systems as well as between a reservation and property management system. In
     * addition to the TransactionActionType and PMS_ResStatusType, the UpperCaseAlphaLength1to2 may be used for company specifc codes.
     * - union: PMS_ResStatusType | TransactionActionType | UpperCaseAlphaLength1to2
     * - use: optional
     * @var string
     */
    public $RoomStayStatus;
    /**
     * The WarningRPH
     * Meta information extracted from the WSDL
     * - documentation: This references the RPH found in the Warning element. Used to identify the warnings associated with this RoomStay. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g.
     * used to assign individual passengers or clients to particular itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $WarningRPH;
    /**
     * The RoomStayLanguage
     * Meta information extracted from the WSDL
     * - documentation: Language of the response for the RoomStay (property). Note that the requested language may not be available for all properties and so the language of the response for each property may vary.
     * - use: optional
     * @var string
     */
    public $RoomStayLanguage;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $PromotionCode;
    /**
     * The PromotionVendorCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8. | List of StringLength1to8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string[]
     */
    public $PromotionVendorCode;
    /**
     * Constructor method for RoomStayType
     * @uses RoomStayType::setRoomTypes()
     * @uses RoomStayType::setRatePlans()
     * @uses RoomStayType::setRoomRates()
     * @uses RoomStayType::setGuestCounts()
     * @uses RoomStayType::setTimeSpan()
     * @uses RoomStayType::setGuarantee()
     * @uses RoomStayType::setDepositPayments()
     * @uses RoomStayType::setCancelPenalties()
     * @uses RoomStayType::setDiscount()
     * @uses RoomStayType::setTotal()
     * @uses RoomStayType::setBasicPropertyInfo()
     * @uses RoomStayType::setMapURL()
     * @uses RoomStayType::setTPA_Extensions()
     * @uses RoomStayType::setMarketCode()
     * @uses RoomStayType::setSourceOfBusiness()
     * @uses RoomStayType::setDiscountCode()
     * @uses RoomStayType::setRoomStayStatus()
     * @uses RoomStayType::setWarningRPH()
     * @uses RoomStayType::setRoomStayLanguage()
     * @uses RoomStayType::setPromotionCode()
     * @uses RoomStayType::setPromotionVendorCode()
     * @param \StructType\RoomTypes $roomTypes
     * @param \StructType\RatePlans $ratePlans
     * @param \StructType\RoomRates $roomRates
     * @param \StructType\GuestCountType $guestCounts
     * @param \StructType\DateTimeSpanType $timeSpan
     * @param \StructType\GuaranteeType[] $guarantee
     * @param \StructType\RequiredPaymentsType $depositPayments
     * @param \StructType\CancelPenaltiesType $cancelPenalties
     * @param \StructType\DiscountType $discount
     * @param \StructType\TotalType $total
     * @param \StructType\BasicPropertyInfoType $basicPropertyInfo
     * @param \StructType\MapURL $mapURL
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @param string $marketCode
     * @param string $sourceOfBusiness
     * @param string $discountCode
     * @param string $roomStayStatus
     * @param string[] $warningRPH
     * @param string $roomStayLanguage
     * @param string $promotionCode
     * @param string[] $promotionVendorCode
     */
    public function __construct(\StructType\RoomTypes $roomTypes = null, \StructType\RatePlans $ratePlans = null, \StructType\RoomRates $roomRates = null, \StructType\GuestCountType $guestCounts = null, \StructType\DateTimeSpanType $timeSpan = null, array $guarantee = array(), \StructType\RequiredPaymentsType $depositPayments = null, \StructType\CancelPenaltiesType $cancelPenalties = null, \StructType\DiscountType $discount = null, \StructType\TotalType $total = null, \StructType\BasicPropertyInfoType $basicPropertyInfo = null, \StructType\MapURL $mapURL = null, \StructType\TPA_ExtensionsType $tPA_Extensions = null, $marketCode = null, $sourceOfBusiness = null, $discountCode = null, $roomStayStatus = null, array $warningRPH = array(), $roomStayLanguage = null, $promotionCode = null, array $promotionVendorCode = array())
    {
        $this
            ->setRoomTypes($roomTypes)
            ->setRatePlans($ratePlans)
            ->setRoomRates($roomRates)
            ->setGuestCounts($guestCounts)
            ->setTimeSpan($timeSpan)
            ->setGuarantee($guarantee)
            ->setDepositPayments($depositPayments)
            ->setCancelPenalties($cancelPenalties)
            ->setDiscount($discount)
            ->setTotal($total)
            ->setBasicPropertyInfo($basicPropertyInfo)
            ->setMapURL($mapURL)
            ->setTPA_Extensions($tPA_Extensions)
            ->setMarketCode($marketCode)
            ->setSourceOfBusiness($sourceOfBusiness)
            ->setDiscountCode($discountCode)
            ->setRoomStayStatus($roomStayStatus)
            ->setWarningRPH($warningRPH)
            ->setRoomStayLanguage($roomStayLanguage)
            ->setPromotionCode($promotionCode)
            ->setPromotionVendorCode($promotionVendorCode);
    }
    /**
     * Get RoomTypes value
     * @return \StructType\RoomTypes|null
     */
    public function getRoomTypes()
    {
        return $this->RoomTypes;
    }
    /**
     * Set RoomTypes value
     * @param \StructType\RoomTypes $roomTypes
     * @return \StructType\RoomStayType
     */
    public function setRoomTypes(\StructType\RoomTypes $roomTypes = null)
    {
        $this->RoomTypes = $roomTypes;
        return $this;
    }
    /**
     * Get RatePlans value
     * @return \StructType\RatePlans|null
     */
    public function getRatePlans()
    {
        return $this->RatePlans;
    }
    /**
     * Set RatePlans value
     * @param \StructType\RatePlans $ratePlans
     * @return \StructType\RoomStayType
     */
    public function setRatePlans(\StructType\RatePlans $ratePlans = null)
    {
        $this->RatePlans = $ratePlans;
        return $this;
    }
    /**
     * Get RoomRates value
     * @return \StructType\RoomRates|null
     */
    public function getRoomRates()
    {
        return $this->RoomRates;
    }
    /**
     * Set RoomRates value
     * @param \StructType\RoomRates $roomRates
     * @return \StructType\RoomStayType
     */
    public function setRoomRates(\StructType\RoomRates $roomRates = null)
    {
        $this->RoomRates = $roomRates;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \StructType\GuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \StructType\GuestCountType $guestCounts
     * @return \StructType\RoomStayType
     */
    public function setGuestCounts(\StructType\GuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get TimeSpan value
     * @return \StructType\DateTimeSpanType|null
     */
    public function getTimeSpan()
    {
        return $this->TimeSpan;
    }
    /**
     * Set TimeSpan value
     * @param \StructType\DateTimeSpanType $timeSpan
     * @return \StructType\RoomStayType
     */
    public function setTimeSpan(\StructType\DateTimeSpanType $timeSpan = null)
    {
        $this->TimeSpan = $timeSpan;
        return $this;
    }
    /**
     * Get Guarantee value
     * @return \StructType\GuaranteeType[]|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * This method is responsible for validating the values passed to the setGuarantee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuarantee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuaranteeForArrayConstraintsFromSetGuarantee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomStayTypeGuaranteeItem) {
            // validation for constraint: itemType
            if (!$roomStayTypeGuaranteeItem instanceof \StructType\GuaranteeType) {
                $invalidValues[] = is_object($roomStayTypeGuaranteeItem) ? get_class($roomStayTypeGuaranteeItem) : sprintf('%s(%s)', gettype($roomStayTypeGuaranteeItem), var_export($roomStayTypeGuaranteeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guarantee property can only contain items of type \StructType\GuaranteeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guarantee value
     * @throws \InvalidArgumentException
     * @param \StructType\GuaranteeType[] $guarantee
     * @return \StructType\RoomStayType
     */
    public function setGuarantee(array $guarantee = array())
    {
        // validation for constraint: array
        if ('' !== ($guaranteeArrayErrorMessage = self::validateGuaranteeForArrayConstraintsFromSetGuarantee($guarantee))) {
            throw new \InvalidArgumentException($guaranteeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($guarantee) && count($guarantee) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($guarantee)), __LINE__);
        }
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Add item to Guarantee value
     * @throws \InvalidArgumentException
     * @param \StructType\GuaranteeType $item
     * @return \StructType\RoomStayType
     */
    public function addToGuarantee(\StructType\GuaranteeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuaranteeType) {
            throw new \InvalidArgumentException(sprintf('The Guarantee property can only contain items of type \StructType\GuaranteeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Guarantee) && count($this->Guarantee) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Guarantee)), __LINE__);
        }
        $this->Guarantee[] = $item;
        return $this;
    }
    /**
     * Get DepositPayments value
     * @return \StructType\RequiredPaymentsType|null
     */
    public function getDepositPayments()
    {
        return $this->DepositPayments;
    }
    /**
     * Set DepositPayments value
     * @param \StructType\RequiredPaymentsType $depositPayments
     * @return \StructType\RoomStayType
     */
    public function setDepositPayments(\StructType\RequiredPaymentsType $depositPayments = null)
    {
        $this->DepositPayments = $depositPayments;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \StructType\CancelPenaltiesType|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \StructType\CancelPenaltiesType $cancelPenalties
     * @return \StructType\RoomStayType
     */
    public function setCancelPenalties(\StructType\CancelPenaltiesType $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get Discount value
     * @return \StructType\DiscountType|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param \StructType\DiscountType $discount
     * @return \StructType\RoomStayType
     */
    public function setDiscount(\StructType\DiscountType $discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get Total value
     * @return \StructType\TotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \StructType\TotalType $total
     * @return \StructType\RoomStayType
     */
    public function setTotal(\StructType\TotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get BasicPropertyInfo value
     * @return \StructType\BasicPropertyInfoType|null
     */
    public function getBasicPropertyInfo()
    {
        return $this->BasicPropertyInfo;
    }
    /**
     * Set BasicPropertyInfo value
     * @param \StructType\BasicPropertyInfoType $basicPropertyInfo
     * @return \StructType\RoomStayType
     */
    public function setBasicPropertyInfo(\StructType\BasicPropertyInfoType $basicPropertyInfo = null)
    {
        $this->BasicPropertyInfo = $basicPropertyInfo;
        return $this;
    }
    /**
     * Get MapURL value
     * @return \StructType\MapURL|null
     */
    public function getMapURL()
    {
        return $this->MapURL;
    }
    /**
     * Set MapURL value
     * @param \StructType\MapURL $mapURL
     * @return \StructType\RoomStayType
     */
    public function setMapURL(\StructType\MapURL $mapURL = null)
    {
        $this->MapURL = $mapURL;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\RoomStayType
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get MarketCode value
     * @return string|null
     */
    public function getMarketCode()
    {
        return $this->MarketCode;
    }
    /**
     * Set MarketCode value
     * @param string $marketCode
     * @return \StructType\RoomStayType
     */
    public function setMarketCode($marketCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketCode) && !is_string($marketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketCode, true), gettype($marketCode)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($marketCode) && mb_strlen($marketCode) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($marketCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($marketCode) && mb_strlen($marketCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($marketCode)), __LINE__);
        }
        $this->MarketCode = $marketCode;
        return $this;
    }
    /**
     * Get SourceOfBusiness value
     * @return string|null
     */
    public function getSourceOfBusiness()
    {
        return $this->SourceOfBusiness;
    }
    /**
     * Set SourceOfBusiness value
     * @param string $sourceOfBusiness
     * @return \StructType\RoomStayType
     */
    public function setSourceOfBusiness($sourceOfBusiness = null)
    {
        // validation for constraint: string
        if (!is_null($sourceOfBusiness) && !is_string($sourceOfBusiness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceOfBusiness, true), gettype($sourceOfBusiness)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($sourceOfBusiness) && mb_strlen($sourceOfBusiness) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($sourceOfBusiness)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($sourceOfBusiness) && mb_strlen($sourceOfBusiness) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($sourceOfBusiness)), __LINE__);
        }
        $this->SourceOfBusiness = $sourceOfBusiness;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \StructType\RoomStayType
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountCode, true), gettype($discountCode)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($discountCode) && mb_strlen($discountCode) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($discountCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($discountCode) && mb_strlen($discountCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($discountCode)), __LINE__);
        }
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Get RoomStayStatus value
     * @return string|null
     */
    public function getRoomStayStatus()
    {
        return $this->RoomStayStatus;
    }
    /**
     * This method is responsible for validating the value passed to the setRoomStayStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomStayStatus method
     * This is a set of validation rules based on the union types associated to the property being set by the setRoomStayStatus method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomStayStatusForUnionConstraintsFromSetRoomStayStatus($value)
    {
        $message = '';
        // validation for constraint: enumeration
        if (!\EnumType\PMS_ResStatusType::valueIsValid($value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PMS_ResStatusType', is_array($value) ? implode(', ', $value) : var_export($value, true), implode(', ', \EnumType\PMS_ResStatusType::getValidValues())), __LINE__);
        }
        // validation for constraint: enumeration
        if (!\EnumType\TransactionActionType::valueIsValid($value)) {
            $exception1 = new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionActionType', is_array($value) ? implode(', ', $value) : var_export($value, true), implode(', ', \EnumType\TransactionActionType::getValidValues())), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{1,2})
        if (!is_null($value) && !preg_match('/[A-Z]{1,2}/', $value)) {
            $exception2 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{1,2}', var_export($value, true)), __LINE__);
        }
        if (isset($exception0) && isset($exception1) && isset($exception2)) {
            $message = sprintf("The value %s does not match any of the union rules: PMS_ResStatusType, TransactionActionType, UpperCaseAlphaLength1to2. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0, $exception1, $exception2])));
        }
        unset($exception0, $exception1, $exception2);
        return $message;
    }
    /**
     * Set RoomStayStatus value
     * @param string $roomStayStatus
     * @return \StructType\RoomStayType
     */
    public function setRoomStayStatus($roomStayStatus = null)
    {
        // validation for constraint: string
        if (!is_null($roomStayStatus) && !is_string($roomStayStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomStayStatus, true), gettype($roomStayStatus)), __LINE__);
        }
        // validation for constraint: union(PMS_ResStatusType, TransactionActionType, UpperCaseAlphaLength1to2)
        if ('' !== ($roomStayStatusUnionErrorMessage = self::validateRoomStayStatusForUnionConstraintsFromSetRoomStayStatus($roomStayStatus))) {
            throw new \InvalidArgumentException($roomStayStatusUnionErrorMessage, __LINE__);
        }
        $this->RoomStayStatus = $roomStayStatus;
        return $this;
    }
    /**
     * Get WarningRPH value
     * @return string[]|null
     */
    public function getWarningRPH()
    {
        return $this->WarningRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setWarningRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarningRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningRPHForArrayConstraintsFromSetWarningRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomStayTypeWarningRPHItem) {
            // validation for constraint: itemType
            if (!is_string($roomStayTypeWarningRPHItem)) {
                $invalidValues[] = is_object($roomStayTypeWarningRPHItem) ? get_class($roomStayTypeWarningRPHItem) : sprintf('%s(%s)', gettype($roomStayTypeWarningRPHItem), var_export($roomStayTypeWarningRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WarningRPH property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WarningRPH value
     * @param string[] $warningRPH
     * @return \StructType\RoomStayType
     */
    public function setWarningRPH(array $warningRPH = array())
    {
        // validation for constraint: list
        if ('' !== ($warningRPHArrayErrorMessage = self::validateWarningRPHForArrayConstraintsFromSetWarningRPH($warningRPH))) {
            throw new \InvalidArgumentException($warningRPHArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($warningRPH) && !preg_match('/[0-9]{1,8}/', $warningRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($warningRPH, true)), __LINE__);
        }
        $this->WarningRPH = is_array($warningRPH) ? implode(' ', $warningRPH) : null;
        return $this;
    }
    /**
     * Get RoomStayLanguage value
     * @return string|null
     */
    public function getRoomStayLanguage()
    {
        return $this->RoomStayLanguage;
    }
    /**
     * Set RoomStayLanguage value
     * @param string $roomStayLanguage
     * @return \StructType\RoomStayType
     */
    public function setRoomStayLanguage($roomStayLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($roomStayLanguage) && !is_string($roomStayLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomStayLanguage, true), gettype($roomStayLanguage)), __LINE__);
        }
        $this->RoomStayLanguage = $roomStayLanguage;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\RoomStayType
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($promotionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get PromotionVendorCode value
     * @return string[]|null
     */
    public function getPromotionVendorCode()
    {
        return $this->PromotionVendorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotionVendorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotionVendorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomStayTypePromotionVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($roomStayTypePromotionVendorCodeItem)) {
                $invalidValues[] = is_object($roomStayTypePromotionVendorCodeItem) ? get_class($roomStayTypePromotionVendorCodeItem) : sprintf('%s(%s)', gettype($roomStayTypePromotionVendorCodeItem), var_export($roomStayTypePromotionVendorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PromotionVendorCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PromotionVendorCode value
     * @param string[] $promotionVendorCode
     * @return \StructType\RoomStayType
     */
    public function setPromotionVendorCode(array $promotionVendorCode = array())
    {
        // validation for constraint: list
        if ('' !== ($promotionVendorCodeArrayErrorMessage = self::validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode($promotionVendorCode))) {
            throw new \InvalidArgumentException($promotionVendorCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($promotionVendorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionVendorCode)), __LINE__);
        }
        $this->PromotionVendorCode = is_array($promotionVendorCode) ? implode(' ', $promotionVendorCode) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomStayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
