<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStayCandidates StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of room stay candidates. | Collection of room stay candidates. **This element is maintained at this level to support those who have implemented this message prior to 2005B. For new implementations consider using this
 * element under HotelSearchCriteria.**
 * @subpackage Structs
 */
class RoomStayCandidates extends AbstractStructBase
{
    /**
     * The RoomStayCandidate
     * Meta information extracted from the WSDL
     * - documentation: Element used to identify available room products.
     * - maxOccurs: unbounded
     * @var \StructType\RoomStayCandidateType[]
     */
    public $RoomStayCandidate;
    /**
     * Constructor method for RoomStayCandidates
     * @uses RoomStayCandidates::setRoomStayCandidate()
     * @param \StructType\RoomStayCandidateType[] $roomStayCandidate
     */
    public function __construct(array $roomStayCandidate = array())
    {
        $this
            ->setRoomStayCandidate($roomStayCandidate);
    }
    /**
     * Get RoomStayCandidate value
     * @return \StructType\RoomStayCandidateType[]|null
     */
    public function getRoomStayCandidate()
    {
        return $this->RoomStayCandidate;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomStayCandidate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomStayCandidate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomStayCandidateForArrayConstraintsFromSetRoomStayCandidate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomStayCandidatesRoomStayCandidateItem) {
            // validation for constraint: itemType
            if (!$roomStayCandidatesRoomStayCandidateItem instanceof \StructType\RoomStayCandidateType) {
                $invalidValues[] = is_object($roomStayCandidatesRoomStayCandidateItem) ? get_class($roomStayCandidatesRoomStayCandidateItem) : sprintf('%s(%s)', gettype($roomStayCandidatesRoomStayCandidateItem), var_export($roomStayCandidatesRoomStayCandidateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomStayCandidate property can only contain items of type \StructType\RoomStayCandidateType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomStayCandidate value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomStayCandidateType[] $roomStayCandidate
     * @return \StructType\RoomStayCandidates
     */
    public function setRoomStayCandidate(array $roomStayCandidate = array())
    {
        // validation for constraint: array
        if ('' !== ($roomStayCandidateArrayErrorMessage = self::validateRoomStayCandidateForArrayConstraintsFromSetRoomStayCandidate($roomStayCandidate))) {
            throw new \InvalidArgumentException($roomStayCandidateArrayErrorMessage, __LINE__);
        }
        $this->RoomStayCandidate = $roomStayCandidate;
        return $this;
    }
    /**
     * Add item to RoomStayCandidate value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomStayCandidateType $item
     * @return \StructType\RoomStayCandidates
     */
    public function addToRoomStayCandidate(\StructType\RoomStayCandidateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomStayCandidateType) {
            throw new \InvalidArgumentException(sprintf('The RoomStayCandidate property can only contain items of type \StructType\RoomStayCandidateType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomStayCandidate[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomStayCandidates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
