<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStay StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of Hotel Service reference placeholders. | A collection of reference place holders. This is a reference placeholder, used as an index for the reservation guests. | Details on the Room Stay including Guest Counts, Time
 * Span of this Room Stay, pointers to Res Guests, guest Memberships, Comments and Special Requests pertaining to this particular Room Stay and finally finacial information related to the Room Stay, including Guarantee, Deposit and Payment and
 * Cancellation Penalties. | Details the success, failure and warnings for the RoomStay. | Details on the Room Stay including Guest Counts, Time Span of this Room Stay, and financial information related to the Room Stay, including Guarantee, Deposit and
 * Payment and Cancellation Penalties.
 * @subpackage Structs
 */
class RoomStay extends RoomStayType
{
    /**
     * The ResGuestRPHs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResGuestRPHsType
     */
    public $ResGuestRPHs;
    /**
     * The Memberships
     * Meta information extracted from the WSDL
     * - documentation: A collection of Membership objects. Memberships provides a list of reward programs which may be credited with points accrued from the guest's activity.
     * - minOccurs: 0
     * @var \StructType\MembershipType
     */
    public $Memberships;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - documentation: A collection of Comment objects. Comments which apply to the whole Reservation or a particular Room Stay or Service.
     * - minOccurs: 0
     * @var \StructType\CommentType
     */
    public $Comments;
    /**
     * The SpecialRequests
     * Meta information extracted from the WSDL
     * - documentation: The SpecialRequest object indicates special requests for the whole Reservation, or a particular Room Stay or Service.
     * - minOccurs: 0
     * @var \StructType\SpecialRequestType
     */
    public $SpecialRequests;
    /**
     * The ServiceRPHs
     * Meta information extracted from the WSDL
     * - documentation: A container for the unique references to the services for the room stay.
     * - minOccurs: 0
     * @var \StructType\ServiceRPHsType
     */
    public $ServiceRPHs;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Reference
     */
    public $Reference;
    /**
     * The BookingRules
     * Meta information extracted from the WSDL
     * - documentation: Provides booking rule information for the room stay.
     * - minOccurs: 0
     * @var \StructType\BookingRulesType
     */
    public $BookingRules;
    /**
     * The IndexNumber
     * Meta information extracted from the WSDL
     * - documentation: A unique number (e.g. segment number or index number) used to further identify a booked item within a list of booked items. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $IndexNumber;
    /**
     * The HotelReservationIDs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\HotelReservationIDsType
     */
    public $HotelReservationIDs;
    /**
     * The RoomShares
     * Meta information extracted from the WSDL
     * - documentation: Collection of shared rooms for room stay.
     * - minOccurs: 0
     * @var \StructType\RoomSharesType
     */
    public $RoomShares;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: Provides a mechanism for uniquely identifying a room stay (e.g. this would be useful for a modification).
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var \StructType\SuccessType
     */
    public $Success;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var \StructType\WarningsType
     */
    public $Warnings;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var \StructType\ErrorsType
     */
    public $Errors;
    /**
     * The RoomStay
     * Meta information extracted from the WSDL
     * - documentation: This attribute indicates the change to the reservation.
     * - use: optional
     * @var string
     */
    public $RoomStay;
    /**
     * The IsAlternate
     * Meta information extracted from the WSDL
     * - documentation: false | Indicates the RoomStay is an alternate offer. Default=false.
     * - use: optional
     * @var bool
     */
    public $IsAlternate;
    /**
     * The AvailabilityStatus
     * Meta information extracted from the WSDL
     * - documentation: Used to specify an availability status at the room stay level for a property.
     * - use: optional
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * The RoomStayCandidateRPH
     * Meta information extracted from the WSDL
     * - documentation: A reference to a requested room stay candidate from the SearchCriteria. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or
     * clients to particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $RoomStayCandidateRPH;
    /**
     * The MoreDataEchoToken
     * Meta information extracted from the WSDL
     * - documentation: The availability response returns the attribute if there is additional data that could not fit within the availability response. The text value should be echoed in the availability request to indicate where to begin the next block of
     * availability data. | Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $MoreDataEchoToken;
    /**
     * The InfoSource
     * Meta information extracted from the WSDL
     * - documentation: Used to specify the source of the data being exchanged as determined by trading partners. | Used to specify the source of the data being exchanged.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $InfoSource;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Identifies the room stay for use in the hotel stay. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular
     * itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The AvailableIndicator
     * Meta information extracted from the WSDL
     * - documentation: May be used as a simple true/false to indicate availability or used in conjunction with @AvailabilityStatus to indicate if restricted rate qualifications have been met e.g. Exclusive and Available (true) vs. Exclusive but not
     * Available (false).
     * - use: optional
     * @var bool
     */
    public $AvailableIndicator;
    /**
     * The ResponseType
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $ResponseType;
    /**
     * Constructor method for RoomStay
     * @uses RoomStay::setResGuestRPHs()
     * @uses RoomStay::setMemberships()
     * @uses RoomStay::setComments()
     * @uses RoomStay::setSpecialRequests()
     * @uses RoomStay::setServiceRPHs()
     * @uses RoomStay::setReference()
     * @uses RoomStay::setBookingRules()
     * @uses RoomStay::setIndexNumber()
     * @uses RoomStay::setHotelReservationIDs()
     * @uses RoomStay::setRoomShares()
     * @uses RoomStay::setUniqueID()
     * @uses RoomStay::setSuccess()
     * @uses RoomStay::setWarnings()
     * @uses RoomStay::setErrors()
     * @uses RoomStay::setRoomStay()
     * @uses RoomStay::setIsAlternate()
     * @uses RoomStay::setAvailabilityStatus()
     * @uses RoomStay::setRoomStayCandidateRPH()
     * @uses RoomStay::setMoreDataEchoToken()
     * @uses RoomStay::setInfoSource()
     * @uses RoomStay::setRPH()
     * @uses RoomStay::setAvailableIndicator()
     * @uses RoomStay::setResponseType()
     * @param \StructType\ResGuestRPHsType $resGuestRPHs
     * @param \StructType\MembershipType $memberships
     * @param \StructType\CommentType $comments
     * @param \StructType\SpecialRequestType $specialRequests
     * @param \StructType\ServiceRPHsType $serviceRPHs
     * @param \StructType\Reference $reference
     * @param \StructType\BookingRulesType $bookingRules
     * @param int $indexNumber
     * @param \StructType\HotelReservationIDsType $hotelReservationIDs
     * @param \StructType\RoomSharesType $roomShares
     * @param \StructType\UniqueID_Type $uniqueID
     * @param \StructType\SuccessType $success
     * @param \StructType\WarningsType $warnings
     * @param \StructType\ErrorsType $errors
     * @param string $roomStay
     * @param bool $isAlternate
     * @param string $availabilityStatus
     * @param string $roomStayCandidateRPH
     * @param string $moreDataEchoToken
     * @param string $infoSource
     * @param string $rPH
     * @param bool $availableIndicator
     * @param string $responseType
     */
    public function __construct(\StructType\ResGuestRPHsType $resGuestRPHs = null, \StructType\MembershipType $memberships = null, \StructType\CommentType $comments = null, \StructType\SpecialRequestType $specialRequests = null, \StructType\ServiceRPHsType $serviceRPHs = null, \StructType\Reference $reference = null, \StructType\BookingRulesType $bookingRules = null, $indexNumber = null, \StructType\HotelReservationIDsType $hotelReservationIDs = null, \StructType\RoomSharesType $roomShares = null, \StructType\UniqueID_Type $uniqueID = null, \StructType\SuccessType $success = null, \StructType\WarningsType $warnings = null, \StructType\ErrorsType $errors = null, $roomStay = null, $isAlternate = null, $availabilityStatus = null, $roomStayCandidateRPH = null, $moreDataEchoToken = null, $infoSource = null, $rPH = null, $availableIndicator = null, $responseType = null)
    {
        $this
            ->setResGuestRPHs($resGuestRPHs)
            ->setMemberships($memberships)
            ->setComments($comments)
            ->setSpecialRequests($specialRequests)
            ->setServiceRPHs($serviceRPHs)
            ->setReference($reference)
            ->setBookingRules($bookingRules)
            ->setIndexNumber($indexNumber)
            ->setHotelReservationIDs($hotelReservationIDs)
            ->setRoomShares($roomShares)
            ->setUniqueID($uniqueID)
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setErrors($errors)
            ->setRoomStay($roomStay)
            ->setIsAlternate($isAlternate)
            ->setAvailabilityStatus($availabilityStatus)
            ->setRoomStayCandidateRPH($roomStayCandidateRPH)
            ->setMoreDataEchoToken($moreDataEchoToken)
            ->setInfoSource($infoSource)
            ->setRPH($rPH)
            ->setAvailableIndicator($availableIndicator)
            ->setResponseType($responseType);
    }
    /**
     * Get ResGuestRPHs value
     * @return \StructType\ResGuestRPHsType|null
     */
    public function getResGuestRPHs()
    {
        return $this->ResGuestRPHs;
    }
    /**
     * Set ResGuestRPHs value
     * @param \StructType\ResGuestRPHsType $resGuestRPHs
     * @return \StructType\RoomStay
     */
    public function setResGuestRPHs(\StructType\ResGuestRPHsType $resGuestRPHs = null)
    {
        $this->ResGuestRPHs = $resGuestRPHs;
        return $this;
    }
    /**
     * Get Memberships value
     * @return \StructType\MembershipType|null
     */
    public function getMemberships()
    {
        return $this->Memberships;
    }
    /**
     * Set Memberships value
     * @param \StructType\MembershipType $memberships
     * @return \StructType\RoomStay
     */
    public function setMemberships(\StructType\MembershipType $memberships = null)
    {
        $this->Memberships = $memberships;
        return $this;
    }
    /**
     * Get Comments value
     * @return \StructType\CommentType|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \StructType\CommentType $comments
     * @return \StructType\RoomStay
     */
    public function setComments(\StructType\CommentType $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get SpecialRequests value
     * @return \StructType\SpecialRequestType|null
     */
    public function getSpecialRequests()
    {
        return $this->SpecialRequests;
    }
    /**
     * Set SpecialRequests value
     * @param \StructType\SpecialRequestType $specialRequests
     * @return \StructType\RoomStay
     */
    public function setSpecialRequests(\StructType\SpecialRequestType $specialRequests = null)
    {
        $this->SpecialRequests = $specialRequests;
        return $this;
    }
    /**
     * Get ServiceRPHs value
     * @return \StructType\ServiceRPHsType|null
     */
    public function getServiceRPHs()
    {
        return $this->ServiceRPHs;
    }
    /**
     * Set ServiceRPHs value
     * @param \StructType\ServiceRPHsType $serviceRPHs
     * @return \StructType\RoomStay
     */
    public function setServiceRPHs(\StructType\ServiceRPHsType $serviceRPHs = null)
    {
        $this->ServiceRPHs = $serviceRPHs;
        return $this;
    }
    /**
     * Get Reference value
     * @return \StructType\Reference|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \StructType\Reference $reference
     * @return \StructType\RoomStay
     */
    public function setReference(\StructType\Reference $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get BookingRules value
     * @return \StructType\BookingRulesType|null
     */
    public function getBookingRules()
    {
        return $this->BookingRules;
    }
    /**
     * Set BookingRules value
     * @param \StructType\BookingRulesType $bookingRules
     * @return \StructType\RoomStay
     */
    public function setBookingRules(\StructType\BookingRulesType $bookingRules = null)
    {
        $this->BookingRules = $bookingRules;
        return $this;
    }
    /**
     * Get IndexNumber value
     * @return int|null
     */
    public function getIndexNumber()
    {
        return $this->IndexNumber;
    }
    /**
     * Set IndexNumber value
     * @param int $indexNumber
     * @return \StructType\RoomStay
     */
    public function setIndexNumber($indexNumber = null)
    {
        // validation for constraint: int
        if (!is_null($indexNumber) && !(is_int($indexNumber) || ctype_digit($indexNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($indexNumber, true), gettype($indexNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($indexNumber) && $indexNumber > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($indexNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($indexNumber) && $indexNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($indexNumber, true)), __LINE__);
        }
        $this->IndexNumber = $indexNumber;
        return $this;
    }
    /**
     * Get HotelReservationIDs value
     * @return \StructType\HotelReservationIDsType|null
     */
    public function getHotelReservationIDs()
    {
        return $this->HotelReservationIDs;
    }
    /**
     * Set HotelReservationIDs value
     * @param \StructType\HotelReservationIDsType $hotelReservationIDs
     * @return \StructType\RoomStay
     */
    public function setHotelReservationIDs(\StructType\HotelReservationIDsType $hotelReservationIDs = null)
    {
        $this->HotelReservationIDs = $hotelReservationIDs;
        return $this;
    }
    /**
     * Get RoomShares value
     * @return \StructType\RoomSharesType|null
     */
    public function getRoomShares()
    {
        return $this->RoomShares;
    }
    /**
     * Set RoomShares value
     * @param \StructType\RoomSharesType $roomShares
     * @return \StructType\RoomStay
     */
    public function setRoomShares(\StructType\RoomSharesType $roomShares = null)
    {
        $this->RoomShares = $roomShares;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\RoomStay
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get Success value
     * @return \StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return isset($this->Success) ? $this->Success : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSuccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSuccess method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSuccessForChoiceConstraintsFromSetSuccess($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Warnings',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Success can\'t be set as the property %s is already set. Only one property must be set among these properties: Success, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Success value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SuccessType $success
     * @return \StructType\RoomStay
     */
    public function setSuccess(\StructType\SuccessType $success = null)
    {
        // validation for constraint: choice(Success, Warnings, Errors)
        if ('' !== ($successChoiceErrorMessage = self::validateSuccessForChoiceConstraintsFromSetSuccess($success))) {
            throw new \InvalidArgumentException($successChoiceErrorMessage, __LINE__);
        }
        if (is_null($success) || (is_array($success) && empty($success))) {
            unset($this->Success);
        } else {
            $this->Success = $success;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWarnings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarnings method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWarningsForChoiceConstraintsFromSetWarnings($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Warnings can\'t be set as the property %s is already set. Only one property must be set among these properties: Warnings, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Warnings value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WarningsType $warnings
     * @return \StructType\RoomStay
     */
    public function setWarnings(\StructType\WarningsType $warnings = null)
    {
        // validation for constraint: choice(Success, Warnings, Errors)
        if ('' !== ($warningsChoiceErrorMessage = self::validateWarningsForChoiceConstraintsFromSetWarnings($warnings))) {
            throw new \InvalidArgumentException($warningsChoiceErrorMessage, __LINE__);
        }
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * This method is responsible for validating the value passed to the setErrors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrors method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorsForChoiceConstraintsFromSetErrors($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Errors can\'t be set as the property %s is already set. Only one property must be set among these properties: Errors, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Errors value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorsType $errors
     * @return \StructType\RoomStay
     */
    public function setErrors(\StructType\ErrorsType $errors = null)
    {
        // validation for constraint: choice(Success, Warnings, Errors)
        if ('' !== ($errorsChoiceErrorMessage = self::validateErrorsForChoiceConstraintsFromSetErrors($errors))) {
            throw new \InvalidArgumentException($errorsChoiceErrorMessage, __LINE__);
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get RoomStay value
     * @return string|null
     */
    public function getRoomStay()
    {
        return $this->RoomStay;
    }
    /**
     * Set RoomStay value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roomStay
     * @return \StructType\RoomStay
     */
    public function setRoomStay($roomStay = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($roomStay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($roomStay) ? implode(', ', $roomStay) : var_export($roomStay, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->RoomStay = $roomStay;
        return $this;
    }
    /**
     * Get IsAlternate value
     * @return bool|null
     */
    public function getIsAlternate()
    {
        return $this->IsAlternate;
    }
    /**
     * Set IsAlternate value
     * @param bool $isAlternate
     * @return \StructType\RoomStay
     */
    public function setIsAlternate($isAlternate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlternate) && !is_bool($isAlternate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAlternate, true), gettype($isAlternate)), __LINE__);
        }
        $this->IsAlternate = $isAlternate;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \EnumType\RateIndicatorType::valueIsValid()
     * @uses \EnumType\RateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \StructType\RoomStay
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RateIndicatorType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RateIndicatorType', is_array($availabilityStatus) ? implode(', ', $availabilityStatus) : var_export($availabilityStatus, true), implode(', ', \EnumType\RateIndicatorType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Get RoomStayCandidateRPH value
     * @return string|null
     */
    public function getRoomStayCandidateRPH()
    {
        return $this->RoomStayCandidateRPH;
    }
    /**
     * Set RoomStayCandidateRPH value
     * @param string $roomStayCandidateRPH
     * @return \StructType\RoomStay
     */
    public function setRoomStayCandidateRPH($roomStayCandidateRPH = null)
    {
        // validation for constraint: string
        if (!is_null($roomStayCandidateRPH) && !is_string($roomStayCandidateRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomStayCandidateRPH, true), gettype($roomStayCandidateRPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($roomStayCandidateRPH) && !preg_match('/[0-9]{1,8}/', $roomStayCandidateRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($roomStayCandidateRPH, true)), __LINE__);
        }
        $this->RoomStayCandidateRPH = $roomStayCandidateRPH;
        return $this;
    }
    /**
     * Get MoreDataEchoToken value
     * @return string|null
     */
    public function getMoreDataEchoToken()
    {
        return $this->MoreDataEchoToken;
    }
    /**
     * Set MoreDataEchoToken value
     * @param string $moreDataEchoToken
     * @return \StructType\RoomStay
     */
    public function setMoreDataEchoToken($moreDataEchoToken = null)
    {
        // validation for constraint: string
        if (!is_null($moreDataEchoToken) && !is_string($moreDataEchoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moreDataEchoToken, true), gettype($moreDataEchoToken)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($moreDataEchoToken) && mb_strlen($moreDataEchoToken) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($moreDataEchoToken)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($moreDataEchoToken) && mb_strlen($moreDataEchoToken) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($moreDataEchoToken)), __LINE__);
        }
        $this->MoreDataEchoToken = $moreDataEchoToken;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \StructType\RoomStay
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoSource, true), gettype($infoSource)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($infoSource) && mb_strlen($infoSource) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($infoSource)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($infoSource) && mb_strlen($infoSource) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\RoomStay
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get AvailableIndicator value
     * @return bool|null
     */
    public function getAvailableIndicator()
    {
        return $this->AvailableIndicator;
    }
    /**
     * Set AvailableIndicator value
     * @param bool $availableIndicator
     * @return \StructType\RoomStay
     */
    public function setAvailableIndicator($availableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableIndicator) && !is_bool($availableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableIndicator, true), gettype($availableIndicator)), __LINE__);
        }
        $this->AvailableIndicator = $availableIndicator;
        return $this;
    }
    /**
     * Get ResponseType value
     * @return string|null
     */
    public function getResponseType()
    {
        return $this->ResponseType;
    }
    /**
     * Set ResponseType value
     * @param string $responseType
     * @return \StructType\RoomStay
     */
    public function setResponseType($responseType = null)
    {
        // validation for constraint: string
        if (!is_null($responseType) && !is_string($responseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseType, true), gettype($responseType)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($responseType) && mb_strlen($responseType) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($responseType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($responseType) && mb_strlen($responseType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($responseType)), __LINE__);
        }
        $this->ResponseType = $responseType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
