<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomRates StructType
 * Meta information extracted from the WSDL
 * - documentation: The combination of a given Rate Plan and Room Type. This allows for support for systems where Rate Plans are child of Room Type as well as systems which Room Types are child of Rate Plans. | A collection of Room Rates associated with
 * a particular Room Stay. Each Room Rate combination can have multiple rates. Example King room, Rack rate plan, Monday through Thursday, weekday amount, Friday and Saturday, weekend amount. | Reservation rate(s).
 * @subpackage Structs
 */
class RoomRates extends AbstractStructBase
{
    /**
     * The RoomRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\RoomRateLiteType[]
     */
    public $RoomRate;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The MoreRatesExistInd
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates more rates exist. When false, all rate information is provided.
     * - use: optional
     * @var bool
     */
    public $MoreRatesExistInd;
    /**
     * Constructor method for RoomRates
     * @uses RoomRates::setRoomRate()
     * @uses RoomRates::setTPA_Extensions()
     * @uses RoomRates::setMoreRatesExistInd()
     * @param \StructType\RoomRateLiteType[] $roomRate
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @param bool $moreRatesExistInd
     */
    public function __construct(array $roomRate = array(), \StructType\TPA_ExtensionsType $tPA_Extensions = null, $moreRatesExistInd = null)
    {
        $this
            ->setRoomRate($roomRate)
            ->setTPA_Extensions($tPA_Extensions)
            ->setMoreRatesExistInd($moreRatesExistInd);
    }
    /**
     * Get RoomRate value
     * @return \StructType\RoomRateLiteType[]|null
     */
    public function getRoomRate()
    {
        return $this->RoomRate;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomRateForArrayConstraintsFromSetRoomRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomRatesRoomRateItem) {
            // validation for constraint: itemType
            if (!$roomRatesRoomRateItem instanceof \StructType\RoomRateLiteType) {
                $invalidValues[] = is_object($roomRatesRoomRateItem) ? get_class($roomRatesRoomRateItem) : sprintf('%s(%s)', gettype($roomRatesRoomRateItem), var_export($roomRatesRoomRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomRate property can only contain items of type \StructType\RoomRateLiteType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomRate value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomRateLiteType[] $roomRate
     * @return \StructType\RoomRates
     */
    public function setRoomRate(array $roomRate = array())
    {
        // validation for constraint: array
        if ('' !== ($roomRateArrayErrorMessage = self::validateRoomRateForArrayConstraintsFromSetRoomRate($roomRate))) {
            throw new \InvalidArgumentException($roomRateArrayErrorMessage, __LINE__);
        }
        $this->RoomRate = $roomRate;
        return $this;
    }
    /**
     * Add item to RoomRate value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomRateLiteType $item
     * @return \StructType\RoomRates
     */
    public function addToRoomRate(\StructType\RoomRateLiteType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomRateLiteType) {
            throw new \InvalidArgumentException(sprintf('The RoomRate property can only contain items of type \StructType\RoomRateLiteType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomRate[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\RoomRates
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get MoreRatesExistInd value
     * @return bool|null
     */
    public function getMoreRatesExistInd()
    {
        return $this->MoreRatesExistInd;
    }
    /**
     * Set MoreRatesExistInd value
     * @param bool $moreRatesExistInd
     * @return \StructType\RoomRates
     */
    public function setMoreRatesExistInd($moreRatesExistInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreRatesExistInd) && !is_bool($moreRatesExistInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($moreRatesExistInd, true), gettype($moreRatesExistInd)), __LINE__);
        }
        $this->MoreRatesExistInd = $moreRatesExistInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomRates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
