<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Room StructType
 * Meta information extracted from the WSDL
 * - documentation: Attributes to describe the room from room category to location to view to bed type.
 * @subpackage Structs
 */
class Room extends AbstractStructBase
{
    /**
     * The RoomType
     * Meta information extracted from the WSDL
     * - documentation: (Formerly, RoomInventoryCode) A code value that indicates the type of room for which this request is made, e.g.: double, king, etc. Values may use the Hotel Descriptive Content table or a codes specific to the property or hotel
     * brand. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $RoomType;
    /**
     * The RoomTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specific system room type code, ex: A1K, A1Q etc. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The RoomCategory
     * Meta information extracted from the WSDL
     * - documentation: Indicates the category of the room. Typical values would be Moderate, Standard, or Deluxe. Refer to OpenTravel Code List Segment Category Code (SEG). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are
     * 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $RoomCategory;
    /**
     * The RoomID
     * Meta information extracted from the WSDL
     * - documentation: A string value representing the unique identification of a room if the request is looking for a specific room. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $RoomID;
    /**
     * The Floor
     * Meta information extracted from the WSDL
     * - documentation: Floor on which the room is located. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - type: Numeric1to999
     * - use: optional
     * @var int
     */
    public $Floor;
    /**
     * The InvBlockCode
     * Meta information extracted from the WSDL
     * - documentation: A code or identification number that identifies the room stay as part of a group, package tour, or block of rooms designated in the inventory. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $InvBlockCode;
    /**
     * The RoomLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates the location of the room within the hotel structure. Typical values would be "Near Exit","Close to elevator", "Low Floor" or "High Floor". Refer to OpenTravel Code List Room Location Type (RLT). | Used for codes in the
     * OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $RoomLocationCode;
    /**
     * The RoomViewCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates the view of the room. Typical values would be "Ocean view", "Pool view" or "Garden View". Refer to OpenTravel Code List Room View Type (RVT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern
     * are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $RoomViewCode;
    /**
     * The BedTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates the type of bed(s) found in the room. Typical values would be Double, Twin, Queen, or King. Refer to OpenTravel Code List Bed Type Code (BED). | Used for codes in the OpenTravel Code tables. Possible values of this pattern
     * are 1, 101, 101.EQP, or 101.EQP.X. | List of OpenTravel Codes.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: ListOfOTA_CodeType
     * - use: optional
     * @var string[]
     */
    public $BedTypeCode;
    /**
     * The NonSmoking
     * Meta information extracted from the WSDL
     * - documentation: Non-smoking indicator.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $NonSmoking;
    /**
     * The Configuration
     * Meta information extracted from the WSDL
     * - documentation: Textual description of room configuration.
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Configuration;
    /**
     * The SizeMeasurement
     * Meta information extracted from the WSDL
     * - documentation: Textual description of room dimensions.
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $SizeMeasurement;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Defines the number of the item in question. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - type: Numeric1to999
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * The Composite
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the room (suite) is a composite of smaller units.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $Composite;
    /**
     * The RoomClassificationCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies the room classification (e.g., cabin, apartment). Refer to OpenTravel Code List Guest Room Info (GRI). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $RoomClassificationCode;
    /**
     * The RoomArchitectureCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies the architectural style of a room. Refer to OpenTravel Code List Architectural Style Code (ARC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $RoomArchitectureCode;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $PromotionCode;
    /**
     * The PromotionVendorCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8. | List of StringLength1to8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string[]
     */
    public $PromotionVendorCode;
    /**
     * Constructor method for Room
     * @uses Room::setRoomType()
     * @uses Room::setRoomTypeCode()
     * @uses Room::setRoomCategory()
     * @uses Room::setRoomID()
     * @uses Room::setFloor()
     * @uses Room::setInvBlockCode()
     * @uses Room::setRoomLocationCode()
     * @uses Room::setRoomViewCode()
     * @uses Room::setBedTypeCode()
     * @uses Room::setNonSmoking()
     * @uses Room::setConfiguration()
     * @uses Room::setSizeMeasurement()
     * @uses Room::setQuantity()
     * @uses Room::setComposite()
     * @uses Room::setRoomClassificationCode()
     * @uses Room::setRoomArchitectureCode()
     * @uses Room::setPromotionCode()
     * @uses Room::setPromotionVendorCode()
     * @param string $roomType
     * @param string $roomTypeCode
     * @param string $roomCategory
     * @param string $roomID
     * @param int $floor
     * @param string $invBlockCode
     * @param string $roomLocationCode
     * @param string $roomViewCode
     * @param string[] $bedTypeCode
     * @param bool $nonSmoking
     * @param string $configuration
     * @param string $sizeMeasurement
     * @param int $quantity
     * @param bool $composite
     * @param string $roomClassificationCode
     * @param string $roomArchitectureCode
     * @param string $promotionCode
     * @param string[] $promotionVendorCode
     */
    public function __construct($roomType = null, $roomTypeCode = null, $roomCategory = null, $roomID = null, $floor = null, $invBlockCode = null, $roomLocationCode = null, $roomViewCode = null, array $bedTypeCode = array(), $nonSmoking = null, $configuration = null, $sizeMeasurement = null, $quantity = null, $composite = null, $roomClassificationCode = null, $roomArchitectureCode = null, $promotionCode = null, array $promotionVendorCode = array())
    {
        $this
            ->setRoomType($roomType)
            ->setRoomTypeCode($roomTypeCode)
            ->setRoomCategory($roomCategory)
            ->setRoomID($roomID)
            ->setFloor($floor)
            ->setInvBlockCode($invBlockCode)
            ->setRoomLocationCode($roomLocationCode)
            ->setRoomViewCode($roomViewCode)
            ->setBedTypeCode($bedTypeCode)
            ->setNonSmoking($nonSmoking)
            ->setConfiguration($configuration)
            ->setSizeMeasurement($sizeMeasurement)
            ->setQuantity($quantity)
            ->setComposite($composite)
            ->setRoomClassificationCode($roomClassificationCode)
            ->setRoomArchitectureCode($roomArchitectureCode)
            ->setPromotionCode($promotionCode)
            ->setPromotionVendorCode($promotionVendorCode);
    }
    /**
     * Get RoomType value
     * @return string|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * Set RoomType value
     * @param string $roomType
     * @return \StructType\Room
     */
    public function setRoomType($roomType = null)
    {
        // validation for constraint: string
        if (!is_null($roomType) && !is_string($roomType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomType, true), gettype($roomType)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($roomType) && mb_strlen($roomType) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($roomType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($roomType) && mb_strlen($roomType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($roomType)), __LINE__);
        }
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\Room
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($roomTypeCode) && mb_strlen($roomTypeCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($roomTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($roomTypeCode) && mb_strlen($roomTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get RoomCategory value
     * @return string|null
     */
    public function getRoomCategory()
    {
        return $this->RoomCategory;
    }
    /**
     * Set RoomCategory value
     * @param string $roomCategory
     * @return \StructType\Room
     */
    public function setRoomCategory($roomCategory = null)
    {
        // validation for constraint: string
        if (!is_null($roomCategory) && !is_string($roomCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomCategory, true), gettype($roomCategory)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($roomCategory) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $roomCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($roomCategory, true)), __LINE__);
        }
        $this->RoomCategory = $roomCategory;
        return $this;
    }
    /**
     * Get RoomID value
     * @return string|null
     */
    public function getRoomID()
    {
        return $this->RoomID;
    }
    /**
     * Set RoomID value
     * @param string $roomID
     * @return \StructType\Room
     */
    public function setRoomID($roomID = null)
    {
        // validation for constraint: string
        if (!is_null($roomID) && !is_string($roomID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomID, true), gettype($roomID)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($roomID) && mb_strlen($roomID) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($roomID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($roomID) && mb_strlen($roomID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($roomID)), __LINE__);
        }
        $this->RoomID = $roomID;
        return $this;
    }
    /**
     * Get Floor value
     * @return int|null
     */
    public function getFloor()
    {
        return $this->Floor;
    }
    /**
     * Set Floor value
     * @param int $floor
     * @return \StructType\Room
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: int
        if (!is_null($floor) && !(is_int($floor) || ctype_digit($floor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($floor, true), gettype($floor)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($floor) && $floor > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($floor, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($floor) && $floor < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($floor, true)), __LINE__);
        }
        $this->Floor = $floor;
        return $this;
    }
    /**
     * Get InvBlockCode value
     * @return string|null
     */
    public function getInvBlockCode()
    {
        return $this->InvBlockCode;
    }
    /**
     * Set InvBlockCode value
     * @param string $invBlockCode
     * @return \StructType\Room
     */
    public function setInvBlockCode($invBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCode) && !is_string($invBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockCode, true), gettype($invBlockCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($invBlockCode) && mb_strlen($invBlockCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($invBlockCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invBlockCode) && mb_strlen($invBlockCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invBlockCode)), __LINE__);
        }
        $this->InvBlockCode = $invBlockCode;
        return $this;
    }
    /**
     * Get RoomLocationCode value
     * @return string|null
     */
    public function getRoomLocationCode()
    {
        return $this->RoomLocationCode;
    }
    /**
     * Set RoomLocationCode value
     * @param string $roomLocationCode
     * @return \StructType\Room
     */
    public function setRoomLocationCode($roomLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomLocationCode) && !is_string($roomLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomLocationCode, true), gettype($roomLocationCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($roomLocationCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $roomLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($roomLocationCode, true)), __LINE__);
        }
        $this->RoomLocationCode = $roomLocationCode;
        return $this;
    }
    /**
     * Get RoomViewCode value
     * @return string|null
     */
    public function getRoomViewCode()
    {
        return $this->RoomViewCode;
    }
    /**
     * Set RoomViewCode value
     * @param string $roomViewCode
     * @return \StructType\Room
     */
    public function setRoomViewCode($roomViewCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomViewCode) && !is_string($roomViewCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomViewCode, true), gettype($roomViewCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($roomViewCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $roomViewCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($roomViewCode, true)), __LINE__);
        }
        $this->RoomViewCode = $roomViewCode;
        return $this;
    }
    /**
     * Get BedTypeCode value
     * @return string[]|null
     */
    public function getBedTypeCode()
    {
        return $this->BedTypeCode;
    }
    /**
     * This method is responsible for validating the values passed to the setBedTypeCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBedTypeCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBedTypeCodeForArrayConstraintsFromSetBedTypeCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomBedTypeCodeItem) {
            // validation for constraint: itemType
            if (!is_string($roomBedTypeCodeItem)) {
                $invalidValues[] = is_object($roomBedTypeCodeItem) ? get_class($roomBedTypeCodeItem) : sprintf('%s(%s)', gettype($roomBedTypeCodeItem), var_export($roomBedTypeCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BedTypeCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BedTypeCode value
     * @param string[] $bedTypeCode
     * @return \StructType\Room
     */
    public function setBedTypeCode(array $bedTypeCode = array())
    {
        // validation for constraint: list
        if ('' !== ($bedTypeCodeArrayErrorMessage = self::validateBedTypeCodeForArrayConstraintsFromSetBedTypeCode($bedTypeCode))) {
            throw new \InvalidArgumentException($bedTypeCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($bedTypeCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $bedTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($bedTypeCode, true)), __LINE__);
        }
        $this->BedTypeCode = is_array($bedTypeCode) ? implode(' ', $bedTypeCode) : null;
        return $this;
    }
    /**
     * Get NonSmoking value
     * @return bool|null
     */
    public function getNonSmoking()
    {
        return $this->NonSmoking;
    }
    /**
     * Set NonSmoking value
     * @param bool $nonSmoking
     * @return \StructType\Room
     */
    public function setNonSmoking($nonSmoking = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonSmoking) && !is_bool($nonSmoking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonSmoking, true), gettype($nonSmoking)), __LINE__);
        }
        $this->NonSmoking = $nonSmoking;
        return $this;
    }
    /**
     * Get Configuration value
     * @return string|null
     */
    public function getConfiguration()
    {
        return $this->Configuration;
    }
    /**
     * Set Configuration value
     * @param string $configuration
     * @return \StructType\Room
     */
    public function setConfiguration($configuration = null)
    {
        // validation for constraint: string
        if (!is_null($configuration) && !is_string($configuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configuration, true), gettype($configuration)), __LINE__);
        }
        $this->Configuration = $configuration;
        return $this;
    }
    /**
     * Get SizeMeasurement value
     * @return string|null
     */
    public function getSizeMeasurement()
    {
        return $this->SizeMeasurement;
    }
    /**
     * Set SizeMeasurement value
     * @param string $sizeMeasurement
     * @return \StructType\Room
     */
    public function setSizeMeasurement($sizeMeasurement = null)
    {
        // validation for constraint: string
        if (!is_null($sizeMeasurement) && !is_string($sizeMeasurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sizeMeasurement, true), gettype($sizeMeasurement)), __LINE__);
        }
        $this->SizeMeasurement = $sizeMeasurement;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\Room
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($quantity) && $quantity > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($quantity, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($quantity) && $quantity < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($quantity, true)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Composite value
     * @return bool|null
     */
    public function getComposite()
    {
        return $this->Composite;
    }
    /**
     * Set Composite value
     * @param bool $composite
     * @return \StructType\Room
     */
    public function setComposite($composite = null)
    {
        // validation for constraint: boolean
        if (!is_null($composite) && !is_bool($composite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($composite, true), gettype($composite)), __LINE__);
        }
        $this->Composite = $composite;
        return $this;
    }
    /**
     * Get RoomClassificationCode value
     * @return string|null
     */
    public function getRoomClassificationCode()
    {
        return $this->RoomClassificationCode;
    }
    /**
     * Set RoomClassificationCode value
     * @param string $roomClassificationCode
     * @return \StructType\Room
     */
    public function setRoomClassificationCode($roomClassificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomClassificationCode) && !is_string($roomClassificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomClassificationCode, true), gettype($roomClassificationCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($roomClassificationCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $roomClassificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($roomClassificationCode, true)), __LINE__);
        }
        $this->RoomClassificationCode = $roomClassificationCode;
        return $this;
    }
    /**
     * Get RoomArchitectureCode value
     * @return string|null
     */
    public function getRoomArchitectureCode()
    {
        return $this->RoomArchitectureCode;
    }
    /**
     * Set RoomArchitectureCode value
     * @param string $roomArchitectureCode
     * @return \StructType\Room
     */
    public function setRoomArchitectureCode($roomArchitectureCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomArchitectureCode) && !is_string($roomArchitectureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomArchitectureCode, true), gettype($roomArchitectureCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($roomArchitectureCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $roomArchitectureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($roomArchitectureCode, true)), __LINE__);
        }
        $this->RoomArchitectureCode = $roomArchitectureCode;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\Room
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($promotionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get PromotionVendorCode value
     * @return string[]|null
     */
    public function getPromotionVendorCode()
    {
        return $this->PromotionVendorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotionVendorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotionVendorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomPromotionVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($roomPromotionVendorCodeItem)) {
                $invalidValues[] = is_object($roomPromotionVendorCodeItem) ? get_class($roomPromotionVendorCodeItem) : sprintf('%s(%s)', gettype($roomPromotionVendorCodeItem), var_export($roomPromotionVendorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PromotionVendorCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PromotionVendorCode value
     * @param string[] $promotionVendorCode
     * @return \StructType\Room
     */
    public function setPromotionVendorCode(array $promotionVendorCode = array())
    {
        // validation for constraint: list
        if ('' !== ($promotionVendorCodeArrayErrorMessage = self::validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode($promotionVendorCode))) {
            throw new \InvalidArgumentException($promotionVendorCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($promotionVendorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionVendorCode)), __LINE__);
        }
        $this->PromotionVendorCode = is_array($promotionVendorCode) ? implode(' ', $promotionVendorCode) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Room
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
