<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RevenueDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: The line item detail of specific revenue transactions.
 * @subpackage Structs
 */
class RevenueDetailsType extends AbstractStructBase
{
    /**
     * The RevenueDetail
     * Meta information extracted from the WSDL
     * - documentation: Contains line item details about specific revenue transactions.
     * - maxOccurs: 99
     * @var \StructType\RevenueDetailType[]
     */
    public $RevenueDetail;
    /**
     * Constructor method for RevenueDetailsType
     * @uses RevenueDetailsType::setRevenueDetail()
     * @param \StructType\RevenueDetailType[] $revenueDetail
     */
    public function __construct(array $revenueDetail = array())
    {
        $this
            ->setRevenueDetail($revenueDetail);
    }
    /**
     * Get RevenueDetail value
     * @return \StructType\RevenueDetailType[]|null
     */
    public function getRevenueDetail()
    {
        return $this->RevenueDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setRevenueDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRevenueDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRevenueDetailForArrayConstraintsFromSetRevenueDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $revenueDetailsTypeRevenueDetailItem) {
            // validation for constraint: itemType
            if (!$revenueDetailsTypeRevenueDetailItem instanceof \StructType\RevenueDetailType) {
                $invalidValues[] = is_object($revenueDetailsTypeRevenueDetailItem) ? get_class($revenueDetailsTypeRevenueDetailItem) : sprintf('%s(%s)', gettype($revenueDetailsTypeRevenueDetailItem), var_export($revenueDetailsTypeRevenueDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RevenueDetail property can only contain items of type \StructType\RevenueDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RevenueDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RevenueDetailType[] $revenueDetail
     * @return \StructType\RevenueDetailsType
     */
    public function setRevenueDetail(array $revenueDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($revenueDetailArrayErrorMessage = self::validateRevenueDetailForArrayConstraintsFromSetRevenueDetail($revenueDetail))) {
            throw new \InvalidArgumentException($revenueDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($revenueDetail) && count($revenueDetail) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($revenueDetail)), __LINE__);
        }
        $this->RevenueDetail = $revenueDetail;
        return $this;
    }
    /**
     * Add item to RevenueDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RevenueDetailType $item
     * @return \StructType\RevenueDetailsType
     */
    public function addToRevenueDetail(\StructType\RevenueDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RevenueDetailType) {
            throw new \InvalidArgumentException(sprintf('The RevenueDetail property can only contain items of type \StructType\RevenueDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->RevenueDetail) && count($this->RevenueDetail) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->RevenueDetail)), __LINE__);
        }
        $this->RevenueDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RevenueDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
