<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RevenueCategorySummaries StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of RevenueCategorySummary elements. Used if revenue values reported.
 * @subpackage Structs
 */
class RevenueCategorySummaries extends AbstractStructBase
{
    /**
     * The RevenueCategorySummary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\RevenueCategorySummary[]
     */
    public $RevenueCategorySummary;
    /**
     * Constructor method for RevenueCategorySummaries
     * @uses RevenueCategorySummaries::setRevenueCategorySummary()
     * @param \StructType\RevenueCategorySummary[] $revenueCategorySummary
     */
    public function __construct(array $revenueCategorySummary = array())
    {
        $this
            ->setRevenueCategorySummary($revenueCategorySummary);
    }
    /**
     * Get RevenueCategorySummary value
     * @return \StructType\RevenueCategorySummary[]|null
     */
    public function getRevenueCategorySummary()
    {
        return $this->RevenueCategorySummary;
    }
    /**
     * This method is responsible for validating the values passed to the setRevenueCategorySummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRevenueCategorySummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRevenueCategorySummaryForArrayConstraintsFromSetRevenueCategorySummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $revenueCategorySummariesRevenueCategorySummaryItem) {
            // validation for constraint: itemType
            if (!$revenueCategorySummariesRevenueCategorySummaryItem instanceof \StructType\RevenueCategorySummary) {
                $invalidValues[] = is_object($revenueCategorySummariesRevenueCategorySummaryItem) ? get_class($revenueCategorySummariesRevenueCategorySummaryItem) : sprintf('%s(%s)', gettype($revenueCategorySummariesRevenueCategorySummaryItem), var_export($revenueCategorySummariesRevenueCategorySummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RevenueCategorySummary property can only contain items of type \StructType\RevenueCategorySummary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RevenueCategorySummary value
     * @throws \InvalidArgumentException
     * @param \StructType\RevenueCategorySummary[] $revenueCategorySummary
     * @return \StructType\RevenueCategorySummaries
     */
    public function setRevenueCategorySummary(array $revenueCategorySummary = array())
    {
        // validation for constraint: array
        if ('' !== ($revenueCategorySummaryArrayErrorMessage = self::validateRevenueCategorySummaryForArrayConstraintsFromSetRevenueCategorySummary($revenueCategorySummary))) {
            throw new \InvalidArgumentException($revenueCategorySummaryArrayErrorMessage, __LINE__);
        }
        $this->RevenueCategorySummary = $revenueCategorySummary;
        return $this;
    }
    /**
     * Add item to RevenueCategorySummary value
     * @throws \InvalidArgumentException
     * @param \StructType\RevenueCategorySummary $item
     * @return \StructType\RevenueCategorySummaries
     */
    public function addToRevenueCategorySummary(\StructType\RevenueCategorySummary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RevenueCategorySummary) {
            throw new \InvalidArgumentException(sprintf('The RevenueCategorySummary property can only contain items of type \StructType\RevenueCategorySummary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RevenueCategorySummary[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RevenueCategorySummaries
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
