<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResCommonDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: A grouping of elements including Guest Counts, Time Span, pointers to Res Guests, guest Memberships, Comments and Special Requests and finally finacial information including Guarantee, Deposit and Payyment and Cancellation Penalties.
 * @subpackage Structs
 */
class ResCommonDetailType extends AbstractStructBase
{
    /**
     * The GuestCounts
     * Meta information extracted from the WSDL
     * - documentation: A collection of Guest Counts associated to the whole Reservation or a particular Room Stay or Service. A child Guest Count element is required for each distict age group.
     * - minOccurs: 0
     * @var \StructType\GuestCountType
     */
    public $GuestCounts;
    /**
     * The TimeSpan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TimeSpan
     */
    public $TimeSpan;
    /**
     * The ResGuestRPHs
     * Meta information extracted from the WSDL
     * - documentation: A collection of ResGuestRPH objects.
     * - minOccurs: 0
     * @var \StructType\ResGuestRPHsType
     */
    public $ResGuestRPHs;
    /**
     * The Memberships
     * Meta information extracted from the WSDL
     * - documentation: A collection of Membership objects. Memberships provides a list of reward programs which may be credited with points accrued from the guest's activity. Which memberships are to be applied to which part is determined by each object's
     * SelectedMembershipRPHs collection.
     * - minOccurs: 0
     * @var \StructType\MembershipType
     */
    public $Memberships;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - documentation: A collection of Comment objects. Comments which apply to the whole Reservation or a particular Room Stay or Service.
     * - minOccurs: 0
     * @var \StructType\CommentType
     */
    public $Comments;
    /**
     * The SpecialRequests
     * Meta information extracted from the WSDL
     * - documentation: The SpecialRequest object indicates special requests for the whole Reservation, or a particular Room Stay or Service.
     * - minOccurs: 0
     * @var \StructType\SpecialRequestType
     */
    public $SpecialRequests;
    /**
     * The Guarantee
     * Meta information extracted from the WSDL
     * - documentation: The guarantee information associated to the Reservation or a particular Room Stay or Service.
     * - minOccurs: 0
     * @var \StructType\GuaranteeType
     */
    public $Guarantee;
    /**
     * The DepositPayments
     * Meta information extracted from the WSDL
     * - documentation: A collection of deposit and/or payments.
     * - minOccurs: 0
     * @var \StructType\RequiredPaymentsType
     */
    public $DepositPayments;
    /**
     * The CancelPenalties
     * Meta information extracted from the WSDL
     * - documentation: A collection of Cancellation Penalties objects.
     * - minOccurs: 0
     * @var \StructType\CancelPenaltiesType
     */
    public $CancelPenalties;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - documentation: A collection of fees that applies to the reservation.
     * - minOccurs: 0
     * @var \StructType\FeesType
     */
    public $Fees;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - documentation: The total amount charged for the accommodation including additional occupant amounts and fees. If TaxInclusive is set to True, then taxes are included in the total amount.
     * - minOccurs: 0
     * @var \StructType\TotalType
     */
    public $Total;
    /**
     * Constructor method for ResCommonDetailType
     * @uses ResCommonDetailType::setGuestCounts()
     * @uses ResCommonDetailType::setTimeSpan()
     * @uses ResCommonDetailType::setResGuestRPHs()
     * @uses ResCommonDetailType::setMemberships()
     * @uses ResCommonDetailType::setComments()
     * @uses ResCommonDetailType::setSpecialRequests()
     * @uses ResCommonDetailType::setGuarantee()
     * @uses ResCommonDetailType::setDepositPayments()
     * @uses ResCommonDetailType::setCancelPenalties()
     * @uses ResCommonDetailType::setFees()
     * @uses ResCommonDetailType::setTotal()
     * @param \StructType\GuestCountType $guestCounts
     * @param \StructType\TimeSpan $timeSpan
     * @param \StructType\ResGuestRPHsType $resGuestRPHs
     * @param \StructType\MembershipType $memberships
     * @param \StructType\CommentType $comments
     * @param \StructType\SpecialRequestType $specialRequests
     * @param \StructType\GuaranteeType $guarantee
     * @param \StructType\RequiredPaymentsType $depositPayments
     * @param \StructType\CancelPenaltiesType $cancelPenalties
     * @param \StructType\FeesType $fees
     * @param \StructType\TotalType $total
     */
    public function __construct(\StructType\GuestCountType $guestCounts = null, \StructType\TimeSpan $timeSpan = null, \StructType\ResGuestRPHsType $resGuestRPHs = null, \StructType\MembershipType $memberships = null, \StructType\CommentType $comments = null, \StructType\SpecialRequestType $specialRequests = null, \StructType\GuaranteeType $guarantee = null, \StructType\RequiredPaymentsType $depositPayments = null, \StructType\CancelPenaltiesType $cancelPenalties = null, \StructType\FeesType $fees = null, \StructType\TotalType $total = null)
    {
        $this
            ->setGuestCounts($guestCounts)
            ->setTimeSpan($timeSpan)
            ->setResGuestRPHs($resGuestRPHs)
            ->setMemberships($memberships)
            ->setComments($comments)
            ->setSpecialRequests($specialRequests)
            ->setGuarantee($guarantee)
            ->setDepositPayments($depositPayments)
            ->setCancelPenalties($cancelPenalties)
            ->setFees($fees)
            ->setTotal($total);
    }
    /**
     * Get GuestCounts value
     * @return \StructType\GuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \StructType\GuestCountType $guestCounts
     * @return \StructType\ResCommonDetailType
     */
    public function setGuestCounts(\StructType\GuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get TimeSpan value
     * @return \StructType\TimeSpan|null
     */
    public function getTimeSpan()
    {
        return $this->TimeSpan;
    }
    /**
     * Set TimeSpan value
     * @param \StructType\TimeSpan $timeSpan
     * @return \StructType\ResCommonDetailType
     */
    public function setTimeSpan(\StructType\TimeSpan $timeSpan = null)
    {
        $this->TimeSpan = $timeSpan;
        return $this;
    }
    /**
     * Get ResGuestRPHs value
     * @return \StructType\ResGuestRPHsType|null
     */
    public function getResGuestRPHs()
    {
        return $this->ResGuestRPHs;
    }
    /**
     * Set ResGuestRPHs value
     * @param \StructType\ResGuestRPHsType $resGuestRPHs
     * @return \StructType\ResCommonDetailType
     */
    public function setResGuestRPHs(\StructType\ResGuestRPHsType $resGuestRPHs = null)
    {
        $this->ResGuestRPHs = $resGuestRPHs;
        return $this;
    }
    /**
     * Get Memberships value
     * @return \StructType\MembershipType|null
     */
    public function getMemberships()
    {
        return $this->Memberships;
    }
    /**
     * Set Memberships value
     * @param \StructType\MembershipType $memberships
     * @return \StructType\ResCommonDetailType
     */
    public function setMemberships(\StructType\MembershipType $memberships = null)
    {
        $this->Memberships = $memberships;
        return $this;
    }
    /**
     * Get Comments value
     * @return \StructType\CommentType|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \StructType\CommentType $comments
     * @return \StructType\ResCommonDetailType
     */
    public function setComments(\StructType\CommentType $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get SpecialRequests value
     * @return \StructType\SpecialRequestType|null
     */
    public function getSpecialRequests()
    {
        return $this->SpecialRequests;
    }
    /**
     * Set SpecialRequests value
     * @param \StructType\SpecialRequestType $specialRequests
     * @return \StructType\ResCommonDetailType
     */
    public function setSpecialRequests(\StructType\SpecialRequestType $specialRequests = null)
    {
        $this->SpecialRequests = $specialRequests;
        return $this;
    }
    /**
     * Get Guarantee value
     * @return \StructType\GuaranteeType|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * Set Guarantee value
     * @param \StructType\GuaranteeType $guarantee
     * @return \StructType\ResCommonDetailType
     */
    public function setGuarantee(\StructType\GuaranteeType $guarantee = null)
    {
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Get DepositPayments value
     * @return \StructType\RequiredPaymentsType|null
     */
    public function getDepositPayments()
    {
        return $this->DepositPayments;
    }
    /**
     * Set DepositPayments value
     * @param \StructType\RequiredPaymentsType $depositPayments
     * @return \StructType\ResCommonDetailType
     */
    public function setDepositPayments(\StructType\RequiredPaymentsType $depositPayments = null)
    {
        $this->DepositPayments = $depositPayments;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \StructType\CancelPenaltiesType|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \StructType\CancelPenaltiesType $cancelPenalties
     * @return \StructType\ResCommonDetailType
     */
    public function setCancelPenalties(\StructType\CancelPenaltiesType $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get Fees value
     * @return \StructType\FeesType|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \StructType\FeesType $fees
     * @return \StructType\ResCommonDetailType
     */
    public function setFees(\StructType\FeesType $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get Total value
     * @return \StructType\TotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \StructType\TotalType $total
     * @return \StructType\ResCommonDetailType
     */
    public function setTotal(\StructType\TotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResCommonDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
