<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequiredPaymentLiteType StructType
 * Meta information extracted from the WSDL
 * - documentation: Summary version of the RequiredPaymentType, initially created for the Travel Itinerary Message set.
 * @subpackage Structs
 */
class RequiredPaymentLiteType extends AbstractStructBase
{
    /**
     * The AcceptedPayments
     * Meta information extracted from the WSDL
     * - documentation: Collection of forms of payment accepted for payment.
     * - minOccurs: 0
     * @var \StructType\AcceptedPaymentsType
     */
    public $AcceptedPayments;
    /**
     * The AmountPercent
     * Meta information extracted from the WSDL
     * - documentation: Payment expressed as a fixed amount, or a percentage of/or room nights.
     * - minOccurs: 0
     * @var \StructType\AmountPercentType
     */
    public $AmountPercent;
    /**
     * The RetributionType
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RetributionType;
    /**
     * Constructor method for RequiredPaymentLiteType
     * @uses RequiredPaymentLiteType::setAcceptedPayments()
     * @uses RequiredPaymentLiteType::setAmountPercent()
     * @uses RequiredPaymentLiteType::setRetributionType()
     * @param \StructType\AcceptedPaymentsType $acceptedPayments
     * @param \StructType\AmountPercentType $amountPercent
     * @param string $retributionType
     */
    public function __construct(\StructType\AcceptedPaymentsType $acceptedPayments = null, \StructType\AmountPercentType $amountPercent = null, $retributionType = null)
    {
        $this
            ->setAcceptedPayments($acceptedPayments)
            ->setAmountPercent($amountPercent)
            ->setRetributionType($retributionType);
    }
    /**
     * Get AcceptedPayments value
     * @return \StructType\AcceptedPaymentsType|null
     */
    public function getAcceptedPayments()
    {
        return $this->AcceptedPayments;
    }
    /**
     * Set AcceptedPayments value
     * @param \StructType\AcceptedPaymentsType $acceptedPayments
     * @return \StructType\RequiredPaymentLiteType
     */
    public function setAcceptedPayments(\StructType\AcceptedPaymentsType $acceptedPayments = null)
    {
        $this->AcceptedPayments = $acceptedPayments;
        return $this;
    }
    /**
     * Get AmountPercent value
     * @return \StructType\AmountPercentType|null
     */
    public function getAmountPercent()
    {
        return $this->AmountPercent;
    }
    /**
     * Set AmountPercent value
     * @param \StructType\AmountPercentType $amountPercent
     * @return \StructType\RequiredPaymentLiteType
     */
    public function setAmountPercent(\StructType\AmountPercentType $amountPercent = null)
    {
        $this->AmountPercent = $amountPercent;
        return $this;
    }
    /**
     * Get RetributionType value
     * @return string|null
     */
    public function getRetributionType()
    {
        return $this->RetributionType;
    }
    /**
     * Set RetributionType value
     * @param string $retributionType
     * @return \StructType\RequiredPaymentLiteType
     */
    public function setRetributionType($retributionType = null)
    {
        // validation for constraint: string
        if (!is_null($retributionType) && !is_string($retributionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retributionType, true), gettype($retributionType)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($retributionType) && mb_strlen($retributionType) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($retributionType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($retributionType) && mb_strlen($retributionType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($retributionType)), __LINE__);
        }
        $this->RetributionType = $retributionType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequiredPaymentLiteType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
