<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipientInfosType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about one or more recipients.
 * @subpackage Structs
 */
class RecipientInfosType extends AbstractStructBase
{
    /**
     * The RecipientInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\RecipientInfo[]
     */
    public $RecipientInfo;
    /**
     * Constructor method for RecipientInfosType
     * @uses RecipientInfosType::setRecipientInfo()
     * @param \StructType\RecipientInfo[] $recipientInfo
     */
    public function __construct(array $recipientInfo = array())
    {
        $this
            ->setRecipientInfo($recipientInfo);
    }
    /**
     * Get RecipientInfo value
     * @return \StructType\RecipientInfo[]|null
     */
    public function getRecipientInfo()
    {
        return $this->RecipientInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setRecipientInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipientInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecipientInfoForArrayConstraintsFromSetRecipientInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recipientInfosTypeRecipientInfoItem) {
            // validation for constraint: itemType
            if (!$recipientInfosTypeRecipientInfoItem instanceof \StructType\RecipientInfo) {
                $invalidValues[] = is_object($recipientInfosTypeRecipientInfoItem) ? get_class($recipientInfosTypeRecipientInfoItem) : sprintf('%s(%s)', gettype($recipientInfosTypeRecipientInfoItem), var_export($recipientInfosTypeRecipientInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RecipientInfo property can only contain items of type \StructType\RecipientInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RecipientInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\RecipientInfo[] $recipientInfo
     * @return \StructType\RecipientInfosType
     */
    public function setRecipientInfo(array $recipientInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($recipientInfoArrayErrorMessage = self::validateRecipientInfoForArrayConstraintsFromSetRecipientInfo($recipientInfo))) {
            throw new \InvalidArgumentException($recipientInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($recipientInfo) && count($recipientInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($recipientInfo)), __LINE__);
        }
        $this->RecipientInfo = $recipientInfo;
        return $this;
    }
    /**
     * Add item to RecipientInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\RecipientInfo $item
     * @return \StructType\RecipientInfosType
     */
    public function addToRecipientInfo(\StructType\RecipientInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RecipientInfo) {
            throw new \InvalidArgumentException(sprintf('The RecipientInfo property can only contain items of type \StructType\RecipientInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->RecipientInfo) && count($this->RecipientInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->RecipientInfo)), __LINE__);
        }
        $this->RecipientInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecipientInfosType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
