<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipientInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Contact and/or reservation information pertaining to the recipient.
 * @subpackage Structs
 */
class RecipientInfo extends ContactPersonType
{
    /**
     * The ReservationID
     * Meta information extracted from the WSDL
     * - documentation: Provides the reservation number of the recipient for delivery of the product.
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type[]
     */
    public $ReservationID;
    /**
     * The ShippingInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShippingInfo
     */
    public $ShippingInfo;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Comments
     */
    public $Comments;
    /**
     * Constructor method for RecipientInfo
     * @uses RecipientInfo::setReservationID()
     * @uses RecipientInfo::setShippingInfo()
     * @uses RecipientInfo::setComments()
     * @param \StructType\UniqueID_Type[] $reservationID
     * @param \StructType\ShippingInfo $shippingInfo
     * @param \StructType\Comments $comments
     */
    public function __construct(array $reservationID = array(), \StructType\ShippingInfo $shippingInfo = null, \StructType\Comments $comments = null)
    {
        $this
            ->setReservationID($reservationID)
            ->setShippingInfo($shippingInfo)
            ->setComments($comments);
    }
    /**
     * Get ReservationID value
     * @return \StructType\UniqueID_Type[]|null
     */
    public function getReservationID()
    {
        return $this->ReservationID;
    }
    /**
     * This method is responsible for validating the values passed to the setReservationID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReservationID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReservationIDForArrayConstraintsFromSetReservationID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recipientInfoReservationIDItem) {
            // validation for constraint: itemType
            if (!$recipientInfoReservationIDItem instanceof \StructType\UniqueID_Type) {
                $invalidValues[] = is_object($recipientInfoReservationIDItem) ? get_class($recipientInfoReservationIDItem) : sprintf('%s(%s)', gettype($recipientInfoReservationIDItem), var_export($recipientInfoReservationIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReservationID property can only contain items of type \StructType\UniqueID_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReservationID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type[] $reservationID
     * @return \StructType\RecipientInfo
     */
    public function setReservationID(array $reservationID = array())
    {
        // validation for constraint: array
        if ('' !== ($reservationIDArrayErrorMessage = self::validateReservationIDForArrayConstraintsFromSetReservationID($reservationID))) {
            throw new \InvalidArgumentException($reservationIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($reservationID) && count($reservationID) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($reservationID)), __LINE__);
        }
        $this->ReservationID = $reservationID;
        return $this;
    }
    /**
     * Add item to ReservationID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type $item
     * @return \StructType\RecipientInfo
     */
    public function addToReservationID(\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The ReservationID property can only contain items of type \StructType\UniqueID_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->ReservationID) && count($this->ReservationID) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->ReservationID)), __LINE__);
        }
        $this->ReservationID[] = $item;
        return $this;
    }
    /**
     * Get ShippingInfo value
     * @return \StructType\ShippingInfo|null
     */
    public function getShippingInfo()
    {
        return $this->ShippingInfo;
    }
    /**
     * Set ShippingInfo value
     * @param \StructType\ShippingInfo $shippingInfo
     * @return \StructType\RecipientInfo
     */
    public function setShippingInfo(\StructType\ShippingInfo $shippingInfo = null)
    {
        $this->ShippingInfo = $shippingInfo;
        return $this;
    }
    /**
     * Get Comments value
     * @return \StructType\Comments|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \StructType\Comments $comments
     * @return \StructType\RecipientInfo
     */
    public function setComments(\StructType\Comments $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecipientInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
