<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateUploadType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the details of a rate.
 * @subpackage Structs
 */
class RateUploadType extends AbstractStructBase
{
    /**
     * The BaseByGuestAmts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BaseByGuestAmts
     */
    public $BaseByGuestAmts;
    /**
     * The AdditionalGuestAmounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionalGuestAmounts
     */
    public $AdditionalGuestAmounts;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - documentation: A collection of Fees.
     * - minOccurs: 0
     * @var \StructType\FeesType
     */
    public $Fees;
    /**
     * The GuaranteePolicies
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GuaranteePolicies
     */
    public $GuaranteePolicies;
    /**
     * The CancelPolicies
     * Meta information extracted from the WSDL
     * - documentation: A collection of Cancellation Policies.
     * - minOccurs: 0
     * @var \StructType\CancelPenaltiesType
     */
    public $CancelPolicies;
    /**
     * The PaymentPolicies
     * Meta information extracted from the WSDL
     * - documentation: A collection of Payment Policies.
     * - minOccurs: 0
     * @var \StructType\RequiredPaymentsType
     */
    public $PaymentPolicies;
    /**
     * The RateDescription
     * Meta information extracted from the WSDL
     * - documentation: Desription of Rate being uploaded.
     * - minOccurs: 0
     * @var \StructType\ParagraphType
     */
    public $RateDescription;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: The unique identifier element allows the trading partners to uniquely identify each Rate being uploaded, for traceable transactions.
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The MealsIncluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MealsIncluded
     */
    public $MealsIncluded;
    /**
     * The AdditionalCharges
     * Meta information extracted from the WSDL
     * - documentation: Breakout of additional charges as part of the rate plan.
     * - minOccurs: 0
     * @var \StructType\HotelAdditionalChargesType
     */
    public $AdditionalCharges;
    /**
     * The NumberOfUnits
     * Meta information extracted from the WSDL
     * - documentation: Indicates the number of rooms blocked or capped for this rate plan.
     * - use: optional
     * @var int
     */
    public $NumberOfUnits;
    /**
     * The RateTimeUnit
     * Meta information extracted from the WSDL
     * - documentation: Enumeration of time units upon which the RateAmount is based (e.g., daily, weekly, single rate for full stay).
     * - use: optional
     * @var string
     */
    public $RateTimeUnit;
    /**
     * The UnitMultiplier
     * Meta information extracted from the WSDL
     * - documentation: The number of RateTimeUnits that the rate Amount is based upon (e.g., flat rate for 3 days). | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $UnitMultiplier;
    /**
     * The MinGuestApplicable
     * Meta information extracted from the WSDL
     * - documentation: Minimum number of occupants for which this rate is valid (ex 1). | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $MinGuestApplicable;
    /**
     * The MaxGuestApplicable
     * Meta information extracted from the WSDL
     * - documentation: Maximum number of occupants for which this rate is valid (ex 2). | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $MaxGuestApplicable;
    /**
     * The MinLOS
     * Meta information extracted from the WSDL
     * - documentation: The minimum length of stay required by this rate plan. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $MinLOS;
    /**
     * The MaxLOS
     * Meta information extracted from the WSDL
     * - documentation: The maximum length of stay allowed by this rate plan. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $MaxLOS;
    /**
     * The StayOverDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates a specific day on which the guest must stay over in order to be eligible for the quoted rate plan.
     * - use: optional
     * @var string
     */
    public $StayOverDate;
    /**
     * The RateTier
     * Meta information extracted from the WSDL
     * - documentation: Hotel systems often have different tiers for a given rate plan; this attribute is used to designate a specific tier within the rate plan (e.g. high, medium, low). | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RateTier;
    /**
     * The AgeQualifyingCode
     * Meta information extracted from the WSDL
     * - documentation: Defines an age range or age category of a guest (e.g., under 21, over 65, teen, infant). Refer to OpenTravel Code List Age Qualifying Code (AQC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1,
     * 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The MinAge
     * Meta information extracted from the WSDL
     * - documentation: MinAge: The minimum age to qualify for AgeQualifyingCode. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - type: Numeric1to999
     * - use: optional
     * @var int
     */
    public $MinAge;
    /**
     * The MaxAge
     * Meta information extracted from the WSDL
     * - documentation: Max Age: The maximum age to qualify for AgeQualifyingCode. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - type: Numeric1to999
     * - use: optional
     * @var int
     */
    public $MaxAge;
    /**
     * The AgeTimeUnit
     * Meta information extracted from the WSDL
     * - documentation: TimeUnit : Qualifier for Age.
     * - type: TimeUnitType
     * - use: optional
     * @var string
     */
    public $AgeTimeUnit;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Allows for the specification of a night duration.
     * - union: duration | NightDurationType
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $End;
    /**
     * The Mon
     * @var bool
     */
    public $Mon;
    /**
     * The Tue
     * @var bool
     */
    public $Tue;
    /**
     * The Weds
     * @var bool
     */
    public $Weds;
    /**
     * The Thur
     * @var bool
     */
    public $Thur;
    /**
     * The Fri
     * @var bool
     */
    public $Fri;
    /**
     * The Sat
     * @var bool
     */
    public $Sat;
    /**
     * The Sun
     * @var bool
     */
    public $Sun;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for RateUploadType
     * @uses RateUploadType::setBaseByGuestAmts()
     * @uses RateUploadType::setAdditionalGuestAmounts()
     * @uses RateUploadType::setFees()
     * @uses RateUploadType::setGuaranteePolicies()
     * @uses RateUploadType::setCancelPolicies()
     * @uses RateUploadType::setPaymentPolicies()
     * @uses RateUploadType::setRateDescription()
     * @uses RateUploadType::setUniqueID()
     * @uses RateUploadType::setMealsIncluded()
     * @uses RateUploadType::setAdditionalCharges()
     * @uses RateUploadType::setNumberOfUnits()
     * @uses RateUploadType::setRateTimeUnit()
     * @uses RateUploadType::setUnitMultiplier()
     * @uses RateUploadType::setMinGuestApplicable()
     * @uses RateUploadType::setMaxGuestApplicable()
     * @uses RateUploadType::setMinLOS()
     * @uses RateUploadType::setMaxLOS()
     * @uses RateUploadType::setStayOverDate()
     * @uses RateUploadType::setRateTier()
     * @uses RateUploadType::setAgeQualifyingCode()
     * @uses RateUploadType::setMinAge()
     * @uses RateUploadType::setMaxAge()
     * @uses RateUploadType::setAgeTimeUnit()
     * @uses RateUploadType::setStart()
     * @uses RateUploadType::setDuration()
     * @uses RateUploadType::setEnd()
     * @uses RateUploadType::setMon()
     * @uses RateUploadType::setTue()
     * @uses RateUploadType::setWeds()
     * @uses RateUploadType::setThur()
     * @uses RateUploadType::setFri()
     * @uses RateUploadType::setSat()
     * @uses RateUploadType::setSun()
     * @uses RateUploadType::setCurrencyCode()
     * @uses RateUploadType::setDecimalPlaces()
     * @param \StructType\BaseByGuestAmts $baseByGuestAmts
     * @param \StructType\AdditionalGuestAmounts $additionalGuestAmounts
     * @param \StructType\FeesType $fees
     * @param \StructType\GuaranteePolicies $guaranteePolicies
     * @param \StructType\CancelPenaltiesType $cancelPolicies
     * @param \StructType\RequiredPaymentsType $paymentPolicies
     * @param \StructType\ParagraphType $rateDescription
     * @param \StructType\UniqueID_Type $uniqueID
     * @param \StructType\MealsIncluded $mealsIncluded
     * @param \StructType\HotelAdditionalChargesType $additionalCharges
     * @param int $numberOfUnits
     * @param string $rateTimeUnit
     * @param int $unitMultiplier
     * @param int $minGuestApplicable
     * @param int $maxGuestApplicable
     * @param string $minLOS
     * @param string $maxLOS
     * @param string $stayOverDate
     * @param string $rateTier
     * @param string $ageQualifyingCode
     * @param int $minAge
     * @param int $maxAge
     * @param string $ageTimeUnit
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param bool $mon
     * @param bool $tue
     * @param bool $weds
     * @param bool $thur
     * @param bool $fri
     * @param bool $sat
     * @param bool $sun
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct(\StructType\BaseByGuestAmts $baseByGuestAmts = null, \StructType\AdditionalGuestAmounts $additionalGuestAmounts = null, \StructType\FeesType $fees = null, \StructType\GuaranteePolicies $guaranteePolicies = null, \StructType\CancelPenaltiesType $cancelPolicies = null, \StructType\RequiredPaymentsType $paymentPolicies = null, \StructType\ParagraphType $rateDescription = null, \StructType\UniqueID_Type $uniqueID = null, \StructType\MealsIncluded $mealsIncluded = null, \StructType\HotelAdditionalChargesType $additionalCharges = null, $numberOfUnits = null, $rateTimeUnit = null, $unitMultiplier = null, $minGuestApplicable = null, $maxGuestApplicable = null, $minLOS = null, $maxLOS = null, $stayOverDate = null, $rateTier = null, $ageQualifyingCode = null, $minAge = null, $maxAge = null, $ageTimeUnit = null, $start = null, $duration = null, $end = null, $mon = null, $tue = null, $weds = null, $thur = null, $fri = null, $sat = null, $sun = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setBaseByGuestAmts($baseByGuestAmts)
            ->setAdditionalGuestAmounts($additionalGuestAmounts)
            ->setFees($fees)
            ->setGuaranteePolicies($guaranteePolicies)
            ->setCancelPolicies($cancelPolicies)
            ->setPaymentPolicies($paymentPolicies)
            ->setRateDescription($rateDescription)
            ->setUniqueID($uniqueID)
            ->setMealsIncluded($mealsIncluded)
            ->setAdditionalCharges($additionalCharges)
            ->setNumberOfUnits($numberOfUnits)
            ->setRateTimeUnit($rateTimeUnit)
            ->setUnitMultiplier($unitMultiplier)
            ->setMinGuestApplicable($minGuestApplicable)
            ->setMaxGuestApplicable($maxGuestApplicable)
            ->setMinLOS($minLOS)
            ->setMaxLOS($maxLOS)
            ->setStayOverDate($stayOverDate)
            ->setRateTier($rateTier)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setMinAge($minAge)
            ->setMaxAge($maxAge)
            ->setAgeTimeUnit($ageTimeUnit)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setMon($mon)
            ->setTue($tue)
            ->setWeds($weds)
            ->setThur($thur)
            ->setFri($fri)
            ->setSat($sat)
            ->setSun($sun)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get BaseByGuestAmts value
     * @return \StructType\BaseByGuestAmts|null
     */
    public function getBaseByGuestAmts()
    {
        return $this->BaseByGuestAmts;
    }
    /**
     * Set BaseByGuestAmts value
     * @param \StructType\BaseByGuestAmts $baseByGuestAmts
     * @return \StructType\RateUploadType
     */
    public function setBaseByGuestAmts(\StructType\BaseByGuestAmts $baseByGuestAmts = null)
    {
        $this->BaseByGuestAmts = $baseByGuestAmts;
        return $this;
    }
    /**
     * Get AdditionalGuestAmounts value
     * @return \StructType\AdditionalGuestAmounts|null
     */
    public function getAdditionalGuestAmounts()
    {
        return $this->AdditionalGuestAmounts;
    }
    /**
     * Set AdditionalGuestAmounts value
     * @param \StructType\AdditionalGuestAmounts $additionalGuestAmounts
     * @return \StructType\RateUploadType
     */
    public function setAdditionalGuestAmounts(\StructType\AdditionalGuestAmounts $additionalGuestAmounts = null)
    {
        $this->AdditionalGuestAmounts = $additionalGuestAmounts;
        return $this;
    }
    /**
     * Get Fees value
     * @return \StructType\FeesType|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \StructType\FeesType $fees
     * @return \StructType\RateUploadType
     */
    public function setFees(\StructType\FeesType $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get GuaranteePolicies value
     * @return \StructType\GuaranteePolicies|null
     */
    public function getGuaranteePolicies()
    {
        return $this->GuaranteePolicies;
    }
    /**
     * Set GuaranteePolicies value
     * @param \StructType\GuaranteePolicies $guaranteePolicies
     * @return \StructType\RateUploadType
     */
    public function setGuaranteePolicies(\StructType\GuaranteePolicies $guaranteePolicies = null)
    {
        $this->GuaranteePolicies = $guaranteePolicies;
        return $this;
    }
    /**
     * Get CancelPolicies value
     * @return \StructType\CancelPenaltiesType|null
     */
    public function getCancelPolicies()
    {
        return $this->CancelPolicies;
    }
    /**
     * Set CancelPolicies value
     * @param \StructType\CancelPenaltiesType $cancelPolicies
     * @return \StructType\RateUploadType
     */
    public function setCancelPolicies(\StructType\CancelPenaltiesType $cancelPolicies = null)
    {
        $this->CancelPolicies = $cancelPolicies;
        return $this;
    }
    /**
     * Get PaymentPolicies value
     * @return \StructType\RequiredPaymentsType|null
     */
    public function getPaymentPolicies()
    {
        return $this->PaymentPolicies;
    }
    /**
     * Set PaymentPolicies value
     * @param \StructType\RequiredPaymentsType $paymentPolicies
     * @return \StructType\RateUploadType
     */
    public function setPaymentPolicies(\StructType\RequiredPaymentsType $paymentPolicies = null)
    {
        $this->PaymentPolicies = $paymentPolicies;
        return $this;
    }
    /**
     * Get RateDescription value
     * @return \StructType\ParagraphType|null
     */
    public function getRateDescription()
    {
        return $this->RateDescription;
    }
    /**
     * Set RateDescription value
     * @param \StructType\ParagraphType $rateDescription
     * @return \StructType\RateUploadType
     */
    public function setRateDescription(\StructType\ParagraphType $rateDescription = null)
    {
        $this->RateDescription = $rateDescription;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\RateUploadType
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get MealsIncluded value
     * @return \StructType\MealsIncluded|null
     */
    public function getMealsIncluded()
    {
        return $this->MealsIncluded;
    }
    /**
     * Set MealsIncluded value
     * @param \StructType\MealsIncluded $mealsIncluded
     * @return \StructType\RateUploadType
     */
    public function setMealsIncluded(\StructType\MealsIncluded $mealsIncluded = null)
    {
        $this->MealsIncluded = $mealsIncluded;
        return $this;
    }
    /**
     * Get AdditionalCharges value
     * @return \StructType\HotelAdditionalChargesType|null
     */
    public function getAdditionalCharges()
    {
        return $this->AdditionalCharges;
    }
    /**
     * Set AdditionalCharges value
     * @param \StructType\HotelAdditionalChargesType $additionalCharges
     * @return \StructType\RateUploadType
     */
    public function setAdditionalCharges(\StructType\HotelAdditionalChargesType $additionalCharges = null)
    {
        $this->AdditionalCharges = $additionalCharges;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \StructType\RateUploadType
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !(is_int($numberOfUnits) || ctype_digit($numberOfUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUnits, true), gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get RateTimeUnit value
     * @return string|null
     */
    public function getRateTimeUnit()
    {
        return $this->RateTimeUnit;
    }
    /**
     * Set RateTimeUnit value
     * @uses \EnumType\TimeUnitType::valueIsValid()
     * @uses \EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rateTimeUnit
     * @return \StructType\RateUploadType
     */
    public function setRateTimeUnit($rateTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitType::valueIsValid($rateTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitType', is_array($rateTimeUnit) ? implode(', ', $rateTimeUnit) : var_export($rateTimeUnit, true), implode(', ', \EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->RateTimeUnit = $rateTimeUnit;
        return $this;
    }
    /**
     * Get UnitMultiplier value
     * @return int|null
     */
    public function getUnitMultiplier()
    {
        return $this->UnitMultiplier;
    }
    /**
     * Set UnitMultiplier value
     * @param int $unitMultiplier
     * @return \StructType\RateUploadType
     */
    public function setUnitMultiplier($unitMultiplier = null)
    {
        // validation for constraint: int
        if (!is_null($unitMultiplier) && !(is_int($unitMultiplier) || ctype_digit($unitMultiplier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unitMultiplier, true), gettype($unitMultiplier)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($unitMultiplier) && $unitMultiplier > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($unitMultiplier, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($unitMultiplier) && $unitMultiplier < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($unitMultiplier, true)), __LINE__);
        }
        $this->UnitMultiplier = $unitMultiplier;
        return $this;
    }
    /**
     * Get MinGuestApplicable value
     * @return int|null
     */
    public function getMinGuestApplicable()
    {
        return $this->MinGuestApplicable;
    }
    /**
     * Set MinGuestApplicable value
     * @param int $minGuestApplicable
     * @return \StructType\RateUploadType
     */
    public function setMinGuestApplicable($minGuestApplicable = null)
    {
        // validation for constraint: int
        if (!is_null($minGuestApplicable) && !(is_int($minGuestApplicable) || ctype_digit($minGuestApplicable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minGuestApplicable, true), gettype($minGuestApplicable)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($minGuestApplicable) && $minGuestApplicable > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($minGuestApplicable, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($minGuestApplicable) && $minGuestApplicable < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($minGuestApplicable, true)), __LINE__);
        }
        $this->MinGuestApplicable = $minGuestApplicable;
        return $this;
    }
    /**
     * Get MaxGuestApplicable value
     * @return int|null
     */
    public function getMaxGuestApplicable()
    {
        return $this->MaxGuestApplicable;
    }
    /**
     * Set MaxGuestApplicable value
     * @param int $maxGuestApplicable
     * @return \StructType\RateUploadType
     */
    public function setMaxGuestApplicable($maxGuestApplicable = null)
    {
        // validation for constraint: int
        if (!is_null($maxGuestApplicable) && !(is_int($maxGuestApplicable) || ctype_digit($maxGuestApplicable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxGuestApplicable, true), gettype($maxGuestApplicable)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($maxGuestApplicable) && $maxGuestApplicable > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($maxGuestApplicable, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($maxGuestApplicable) && $maxGuestApplicable < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($maxGuestApplicable, true)), __LINE__);
        }
        $this->MaxGuestApplicable = $maxGuestApplicable;
        return $this;
    }
    /**
     * Get MinLOS value
     * @return string|null
     */
    public function getMinLOS()
    {
        return $this->MinLOS;
    }
    /**
     * Set MinLOS value
     * @param string $minLOS
     * @return \StructType\RateUploadType
     */
    public function setMinLOS($minLOS = null)
    {
        // validation for constraint: string
        if (!is_null($minLOS) && !is_string($minLOS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minLOS, true), gettype($minLOS)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($minLOS) && mb_strlen($minLOS) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($minLOS)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($minLOS) && mb_strlen($minLOS) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($minLOS)), __LINE__);
        }
        $this->MinLOS = $minLOS;
        return $this;
    }
    /**
     * Get MaxLOS value
     * @return string|null
     */
    public function getMaxLOS()
    {
        return $this->MaxLOS;
    }
    /**
     * Set MaxLOS value
     * @param string $maxLOS
     * @return \StructType\RateUploadType
     */
    public function setMaxLOS($maxLOS = null)
    {
        // validation for constraint: string
        if (!is_null($maxLOS) && !is_string($maxLOS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxLOS, true), gettype($maxLOS)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($maxLOS) && mb_strlen($maxLOS) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($maxLOS)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($maxLOS) && mb_strlen($maxLOS) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($maxLOS)), __LINE__);
        }
        $this->MaxLOS = $maxLOS;
        return $this;
    }
    /**
     * Get StayOverDate value
     * @return string|null
     */
    public function getStayOverDate()
    {
        return $this->StayOverDate;
    }
    /**
     * Set StayOverDate value
     * @uses \EnumType\DayOfWeekType::valueIsValid()
     * @uses \EnumType\DayOfWeekType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stayOverDate
     * @return \StructType\RateUploadType
     */
    public function setStayOverDate($stayOverDate = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DayOfWeekType::valueIsValid($stayOverDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DayOfWeekType', is_array($stayOverDate) ? implode(', ', $stayOverDate) : var_export($stayOverDate, true), implode(', ', \EnumType\DayOfWeekType::getValidValues())), __LINE__);
        }
        $this->StayOverDate = $stayOverDate;
        return $this;
    }
    /**
     * Get RateTier value
     * @return string|null
     */
    public function getRateTier()
    {
        return $this->RateTier;
    }
    /**
     * Set RateTier value
     * @param string $rateTier
     * @return \StructType\RateUploadType
     */
    public function setRateTier($rateTier = null)
    {
        // validation for constraint: string
        if (!is_null($rateTier) && !is_string($rateTier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateTier, true), gettype($rateTier)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($rateTier) && mb_strlen($rateTier) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($rateTier)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($rateTier) && mb_strlen($rateTier) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($rateTier)), __LINE__);
        }
        $this->RateTier = $rateTier;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \StructType\RateUploadType
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($ageQualifyingCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($ageQualifyingCode, true)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get MinAge value
     * @return int|null
     */
    public function getMinAge()
    {
        return $this->MinAge;
    }
    /**
     * Set MinAge value
     * @param int $minAge
     * @return \StructType\RateUploadType
     */
    public function setMinAge($minAge = null)
    {
        // validation for constraint: int
        if (!is_null($minAge) && !(is_int($minAge) || ctype_digit($minAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minAge, true), gettype($minAge)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($minAge) && $minAge > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($minAge, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($minAge) && $minAge < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($minAge, true)), __LINE__);
        }
        $this->MinAge = $minAge;
        return $this;
    }
    /**
     * Get MaxAge value
     * @return int|null
     */
    public function getMaxAge()
    {
        return $this->MaxAge;
    }
    /**
     * Set MaxAge value
     * @param int $maxAge
     * @return \StructType\RateUploadType
     */
    public function setMaxAge($maxAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxAge) && !(is_int($maxAge) || ctype_digit($maxAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAge, true), gettype($maxAge)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($maxAge) && $maxAge > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($maxAge, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($maxAge) && $maxAge < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($maxAge, true)), __LINE__);
        }
        $this->MaxAge = $maxAge;
        return $this;
    }
    /**
     * Get AgeTimeUnit value
     * @return string|null
     */
    public function getAgeTimeUnit()
    {
        return $this->AgeTimeUnit;
    }
    /**
     * Set AgeTimeUnit value
     * @uses \EnumType\TimeUnitType::valueIsValid()
     * @uses \EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ageTimeUnit
     * @return \StructType\RateUploadType
     */
    public function setAgeTimeUnit($ageTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitType::valueIsValid($ageTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitType', is_array($ageTimeUnit) ? implode(', ', $ageTimeUnit) : var_export($ageTimeUnit, true), implode(', ', \EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->AgeTimeUnit = $ageTimeUnit;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\RateUploadType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This is a set of validation rules based on the union types associated to the property being set by the setDuration method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurationForUnionConstraintsFromSetDuration($value)
    {
        $message = '';
        // validation for constraint: pattern(P[0-9]{1,3}N)
        if (!is_null($value) && !preg_match('/P[0-9]{1,3}N/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression P[0-9]{1,3}N', var_export($value, true)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: duration, NightDurationType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\RateUploadType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: union(duration, NightDurationType)
        if ('' !== ($durationUnionErrorMessage = self::validateDurationForUnionConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationUnionErrorMessage, __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndForUnionConstraintsFromSetEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\RateUploadType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($endUnionErrorMessage = self::validateEndForUnionConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endUnionErrorMessage, __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Mon value
     * @return bool|null
     */
    public function getMon()
    {
        return $this->Mon;
    }
    /**
     * Set Mon value
     * @param bool $mon
     * @return \StructType\RateUploadType
     */
    public function setMon($mon = null)
    {
        // validation for constraint: boolean
        if (!is_null($mon) && !is_bool($mon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mon, true), gettype($mon)), __LINE__);
        }
        $this->Mon = $mon;
        return $this;
    }
    /**
     * Get Tue value
     * @return bool|null
     */
    public function getTue()
    {
        return $this->Tue;
    }
    /**
     * Set Tue value
     * @param bool $tue
     * @return \StructType\RateUploadType
     */
    public function setTue($tue = null)
    {
        // validation for constraint: boolean
        if (!is_null($tue) && !is_bool($tue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tue, true), gettype($tue)), __LINE__);
        }
        $this->Tue = $tue;
        return $this;
    }
    /**
     * Get Weds value
     * @return bool|null
     */
    public function getWeds()
    {
        return $this->Weds;
    }
    /**
     * Set Weds value
     * @param bool $weds
     * @return \StructType\RateUploadType
     */
    public function setWeds($weds = null)
    {
        // validation for constraint: boolean
        if (!is_null($weds) && !is_bool($weds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($weds, true), gettype($weds)), __LINE__);
        }
        $this->Weds = $weds;
        return $this;
    }
    /**
     * Get Thur value
     * @return bool|null
     */
    public function getThur()
    {
        return $this->Thur;
    }
    /**
     * Set Thur value
     * @param bool $thur
     * @return \StructType\RateUploadType
     */
    public function setThur($thur = null)
    {
        // validation for constraint: boolean
        if (!is_null($thur) && !is_bool($thur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($thur, true), gettype($thur)), __LINE__);
        }
        $this->Thur = $thur;
        return $this;
    }
    /**
     * Get Fri value
     * @return bool|null
     */
    public function getFri()
    {
        return $this->Fri;
    }
    /**
     * Set Fri value
     * @param bool $fri
     * @return \StructType\RateUploadType
     */
    public function setFri($fri = null)
    {
        // validation for constraint: boolean
        if (!is_null($fri) && !is_bool($fri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fri, true), gettype($fri)), __LINE__);
        }
        $this->Fri = $fri;
        return $this;
    }
    /**
     * Get Sat value
     * @return bool|null
     */
    public function getSat()
    {
        return $this->Sat;
    }
    /**
     * Set Sat value
     * @param bool $sat
     * @return \StructType\RateUploadType
     */
    public function setSat($sat = null)
    {
        // validation for constraint: boolean
        if (!is_null($sat) && !is_bool($sat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sat, true), gettype($sat)), __LINE__);
        }
        $this->Sat = $sat;
        return $this;
    }
    /**
     * Get Sun value
     * @return bool|null
     */
    public function getSun()
    {
        return $this->Sun;
    }
    /**
     * Set Sun value
     * @param bool $sun
     * @return \StructType\RateUploadType
     */
    public function setSun($sun = null)
    {
        // validation for constraint: boolean
        if (!is_null($sun) && !is_bool($sun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sun, true), gettype($sun)), __LINE__);
        }
        $this->Sun = $sun;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\RateUploadType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\RateUploadType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateUploadType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
