<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateType StructType
 * Meta information extracted from the WSDL
 * - documentation: Individual rate amount. This rate is valid for a range of number of occupants and an occupant type.
 * @subpackage Structs
 */
class RateType extends AbstractStructBase
{
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Rate[]
     */
    public $Rate;
    /**
     * Constructor method for RateType
     * @uses RateType::setRate()
     * @param \StructType\Rate[] $rate
     */
    public function __construct(array $rate = array())
    {
        $this
            ->setRate($rate);
    }
    /**
     * Get Rate value
     * @return \StructType\Rate[]|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * This method is responsible for validating the values passed to the setRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateForArrayConstraintsFromSetRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rateTypeRateItem) {
            // validation for constraint: itemType
            if (!$rateTypeRateItem instanceof \StructType\Rate) {
                $invalidValues[] = is_object($rateTypeRateItem) ? get_class($rateTypeRateItem) : sprintf('%s(%s)', gettype($rateTypeRateItem), var_export($rateTypeRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Rate property can only contain items of type \StructType\Rate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Rate value
     * @throws \InvalidArgumentException
     * @param \StructType\Rate[] $rate
     * @return \StructType\RateType
     */
    public function setRate(array $rate = array())
    {
        // validation for constraint: array
        if ('' !== ($rateArrayErrorMessage = self::validateRateForArrayConstraintsFromSetRate($rate))) {
            throw new \InvalidArgumentException($rateArrayErrorMessage, __LINE__);
        }
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Add item to Rate value
     * @throws \InvalidArgumentException
     * @param \StructType\Rate $item
     * @return \StructType\RateType
     */
    public function addToRate(\StructType\Rate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Rate) {
            throw new \InvalidArgumentException(sprintf('The Rate property can only contain items of type \StructType\Rate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Rate[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
