<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateRulesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of rules pertaining to the rental rate and/or vehicle.
 * @subpackage Structs
 */
class RateRulesType extends AbstractStructBase
{
    /**
     * The AdvanceBooking
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdvanceBooking
     */
    public $AdvanceBooking;
    /**
     * The PickupReturnRules
     * Meta information extracted from the WSDL
     * - maxOccurs: 7
     * - minOccurs: 0
     * @var \StructType\PickupReturnRules[]
     */
    public $PickupReturnRules;
    /**
     * The RateGuarantee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RateGuarantee
     */
    public $RateGuarantee;
    /**
     * The PaymentRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentRules
     */
    public $PaymentRules;
    /**
     * The CancelPenaltyInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\CancelPenaltyInfo[]
     */
    public $CancelPenaltyInfo;
    /**
     * The RateDeposit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RateDeposit
     */
    public $RateDeposit;
    /**
     * The MinimumKeep
     * Meta information extracted from the WSDL
     * - documentation: The minimum time (e.g., number of rental days, number of rental hours) required to qualify for a specific rate.
     * - use: optional
     * @var string
     */
    public $MinimumKeep;
    /**
     * The MaximumKeep
     * Meta information extracted from the WSDL
     * - documentation: The maximum time (e.g., number of rental days, number of rental hours) allowed to qualify for a specific rate.
     * - use: optional
     * @var string
     */
    public $MaximumKeep;
    /**
     * The MaximumRental
     * Meta information extracted from the WSDL
     * - documentation: The maximum number of rental days a vehicle is allowed to be rented.
     * - use: optional
     * @var string
     */
    public $MaximumRental;
    /**
     * Constructor method for RateRulesType
     * @uses RateRulesType::setAdvanceBooking()
     * @uses RateRulesType::setPickupReturnRules()
     * @uses RateRulesType::setRateGuarantee()
     * @uses RateRulesType::setPaymentRules()
     * @uses RateRulesType::setCancelPenaltyInfo()
     * @uses RateRulesType::setRateDeposit()
     * @uses RateRulesType::setMinimumKeep()
     * @uses RateRulesType::setMaximumKeep()
     * @uses RateRulesType::setMaximumRental()
     * @param \StructType\AdvanceBooking $advanceBooking
     * @param \StructType\PickupReturnRules[] $pickupReturnRules
     * @param \StructType\RateGuarantee $rateGuarantee
     * @param \StructType\PaymentRules $paymentRules
     * @param \StructType\CancelPenaltyInfo[] $cancelPenaltyInfo
     * @param \StructType\RateDeposit $rateDeposit
     * @param string $minimumKeep
     * @param string $maximumKeep
     * @param string $maximumRental
     */
    public function __construct(\StructType\AdvanceBooking $advanceBooking = null, array $pickupReturnRules = array(), \StructType\RateGuarantee $rateGuarantee = null, \StructType\PaymentRules $paymentRules = null, array $cancelPenaltyInfo = array(), \StructType\RateDeposit $rateDeposit = null, $minimumKeep = null, $maximumKeep = null, $maximumRental = null)
    {
        $this
            ->setAdvanceBooking($advanceBooking)
            ->setPickupReturnRules($pickupReturnRules)
            ->setRateGuarantee($rateGuarantee)
            ->setPaymentRules($paymentRules)
            ->setCancelPenaltyInfo($cancelPenaltyInfo)
            ->setRateDeposit($rateDeposit)
            ->setMinimumKeep($minimumKeep)
            ->setMaximumKeep($maximumKeep)
            ->setMaximumRental($maximumRental);
    }
    /**
     * Get AdvanceBooking value
     * @return \StructType\AdvanceBooking|null
     */
    public function getAdvanceBooking()
    {
        return $this->AdvanceBooking;
    }
    /**
     * Set AdvanceBooking value
     * @param \StructType\AdvanceBooking $advanceBooking
     * @return \StructType\RateRulesType
     */
    public function setAdvanceBooking(\StructType\AdvanceBooking $advanceBooking = null)
    {
        $this->AdvanceBooking = $advanceBooking;
        return $this;
    }
    /**
     * Get PickupReturnRules value
     * @return \StructType\PickupReturnRules[]|null
     */
    public function getPickupReturnRules()
    {
        return $this->PickupReturnRules;
    }
    /**
     * This method is responsible for validating the values passed to the setPickupReturnRules method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPickupReturnRules method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePickupReturnRulesForArrayConstraintsFromSetPickupReturnRules(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rateRulesTypePickupReturnRulesItem) {
            // validation for constraint: itemType
            if (!$rateRulesTypePickupReturnRulesItem instanceof \StructType\PickupReturnRules) {
                $invalidValues[] = is_object($rateRulesTypePickupReturnRulesItem) ? get_class($rateRulesTypePickupReturnRulesItem) : sprintf('%s(%s)', gettype($rateRulesTypePickupReturnRulesItem), var_export($rateRulesTypePickupReturnRulesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PickupReturnRules property can only contain items of type \StructType\PickupReturnRules, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PickupReturnRules value
     * @throws \InvalidArgumentException
     * @param \StructType\PickupReturnRules[] $pickupReturnRules
     * @return \StructType\RateRulesType
     */
    public function setPickupReturnRules(array $pickupReturnRules = array())
    {
        // validation for constraint: array
        if ('' !== ($pickupReturnRulesArrayErrorMessage = self::validatePickupReturnRulesForArrayConstraintsFromSetPickupReturnRules($pickupReturnRules))) {
            throw new \InvalidArgumentException($pickupReturnRulesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(7)
        if (is_array($pickupReturnRules) && count($pickupReturnRules) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 7', count($pickupReturnRules)), __LINE__);
        }
        $this->PickupReturnRules = $pickupReturnRules;
        return $this;
    }
    /**
     * Add item to PickupReturnRules value
     * @throws \InvalidArgumentException
     * @param \StructType\PickupReturnRules $item
     * @return \StructType\RateRulesType
     */
    public function addToPickupReturnRules(\StructType\PickupReturnRules $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PickupReturnRules) {
            throw new \InvalidArgumentException(sprintf('The PickupReturnRules property can only contain items of type \StructType\PickupReturnRules, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(7)
        if (is_array($this->PickupReturnRules) && count($this->PickupReturnRules) >= 7) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 7', count($this->PickupReturnRules)), __LINE__);
        }
        $this->PickupReturnRules[] = $item;
        return $this;
    }
    /**
     * Get RateGuarantee value
     * @return \StructType\RateGuarantee|null
     */
    public function getRateGuarantee()
    {
        return $this->RateGuarantee;
    }
    /**
     * Set RateGuarantee value
     * @param \StructType\RateGuarantee $rateGuarantee
     * @return \StructType\RateRulesType
     */
    public function setRateGuarantee(\StructType\RateGuarantee $rateGuarantee = null)
    {
        $this->RateGuarantee = $rateGuarantee;
        return $this;
    }
    /**
     * Get PaymentRules value
     * @return \StructType\PaymentRules|null
     */
    public function getPaymentRules()
    {
        return $this->PaymentRules;
    }
    /**
     * Set PaymentRules value
     * @param \StructType\PaymentRules $paymentRules
     * @return \StructType\RateRulesType
     */
    public function setPaymentRules(\StructType\PaymentRules $paymentRules = null)
    {
        $this->PaymentRules = $paymentRules;
        return $this;
    }
    /**
     * Get CancelPenaltyInfo value
     * @return \StructType\CancelPenaltyInfo[]|null
     */
    public function getCancelPenaltyInfo()
    {
        return $this->CancelPenaltyInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelPenaltyInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelPenaltyInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelPenaltyInfoForArrayConstraintsFromSetCancelPenaltyInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rateRulesTypeCancelPenaltyInfoItem) {
            // validation for constraint: itemType
            if (!$rateRulesTypeCancelPenaltyInfoItem instanceof \StructType\CancelPenaltyInfo) {
                $invalidValues[] = is_object($rateRulesTypeCancelPenaltyInfoItem) ? get_class($rateRulesTypeCancelPenaltyInfoItem) : sprintf('%s(%s)', gettype($rateRulesTypeCancelPenaltyInfoItem), var_export($rateRulesTypeCancelPenaltyInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelPenaltyInfo property can only contain items of type \StructType\CancelPenaltyInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CancelPenaltyInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelPenaltyInfo[] $cancelPenaltyInfo
     * @return \StructType\RateRulesType
     */
    public function setCancelPenaltyInfo(array $cancelPenaltyInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelPenaltyInfoArrayErrorMessage = self::validateCancelPenaltyInfoForArrayConstraintsFromSetCancelPenaltyInfo($cancelPenaltyInfo))) {
            throw new \InvalidArgumentException($cancelPenaltyInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($cancelPenaltyInfo) && count($cancelPenaltyInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($cancelPenaltyInfo)), __LINE__);
        }
        $this->CancelPenaltyInfo = $cancelPenaltyInfo;
        return $this;
    }
    /**
     * Add item to CancelPenaltyInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelPenaltyInfo $item
     * @return \StructType\RateRulesType
     */
    public function addToCancelPenaltyInfo(\StructType\CancelPenaltyInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelPenaltyInfo) {
            throw new \InvalidArgumentException(sprintf('The CancelPenaltyInfo property can only contain items of type \StructType\CancelPenaltyInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->CancelPenaltyInfo) && count($this->CancelPenaltyInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->CancelPenaltyInfo)), __LINE__);
        }
        $this->CancelPenaltyInfo[] = $item;
        return $this;
    }
    /**
     * Get RateDeposit value
     * @return \StructType\RateDeposit|null
     */
    public function getRateDeposit()
    {
        return $this->RateDeposit;
    }
    /**
     * Set RateDeposit value
     * @param \StructType\RateDeposit $rateDeposit
     * @return \StructType\RateRulesType
     */
    public function setRateDeposit(\StructType\RateDeposit $rateDeposit = null)
    {
        $this->RateDeposit = $rateDeposit;
        return $this;
    }
    /**
     * Get MinimumKeep value
     * @return string|null
     */
    public function getMinimumKeep()
    {
        return $this->MinimumKeep;
    }
    /**
     * Set MinimumKeep value
     * @param string $minimumKeep
     * @return \StructType\RateRulesType
     */
    public function setMinimumKeep($minimumKeep = null)
    {
        // validation for constraint: string
        if (!is_null($minimumKeep) && !is_string($minimumKeep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumKeep, true), gettype($minimumKeep)), __LINE__);
        }
        $this->MinimumKeep = $minimumKeep;
        return $this;
    }
    /**
     * Get MaximumKeep value
     * @return string|null
     */
    public function getMaximumKeep()
    {
        return $this->MaximumKeep;
    }
    /**
     * Set MaximumKeep value
     * @param string $maximumKeep
     * @return \StructType\RateRulesType
     */
    public function setMaximumKeep($maximumKeep = null)
    {
        // validation for constraint: string
        if (!is_null($maximumKeep) && !is_string($maximumKeep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumKeep, true), gettype($maximumKeep)), __LINE__);
        }
        $this->MaximumKeep = $maximumKeep;
        return $this;
    }
    /**
     * Get MaximumRental value
     * @return string|null
     */
    public function getMaximumRental()
    {
        return $this->MaximumRental;
    }
    /**
     * Set MaximumRental value
     * @param string $maximumRental
     * @return \StructType\RateRulesType
     */
    public function setMaximumRental($maximumRental = null)
    {
        // validation for constraint: string
        if (!is_null($maximumRental) && !is_string($maximumRental)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumRental, true), gettype($maximumRental)), __LINE__);
        }
        $this->MaximumRental = $maximumRental;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateRulesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
