<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateQualifier StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates the type of rates applicable to the customer, along with any discount number or promotional codes that affect the quoted rate. | Indicates the type of rates of interest to the customer, along with any discount number or
 * promotional codes that may affect the rate.
 * - type: StringLength1to32
 * - use: optional
 * @subpackage Structs
 */
class RateQualifier extends RateQualifierType
{
    /**
     * The TravelPurpose
     * Meta information extracted from the WSDL
     * - documentation: Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $TravelPurpose;
    /**
     * The RateCategory
     * Meta information extracted from the WSDL
     * - documentation: Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $RateCategory;
    /**
     * The CorpDiscountNmbr
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $CorpDiscountNmbr;
    /**
     * The RateQualifier
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $RateQualifier;
    /**
     * The RatePeriod
     * @var string
     */
    public $RatePeriod;
    /**
     * The GuaranteedInd
     * @var bool
     */
    public $GuaranteedInd;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $PromotionCode;
    /**
     * The PromotionVendorCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8. | List of StringLength1to8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string[]
     */
    public $PromotionVendorCode;
    /**
     * The TourInfoRPH
     * Meta information extracted from the WSDL
     * - documentation: Provides a reference pointer that links the availability rate to a TourInfo. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or
     * clients to particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $TourInfoRPH;
    /**
     * The CustLoyaltyRPH
     * Meta information extracted from the WSDL
     * - documentation: Provides a reference pointer that links the availability rate to one or more CustLoyalty RPHs. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign
     * individual passengers or clients to particular itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $CustLoyaltyRPH;
    /**
     * The QuoteID
     * Meta information extracted from the WSDL
     * - documentation: A reference string used to match a query, with rates, to a given time. This is useful for matching prices within a given quote period. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $QuoteID;
    /**
     * Constructor method for RateQualifier
     * @uses RateQualifier::setTravelPurpose()
     * @uses RateQualifier::setRateCategory()
     * @uses RateQualifier::setCorpDiscountNmbr()
     * @uses RateQualifier::setRateQualifier()
     * @uses RateQualifier::setRatePeriod()
     * @uses RateQualifier::setGuaranteedInd()
     * @uses RateQualifier::setPromotionCode()
     * @uses RateQualifier::setPromotionVendorCode()
     * @uses RateQualifier::setTourInfoRPH()
     * @uses RateQualifier::setCustLoyaltyRPH()
     * @uses RateQualifier::setQuoteID()
     * @param string $travelPurpose
     * @param string $rateCategory
     * @param string $corpDiscountNmbr
     * @param string $rateQualifier
     * @param string $ratePeriod
     * @param bool $guaranteedInd
     * @param string $promotionCode
     * @param string[] $promotionVendorCode
     * @param string $tourInfoRPH
     * @param string[] $custLoyaltyRPH
     * @param string $quoteID
     */
    public function __construct($travelPurpose = null, $rateCategory = null, $corpDiscountNmbr = null, $rateQualifier = null, $ratePeriod = null, $guaranteedInd = null, $promotionCode = null, array $promotionVendorCode = array(), $tourInfoRPH = null, array $custLoyaltyRPH = array(), $quoteID = null)
    {
        $this
            ->setTravelPurpose($travelPurpose)
            ->setRateCategory($rateCategory)
            ->setCorpDiscountNmbr($corpDiscountNmbr)
            ->setRateQualifier($rateQualifier)
            ->setRatePeriod($ratePeriod)
            ->setGuaranteedInd($guaranteedInd)
            ->setPromotionCode($promotionCode)
            ->setPromotionVendorCode($promotionVendorCode)
            ->setTourInfoRPH($tourInfoRPH)
            ->setCustLoyaltyRPH($custLoyaltyRPH)
            ->setQuoteID($quoteID);
    }
    /**
     * Get TravelPurpose value
     * @return string|null
     */
    public function getTravelPurpose()
    {
        return $this->TravelPurpose;
    }
    /**
     * Set TravelPurpose value
     * @param string $travelPurpose
     * @return \StructType\RateQualifier
     */
    public function setTravelPurpose($travelPurpose = null)
    {
        // validation for constraint: string
        if (!is_null($travelPurpose) && !is_string($travelPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelPurpose, true), gettype($travelPurpose)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($travelPurpose) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $travelPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($travelPurpose, true)), __LINE__);
        }
        $this->TravelPurpose = $travelPurpose;
        return $this;
    }
    /**
     * Get RateCategory value
     * @return string|null
     */
    public function getRateCategory()
    {
        return $this->RateCategory;
    }
    /**
     * Set RateCategory value
     * @param string $rateCategory
     * @return \StructType\RateQualifier
     */
    public function setRateCategory($rateCategory = null)
    {
        // validation for constraint: string
        if (!is_null($rateCategory) && !is_string($rateCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateCategory, true), gettype($rateCategory)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($rateCategory) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $rateCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($rateCategory, true)), __LINE__);
        }
        $this->RateCategory = $rateCategory;
        return $this;
    }
    /**
     * Get CorpDiscountNmbr value
     * @return string|null
     */
    public function getCorpDiscountNmbr()
    {
        return $this->CorpDiscountNmbr;
    }
    /**
     * Set CorpDiscountNmbr value
     * @param string $corpDiscountNmbr
     * @return \StructType\RateQualifier
     */
    public function setCorpDiscountNmbr($corpDiscountNmbr = null)
    {
        // validation for constraint: string
        if (!is_null($corpDiscountNmbr) && !is_string($corpDiscountNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corpDiscountNmbr, true), gettype($corpDiscountNmbr)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($corpDiscountNmbr) && mb_strlen($corpDiscountNmbr) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($corpDiscountNmbr)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($corpDiscountNmbr) && mb_strlen($corpDiscountNmbr) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($corpDiscountNmbr)), __LINE__);
        }
        $this->CorpDiscountNmbr = $corpDiscountNmbr;
        return $this;
    }
    /**
     * Get RateQualifier value
     * @return string|null
     */
    public function getRateQualifier()
    {
        return $this->RateQualifier;
    }
    /**
     * Set RateQualifier value
     * @param string $rateQualifier
     * @return \StructType\RateQualifier
     */
    public function setRateQualifier($rateQualifier = null)
    {
        // validation for constraint: string
        if (!is_null($rateQualifier) && !is_string($rateQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateQualifier, true), gettype($rateQualifier)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($rateQualifier) && mb_strlen($rateQualifier) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($rateQualifier)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($rateQualifier) && mb_strlen($rateQualifier) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($rateQualifier)), __LINE__);
        }
        $this->RateQualifier = $rateQualifier;
        return $this;
    }
    /**
     * Get RatePeriod value
     * @return string|null
     */
    public function getRatePeriod()
    {
        return $this->RatePeriod;
    }
    /**
     * Set RatePeriod value
     * @param string $ratePeriod
     * @return \StructType\RateQualifier
     */
    public function setRatePeriod($ratePeriod = null)
    {
        // validation for constraint: string
        if (!is_null($ratePeriod) && !is_string($ratePeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePeriod, true), gettype($ratePeriod)), __LINE__);
        }
        $this->RatePeriod = $ratePeriod;
        return $this;
    }
    /**
     * Get GuaranteedInd value
     * @return bool|null
     */
    public function getGuaranteedInd()
    {
        return $this->GuaranteedInd;
    }
    /**
     * Set GuaranteedInd value
     * @param bool $guaranteedInd
     * @return \StructType\RateQualifier
     */
    public function setGuaranteedInd($guaranteedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteedInd) && !is_bool($guaranteedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($guaranteedInd, true), gettype($guaranteedInd)), __LINE__);
        }
        $this->GuaranteedInd = $guaranteedInd;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\RateQualifier
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($promotionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get PromotionVendorCode value
     * @return string[]|null
     */
    public function getPromotionVendorCode()
    {
        return $this->PromotionVendorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotionVendorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotionVendorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rateQualifierPromotionVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($rateQualifierPromotionVendorCodeItem)) {
                $invalidValues[] = is_object($rateQualifierPromotionVendorCodeItem) ? get_class($rateQualifierPromotionVendorCodeItem) : sprintf('%s(%s)', gettype($rateQualifierPromotionVendorCodeItem), var_export($rateQualifierPromotionVendorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PromotionVendorCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PromotionVendorCode value
     * @param string[] $promotionVendorCode
     * @return \StructType\RateQualifier
     */
    public function setPromotionVendorCode(array $promotionVendorCode = array())
    {
        // validation for constraint: list
        if ('' !== ($promotionVendorCodeArrayErrorMessage = self::validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode($promotionVendorCode))) {
            throw new \InvalidArgumentException($promotionVendorCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($promotionVendorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionVendorCode)), __LINE__);
        }
        $this->PromotionVendorCode = is_array($promotionVendorCode) ? implode(' ', $promotionVendorCode) : null;
        return $this;
    }
    /**
     * Get TourInfoRPH value
     * @return string|null
     */
    public function getTourInfoRPH()
    {
        return $this->TourInfoRPH;
    }
    /**
     * Set TourInfoRPH value
     * @param string $tourInfoRPH
     * @return \StructType\RateQualifier
     */
    public function setTourInfoRPH($tourInfoRPH = null)
    {
        // validation for constraint: string
        if (!is_null($tourInfoRPH) && !is_string($tourInfoRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourInfoRPH, true), gettype($tourInfoRPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($tourInfoRPH) && !preg_match('/[0-9]{1,8}/', $tourInfoRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($tourInfoRPH, true)), __LINE__);
        }
        $this->TourInfoRPH = $tourInfoRPH;
        return $this;
    }
    /**
     * Get CustLoyaltyRPH value
     * @return string[]|null
     */
    public function getCustLoyaltyRPH()
    {
        return $this->CustLoyaltyRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setCustLoyaltyRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustLoyaltyRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustLoyaltyRPHForArrayConstraintsFromSetCustLoyaltyRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rateQualifierCustLoyaltyRPHItem) {
            // validation for constraint: itemType
            if (!is_string($rateQualifierCustLoyaltyRPHItem)) {
                $invalidValues[] = is_object($rateQualifierCustLoyaltyRPHItem) ? get_class($rateQualifierCustLoyaltyRPHItem) : sprintf('%s(%s)', gettype($rateQualifierCustLoyaltyRPHItem), var_export($rateQualifierCustLoyaltyRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustLoyaltyRPH property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustLoyaltyRPH value
     * @param string[] $custLoyaltyRPH
     * @return \StructType\RateQualifier
     */
    public function setCustLoyaltyRPH(array $custLoyaltyRPH = array())
    {
        // validation for constraint: list
        if ('' !== ($custLoyaltyRPHArrayErrorMessage = self::validateCustLoyaltyRPHForArrayConstraintsFromSetCustLoyaltyRPH($custLoyaltyRPH))) {
            throw new \InvalidArgumentException($custLoyaltyRPHArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($custLoyaltyRPH) && !preg_match('/[0-9]{1,8}/', $custLoyaltyRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($custLoyaltyRPH, true)), __LINE__);
        }
        $this->CustLoyaltyRPH = is_array($custLoyaltyRPH) ? implode(' ', $custLoyaltyRPH) : null;
        return $this;
    }
    /**
     * Get QuoteID value
     * @return string|null
     */
    public function getQuoteID()
    {
        return $this->QuoteID;
    }
    /**
     * Set QuoteID value
     * @param string $quoteID
     * @return \StructType\RateQualifier
     */
    public function setQuoteID($quoteID = null)
    {
        // validation for constraint: string
        if (!is_null($quoteID) && !is_string($quoteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quoteID, true), gettype($quoteID)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($quoteID) && mb_strlen($quoteID) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($quoteID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($quoteID) && mb_strlen($quoteID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($quoteID)), __LINE__);
        }
        $this->QuoteID = $quoteID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateQualifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
