<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Radius StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to provide distance and direction information from the referenced location. | Used to specify the extent of a search area. The extent is relative to an element (position, address, hotel reference, etc.) present in this
 * ItemSearchCriterionType that specifies a location.
 * @subpackage Structs
 */
class Radius extends AbstractStructBase
{
    /**
     * The Distance
     * Meta information extracted from the WSDL
     * - documentation: An optional attribute indicating the distance to/from a reference point. When used in conjunction with DistanceMax, this represents the minimum distance. | Used for Numeric Strings, length 1 to 16.
     * - base: xs:string
     * - pattern: [0-9]{1,16}
     * - type: NumericStringLength1to16
     * - use: optional
     * @var string
     */
    public $Distance;
    /**
     * The DistanceMeasure
     * Meta information extracted from the WSDL
     * - documentation: When the Distance attribute contains a value, (presumably a numerical value), the unit of measure is a string value that indicate what units are used for the value. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $DistanceMeasure;
    /**
     * The Direction
     * Meta information extracted from the WSDL
     * - documentation: An optional string value used to indicate the compass point(s) direction, e.g.: S, SE (South, Southeast), FROM the Reference Point TO the hotel location if the search is not a full circumference from the reference point. | Used for
     * Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $Direction;
    /**
     * The DistanceMax
     * Meta information extracted from the WSDL
     * - documentation: An optional attribute indicating the maximum distance to/from a reference point. | Used for Numeric Strings, length 1 to 16.
     * - base: xs:string
     * - pattern: [0-9]{1,16}
     * - type: NumericStringLength1to16
     * - use: optional
     * @var string
     */
    public $DistanceMax;
    /**
     * The UnitOfMeasureCode
     * Meta information extracted from the WSDL
     * - documentation: The unit of measure in a code format. Refer to OpenTravel Code List Unit of Measure Code (UOM). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $UnitOfMeasureCode;
    /**
     * Constructor method for Radius
     * @uses Radius::setDistance()
     * @uses Radius::setDistanceMeasure()
     * @uses Radius::setDirection()
     * @uses Radius::setDistanceMax()
     * @uses Radius::setUnitOfMeasureCode()
     * @param string $distance
     * @param string $distanceMeasure
     * @param string $direction
     * @param string $distanceMax
     * @param string $unitOfMeasureCode
     */
    public function __construct($distance = null, $distanceMeasure = null, $direction = null, $distanceMax = null, $unitOfMeasureCode = null)
    {
        $this
            ->setDistance($distance)
            ->setDistanceMeasure($distanceMeasure)
            ->setDirection($direction)
            ->setDistanceMax($distanceMax)
            ->setUnitOfMeasureCode($unitOfMeasureCode);
    }
    /**
     * Get Distance value
     * @return string|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param string $distance
     * @return \StructType\Radius
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: string
        if (!is_null($distance) && !is_string($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,16})
        if (!is_null($distance) && !preg_match('/[0-9]{1,16}/', $distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,16}', var_export($distance, true)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get DistanceMeasure value
     * @return string|null
     */
    public function getDistanceMeasure()
    {
        return $this->DistanceMeasure;
    }
    /**
     * Set DistanceMeasure value
     * @param string $distanceMeasure
     * @return \StructType\Radius
     */
    public function setDistanceMeasure($distanceMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($distanceMeasure) && !is_string($distanceMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceMeasure, true), gettype($distanceMeasure)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($distanceMeasure) && mb_strlen($distanceMeasure) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($distanceMeasure)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($distanceMeasure) && mb_strlen($distanceMeasure) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($distanceMeasure)), __LINE__);
        }
        $this->DistanceMeasure = $distanceMeasure;
        return $this;
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param string $direction
     * @return \StructType\Radius
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: string
        if (!is_null($direction) && !is_string($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($direction, true), gettype($direction)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($direction) && mb_strlen($direction) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($direction)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($direction) && mb_strlen($direction) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($direction)), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get DistanceMax value
     * @return string|null
     */
    public function getDistanceMax()
    {
        return $this->DistanceMax;
    }
    /**
     * Set DistanceMax value
     * @param string $distanceMax
     * @return \StructType\Radius
     */
    public function setDistanceMax($distanceMax = null)
    {
        // validation for constraint: string
        if (!is_null($distanceMax) && !is_string($distanceMax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceMax, true), gettype($distanceMax)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,16})
        if (!is_null($distanceMax) && !preg_match('/[0-9]{1,16}/', $distanceMax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,16}', var_export($distanceMax, true)), __LINE__);
        }
        $this->DistanceMax = $distanceMax;
        return $this;
    }
    /**
     * Get UnitOfMeasureCode value
     * @return string|null
     */
    public function getUnitOfMeasureCode()
    {
        return $this->UnitOfMeasureCode;
    }
    /**
     * Set UnitOfMeasureCode value
     * @param string $unitOfMeasureCode
     * @return \StructType\Radius
     */
    public function setUnitOfMeasureCode($unitOfMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasureCode) && !is_string($unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasureCode, true), gettype($unitOfMeasureCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($unitOfMeasureCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($unitOfMeasureCode, true)), __LINE__);
        }
        $this->UnitOfMeasureCode = $unitOfMeasureCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Radius
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
