<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFP_ResponseDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is used to send information regarding when and how the detailed response will be delivered. | Provides an area to send comments regarding the response.
 * @subpackage Structs
 */
class RFP_ResponseDetailType extends AbstractStructBase
{
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Comments
     */
    public $Comments;
    /**
     * The DetailIncludedIndicator
     * Meta information extracted from the WSDL
     * - documentation: This is an indicator that denotes whether the message contains detailed information; if false this indicates the message is an acknowledgement only, if true this indicates that detailed information is included in this message.
     * - use: optional
     * @var bool
     */
    public $DetailIncludedIndicator;
    /**
     * The DeclineIndicator
     * Meta information extracted from the WSDL
     * - documentation: If true, the supplier cannot accomodate the request and will not send detailed response information. If false, the supplier plans to respond.
     * - use: optional
     * @var bool
     */
    public $DeclineIndicator;
    /**
     * The DeclineReasonCode
     * Meta information extracted from the WSDL
     * - documentation: Identifies the reason the request is being declined. Refer to OpenTravel Code List Decline Reason (DEC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $DeclineReasonCode;
    /**
     * The CodeDetail
     * Meta information extracted from the WSDL
     * - documentation: This is intended for use as a customized DeclineReasonCode. This may be used when "other" is stated as the DeclineReasonCode or to give additional information with other DeclineReasonCodes. | Used for Character Strings, length 1 to
     * 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $CodeDetail;
    /**
     * The MinimumTime
     * Meta information extracted from the WSDL
     * - documentation: Specifies the earliest time within which the detailed response will be communicated. Used in conjunction with MaximumTime to define a range (e.g. the 2 in "2-4 days").
     * - type: xs:duration
     * - use: optional
     * @var string
     */
    public $MinimumTime;
    /**
     * The MaximumTime
     * Meta information extracted from the WSDL
     * - documentation: Specifies the latest time the detailed response will be communicated. Used in conjunction with MinimumTime to define a range (e.g. the 4 in "2-4 days").
     * - type: xs:duration
     * - use: optional
     * @var string
     */
    public $MaximumTime;
    /**
     * The ResponseMethod
     * Meta information extracted from the WSDL
     * - documentation: Specifies how the detailed response will be communicated (e.g. XML, e-mail, phone call). Refer to OpenTravel Code List Distribution Type (DTB). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1,
     * 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $ResponseMethod;
    /**
     * The ResponseTimeUnit
     * @var string
     */
    public $ResponseTimeUnit;
    /**
     * Constructor method for RFP_ResponseDetailType
     * @uses RFP_ResponseDetailType::setComments()
     * @uses RFP_ResponseDetailType::setDetailIncludedIndicator()
     * @uses RFP_ResponseDetailType::setDeclineIndicator()
     * @uses RFP_ResponseDetailType::setDeclineReasonCode()
     * @uses RFP_ResponseDetailType::setCodeDetail()
     * @uses RFP_ResponseDetailType::setMinimumTime()
     * @uses RFP_ResponseDetailType::setMaximumTime()
     * @uses RFP_ResponseDetailType::setResponseMethod()
     * @uses RFP_ResponseDetailType::setResponseTimeUnit()
     * @param \StructType\Comments $comments
     * @param bool $detailIncludedIndicator
     * @param bool $declineIndicator
     * @param string $declineReasonCode
     * @param string $codeDetail
     * @param string $minimumTime
     * @param string $maximumTime
     * @param string $responseMethod
     * @param string $responseTimeUnit
     */
    public function __construct(\StructType\Comments $comments = null, $detailIncludedIndicator = null, $declineIndicator = null, $declineReasonCode = null, $codeDetail = null, $minimumTime = null, $maximumTime = null, $responseMethod = null, $responseTimeUnit = null)
    {
        $this
            ->setComments($comments)
            ->setDetailIncludedIndicator($detailIncludedIndicator)
            ->setDeclineIndicator($declineIndicator)
            ->setDeclineReasonCode($declineReasonCode)
            ->setCodeDetail($codeDetail)
            ->setMinimumTime($minimumTime)
            ->setMaximumTime($maximumTime)
            ->setResponseMethod($responseMethod)
            ->setResponseTimeUnit($responseTimeUnit);
    }
    /**
     * Get Comments value
     * @return \StructType\Comments|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \StructType\Comments $comments
     * @return \StructType\RFP_ResponseDetailType
     */
    public function setComments(\StructType\Comments $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get DetailIncludedIndicator value
     * @return bool|null
     */
    public function getDetailIncludedIndicator()
    {
        return $this->DetailIncludedIndicator;
    }
    /**
     * Set DetailIncludedIndicator value
     * @param bool $detailIncludedIndicator
     * @return \StructType\RFP_ResponseDetailType
     */
    public function setDetailIncludedIndicator($detailIncludedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($detailIncludedIndicator) && !is_bool($detailIncludedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($detailIncludedIndicator, true), gettype($detailIncludedIndicator)), __LINE__);
        }
        $this->DetailIncludedIndicator = $detailIncludedIndicator;
        return $this;
    }
    /**
     * Get DeclineIndicator value
     * @return bool|null
     */
    public function getDeclineIndicator()
    {
        return $this->DeclineIndicator;
    }
    /**
     * Set DeclineIndicator value
     * @param bool $declineIndicator
     * @return \StructType\RFP_ResponseDetailType
     */
    public function setDeclineIndicator($declineIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($declineIndicator) && !is_bool($declineIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($declineIndicator, true), gettype($declineIndicator)), __LINE__);
        }
        $this->DeclineIndicator = $declineIndicator;
        return $this;
    }
    /**
     * Get DeclineReasonCode value
     * @return string|null
     */
    public function getDeclineReasonCode()
    {
        return $this->DeclineReasonCode;
    }
    /**
     * Set DeclineReasonCode value
     * @param string $declineReasonCode
     * @return \StructType\RFP_ResponseDetailType
     */
    public function setDeclineReasonCode($declineReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($declineReasonCode) && !is_string($declineReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declineReasonCode, true), gettype($declineReasonCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($declineReasonCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $declineReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($declineReasonCode, true)), __LINE__);
        }
        $this->DeclineReasonCode = $declineReasonCode;
        return $this;
    }
    /**
     * Get CodeDetail value
     * @return string|null
     */
    public function getCodeDetail()
    {
        return $this->CodeDetail;
    }
    /**
     * Set CodeDetail value
     * @param string $codeDetail
     * @return \StructType\RFP_ResponseDetailType
     */
    public function setCodeDetail($codeDetail = null)
    {
        // validation for constraint: string
        if (!is_null($codeDetail) && !is_string($codeDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeDetail, true), gettype($codeDetail)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($codeDetail) && mb_strlen($codeDetail) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($codeDetail)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($codeDetail) && mb_strlen($codeDetail) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($codeDetail)), __LINE__);
        }
        $this->CodeDetail = $codeDetail;
        return $this;
    }
    /**
     * Get MinimumTime value
     * @return string|null
     */
    public function getMinimumTime()
    {
        return $this->MinimumTime;
    }
    /**
     * Set MinimumTime value
     * @param string $minimumTime
     * @return \StructType\RFP_ResponseDetailType
     */
    public function setMinimumTime($minimumTime = null)
    {
        // validation for constraint: string
        if (!is_null($minimumTime) && !is_string($minimumTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumTime, true), gettype($minimumTime)), __LINE__);
        }
        $this->MinimumTime = $minimumTime;
        return $this;
    }
    /**
     * Get MaximumTime value
     * @return string|null
     */
    public function getMaximumTime()
    {
        return $this->MaximumTime;
    }
    /**
     * Set MaximumTime value
     * @param string $maximumTime
     * @return \StructType\RFP_ResponseDetailType
     */
    public function setMaximumTime($maximumTime = null)
    {
        // validation for constraint: string
        if (!is_null($maximumTime) && !is_string($maximumTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumTime, true), gettype($maximumTime)), __LINE__);
        }
        $this->MaximumTime = $maximumTime;
        return $this;
    }
    /**
     * Get ResponseMethod value
     * @return string|null
     */
    public function getResponseMethod()
    {
        return $this->ResponseMethod;
    }
    /**
     * Set ResponseMethod value
     * @param string $responseMethod
     * @return \StructType\RFP_ResponseDetailType
     */
    public function setResponseMethod($responseMethod = null)
    {
        // validation for constraint: string
        if (!is_null($responseMethod) && !is_string($responseMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseMethod, true), gettype($responseMethod)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($responseMethod) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $responseMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($responseMethod, true)), __LINE__);
        }
        $this->ResponseMethod = $responseMethod;
        return $this;
    }
    /**
     * Get ResponseTimeUnit value
     * @return string|null
     */
    public function getResponseTimeUnit()
    {
        return $this->ResponseTimeUnit;
    }
    /**
     * Set ResponseTimeUnit value
     * @param string $responseTimeUnit
     * @return \StructType\RFP_ResponseDetailType
     */
    public function setResponseTimeUnit($responseTimeUnit = null)
    {
        // validation for constraint: string
        if (!is_null($responseTimeUnit) && !is_string($responseTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseTimeUnit, true), gettype($responseTimeUnit)), __LINE__);
        }
        $this->ResponseTimeUnit = $responseTimeUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RFP_ResponseDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
