<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Queue StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies queue information for this booking. | Information to identify a queue. | Information to specify the queue on which the reservation should be placed.
 * @subpackage Structs
 */
class Queue extends AbstractStructBase
{
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - documentation: Date/time when the time initiated queuing should take place. | A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $DateTime;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: Text describing why the queuing takes place. | Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Text;
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - documentation: Identifies airline/system on which the reservation is being queued. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $CarrierCode;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * The PseudoCityCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The QueueNumber
     * Meta information extracted from the WSDL
     * - documentation: Used for Alpha-Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,8}
     * @var string
     */
    public $QueueNumber;
    /**
     * The QueueCategory
     * Meta information extracted from the WSDL
     * - documentation: Used for Alpha-Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,8}
     * @var string
     */
    public $QueueCategory;
    /**
     * The SystemCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $SystemCode;
    /**
     * The QueueID
     * Meta information extracted from the WSDL
     * - documentation: Used for Alpha-Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,8}
     * @var string
     */
    public $QueueID;
    /**
     * Constructor method for Queue
     * @uses Queue::setDateTime()
     * @uses Queue::setText()
     * @uses Queue::setCarrierCode()
     * @uses Queue::setOperation()
     * @uses Queue::setPseudoCityCode()
     * @uses Queue::setQueueNumber()
     * @uses Queue::setQueueCategory()
     * @uses Queue::setSystemCode()
     * @uses Queue::setQueueID()
     * @param string $dateTime
     * @param string $text
     * @param string $carrierCode
     * @param string $operation
     * @param string $pseudoCityCode
     * @param string $queueNumber
     * @param string $queueCategory
     * @param string $systemCode
     * @param string $queueID
     */
    public function __construct($dateTime = null, $text = null, $carrierCode = null, $operation = null, $pseudoCityCode = null, $queueNumber = null, $queueCategory = null, $systemCode = null, $queueID = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setText($text)
            ->setCarrierCode($carrierCode)
            ->setOperation($operation)
            ->setPseudoCityCode($pseudoCityCode)
            ->setQueueNumber($queueNumber)
            ->setQueueCategory($queueCategory)
            ->setSystemCode($systemCode)
            ->setQueueID($queueID);
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * This method is responsible for validating the value passed to the setDateTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateTime method
     * This is a set of validation rules based on the union types associated to the property being set by the setDateTime method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateTimeForUnionConstraintsFromSetDateTime($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\Queue
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($dateTimeUnionErrorMessage = self::validateDateTimeForUnionConstraintsFromSetDateTime($dateTime))) {
            throw new \InvalidArgumentException($dateTimeUnionErrorMessage, __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\Queue
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($text) && mb_strlen($text) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($text)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($text) && mb_strlen($text) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\Queue
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierCode, true), gettype($carrierCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($carrierCode) && mb_strlen($carrierCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($carrierCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($carrierCode) && mb_strlen($carrierCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\Queue
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \StructType\Queue
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($pseudoCityCode) && !is_string($pseudoCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pseudoCityCode, true), gettype($pseudoCityCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($pseudoCityCode) && mb_strlen($pseudoCityCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($pseudoCityCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pseudoCityCode) && mb_strlen($pseudoCityCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pseudoCityCode)), __LINE__);
        }
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get QueueNumber value
     * @return string|null
     */
    public function getQueueNumber()
    {
        return $this->QueueNumber;
    }
    /**
     * Set QueueNumber value
     * @param string $queueNumber
     * @return \StructType\Queue
     */
    public function setQueueNumber($queueNumber = null)
    {
        // validation for constraint: string
        if (!is_null($queueNumber) && !is_string($queueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queueNumber, true), gettype($queueNumber)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,8})
        if (!is_null($queueNumber) && !preg_match('/[0-9a-zA-Z]{1,8}/', $queueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,8}', var_export($queueNumber, true)), __LINE__);
        }
        $this->QueueNumber = $queueNumber;
        return $this;
    }
    /**
     * Get QueueCategory value
     * @return string|null
     */
    public function getQueueCategory()
    {
        return $this->QueueCategory;
    }
    /**
     * Set QueueCategory value
     * @param string $queueCategory
     * @return \StructType\Queue
     */
    public function setQueueCategory($queueCategory = null)
    {
        // validation for constraint: string
        if (!is_null($queueCategory) && !is_string($queueCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queueCategory, true), gettype($queueCategory)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,8})
        if (!is_null($queueCategory) && !preg_match('/[0-9a-zA-Z]{1,8}/', $queueCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,8}', var_export($queueCategory, true)), __LINE__);
        }
        $this->QueueCategory = $queueCategory;
        return $this;
    }
    /**
     * Get SystemCode value
     * @return string|null
     */
    public function getSystemCode()
    {
        return $this->SystemCode;
    }
    /**
     * Set SystemCode value
     * @param string $systemCode
     * @return \StructType\Queue
     */
    public function setSystemCode($systemCode = null)
    {
        // validation for constraint: string
        if (!is_null($systemCode) && !is_string($systemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemCode, true), gettype($systemCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($systemCode) && mb_strlen($systemCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($systemCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($systemCode) && mb_strlen($systemCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($systemCode)), __LINE__);
        }
        $this->SystemCode = $systemCode;
        return $this;
    }
    /**
     * Get QueueID value
     * @return string|null
     */
    public function getQueueID()
    {
        return $this->QueueID;
    }
    /**
     * Set QueueID value
     * @param string $queueID
     * @return \StructType\Queue
     */
    public function setQueueID($queueID = null)
    {
        // validation for constraint: string
        if (!is_null($queueID) && !is_string($queueID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queueID, true), gettype($queueID)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,8})
        if (!is_null($queueID) && !preg_match('/[0-9a-zA-Z]{1,8}/', $queueID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,8}', var_export($queueID, true)), __LINE__);
        }
        $this->QueueID = $queueID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Queue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
