<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileTypes StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of profile types.
 * @subpackage Structs
 */
class ProfileTypes extends AbstractStructBase
{
    /**
     * The ProfileType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProfileType[]
     */
    public $ProfileType;
    /**
     * Constructor method for ProfileTypes
     * @uses ProfileTypes::setProfileType()
     * @param \StructType\ProfileType[] $profileType
     */
    public function __construct(array $profileType = array())
    {
        $this
            ->setProfileType($profileType);
    }
    /**
     * Get ProfileType value
     * @return \StructType\ProfileType[]|null
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * This method is responsible for validating the values passed to the setProfileType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfileType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProfileTypeForArrayConstraintsFromSetProfileType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $profileTypesProfileTypeItem) {
            // validation for constraint: itemType
            if (!$profileTypesProfileTypeItem instanceof \StructType\ProfileType) {
                $invalidValues[] = is_object($profileTypesProfileTypeItem) ? get_class($profileTypesProfileTypeItem) : sprintf('%s(%s)', gettype($profileTypesProfileTypeItem), var_export($profileTypesProfileTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProfileType property can only contain items of type \StructType\ProfileType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProfileType value
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileType[] $profileType
     * @return \StructType\ProfileTypes
     */
    public function setProfileType(array $profileType = array())
    {
        // validation for constraint: array
        if ('' !== ($profileTypeArrayErrorMessage = self::validateProfileTypeForArrayConstraintsFromSetProfileType($profileType))) {
            throw new \InvalidArgumentException($profileTypeArrayErrorMessage, __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
    /**
     * Add item to ProfileType value
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileType $item
     * @return \StructType\ProfileTypes
     */
    public function addToProfileType(\StructType\ProfileType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProfileType) {
            throw new \InvalidArgumentException(sprintf('The ProfileType property can only contain items of type \StructType\ProfileType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProfileType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfileTypes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
