<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingUnit StructType
 * Meta information extracted from the WSDL
 * - documentation: A pricing unit for a passenger type code.
 * @subpackage Structs
 */
class PricingUnit extends AbstractStructBase
{
    /**
     * The UnitNumber
     * Meta information extracted from the WSDL
     * - documentation: A sequential number that identifies this pricing unit. | Used for Numeric values, from 1 to 99 inclusive.
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 1
     * - use: required
     * @var int
     */
    public $UnitNumber;
    /**
     * The FareComponent
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\FareComponent[]
     */
    public $FareComponent;
    /**
     * Constructor method for PricingUnit
     * @uses PricingUnit::setUnitNumber()
     * @uses PricingUnit::setFareComponent()
     * @param int $unitNumber
     * @param \StructType\FareComponent[] $fareComponent
     */
    public function __construct($unitNumber = null, array $fareComponent = array())
    {
        $this
            ->setUnitNumber($unitNumber)
            ->setFareComponent($fareComponent);
    }
    /**
     * Get UnitNumber value
     * @return int
     */
    public function getUnitNumber()
    {
        return $this->UnitNumber;
    }
    /**
     * Set UnitNumber value
     * @param int $unitNumber
     * @return \StructType\PricingUnit
     */
    public function setUnitNumber($unitNumber = null)
    {
        // validation for constraint: int
        if (!is_null($unitNumber) && !(is_int($unitNumber) || ctype_digit($unitNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unitNumber, true), gettype($unitNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($unitNumber) && $unitNumber > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($unitNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($unitNumber) && $unitNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($unitNumber, true)), __LINE__);
        }
        $this->UnitNumber = $unitNumber;
        return $this;
    }
    /**
     * Get FareComponent value
     * @return \StructType\FareComponent[]|null
     */
    public function getFareComponent()
    {
        return $this->FareComponent;
    }
    /**
     * This method is responsible for validating the values passed to the setFareComponent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareComponent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareComponentForArrayConstraintsFromSetFareComponent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingUnitFareComponentItem) {
            // validation for constraint: itemType
            if (!$pricingUnitFareComponentItem instanceof \StructType\FareComponent) {
                $invalidValues[] = is_object($pricingUnitFareComponentItem) ? get_class($pricingUnitFareComponentItem) : sprintf('%s(%s)', gettype($pricingUnitFareComponentItem), var_export($pricingUnitFareComponentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareComponent property can only contain items of type \StructType\FareComponent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\FareComponent[] $fareComponent
     * @return \StructType\PricingUnit
     */
    public function setFareComponent(array $fareComponent = array())
    {
        // validation for constraint: array
        if ('' !== ($fareComponentArrayErrorMessage = self::validateFareComponentForArrayConstraintsFromSetFareComponent($fareComponent))) {
            throw new \InvalidArgumentException($fareComponentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($fareComponent) && count($fareComponent) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($fareComponent)), __LINE__);
        }
        $this->FareComponent = $fareComponent;
        return $this;
    }
    /**
     * Add item to FareComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\FareComponent $item
     * @return \StructType\PricingUnit
     */
    public function addToFareComponent(\StructType\FareComponent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareComponent) {
            throw new \InvalidArgumentException(sprintf('The FareComponent property can only contain items of type \StructType\FareComponent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->FareComponent) && count($this->FareComponent) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->FareComponent)), __LINE__);
        }
        $this->FareComponent[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PricingUnit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
