<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingOverview StructType
 * Meta information extracted from the WSDL
 * - documentation: Information applicable to the pricing of the reservation.
 * @subpackage Structs
 */
class PricingOverview extends AbstractStructBase
{
    /**
     * The PricingIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\PricingIndicator[]
     */
    public $PricingIndicator;
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Account[]
     */
    public $Account;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: A comment applicable to all the pricing information.
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\FreeTextType[]
     */
    public $Comment;
    /**
     * The StatisticalCode
     * Meta information extracted from the WSDL
     * - documentation: Used for domestic or international sales differentiation. | Used for Alpha-Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,8}
     * - use: optional
     * @var string
     */
    public $StatisticalCode;
    /**
     * The ValidatingAirlineCode
     * Meta information extracted from the WSDL
     * - documentation: The validating airline code for the ticketing. | Used for Alpha-Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,8}
     * - use: optional
     * @var string
     */
    public $ValidatingAirlineCode;
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - documentation: The departure date of the first leg of the booked itinerary. | A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $DepartureDate;
    /**
     * The PriceType
     * Meta information extracted from the WSDL
     * - documentation: Used to specify the type of price. | Used for Alpha-Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,8}
     * - use: optional
     * @var string
     */
    public $PriceType;
    /**
     * The NUC_Rate
     * Meta information extracted from the WSDL
     * - documentation: The neutral unit currency rate.
     * - use: optional
     * @var float
     */
    public $NUC_Rate;
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - documentation: The currency exchange rate.
     * - use: optional
     * @var float
     */
    public $ExchangeRate;
    /**
     * Constructor method for PricingOverview
     * @uses PricingOverview::setPricingIndicator()
     * @uses PricingOverview::setAccount()
     * @uses PricingOverview::setComment()
     * @uses PricingOverview::setStatisticalCode()
     * @uses PricingOverview::setValidatingAirlineCode()
     * @uses PricingOverview::setDepartureDate()
     * @uses PricingOverview::setPriceType()
     * @uses PricingOverview::setNUC_Rate()
     * @uses PricingOverview::setExchangeRate()
     * @param \StructType\PricingIndicator[] $pricingIndicator
     * @param \StructType\Account[] $account
     * @param \StructType\FreeTextType[] $comment
     * @param string $statisticalCode
     * @param string $validatingAirlineCode
     * @param string $departureDate
     * @param string $priceType
     * @param float $nUC_Rate
     * @param float $exchangeRate
     */
    public function __construct(array $pricingIndicator = array(), array $account = array(), array $comment = array(), $statisticalCode = null, $validatingAirlineCode = null, $departureDate = null, $priceType = null, $nUC_Rate = null, $exchangeRate = null)
    {
        $this
            ->setPricingIndicator($pricingIndicator)
            ->setAccount($account)
            ->setComment($comment)
            ->setStatisticalCode($statisticalCode)
            ->setValidatingAirlineCode($validatingAirlineCode)
            ->setDepartureDate($departureDate)
            ->setPriceType($priceType)
            ->setNUC_Rate($nUC_Rate)
            ->setExchangeRate($exchangeRate);
    }
    /**
     * Get PricingIndicator value
     * @return \StructType\PricingIndicator[]|null
     */
    public function getPricingIndicator()
    {
        return $this->PricingIndicator;
    }
    /**
     * This method is responsible for validating the values passed to the setPricingIndicator method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricingIndicator method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricingIndicatorForArrayConstraintsFromSetPricingIndicator(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingOverviewPricingIndicatorItem) {
            // validation for constraint: itemType
            if (!$pricingOverviewPricingIndicatorItem instanceof \StructType\PricingIndicator) {
                $invalidValues[] = is_object($pricingOverviewPricingIndicatorItem) ? get_class($pricingOverviewPricingIndicatorItem) : sprintf('%s(%s)', gettype($pricingOverviewPricingIndicatorItem), var_export($pricingOverviewPricingIndicatorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PricingIndicator property can only contain items of type \StructType\PricingIndicator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PricingIndicator value
     * @throws \InvalidArgumentException
     * @param \StructType\PricingIndicator[] $pricingIndicator
     * @return \StructType\PricingOverview
     */
    public function setPricingIndicator(array $pricingIndicator = array())
    {
        // validation for constraint: array
        if ('' !== ($pricingIndicatorArrayErrorMessage = self::validatePricingIndicatorForArrayConstraintsFromSetPricingIndicator($pricingIndicator))) {
            throw new \InvalidArgumentException($pricingIndicatorArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($pricingIndicator) && count($pricingIndicator) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($pricingIndicator)), __LINE__);
        }
        $this->PricingIndicator = $pricingIndicator;
        return $this;
    }
    /**
     * Add item to PricingIndicator value
     * @throws \InvalidArgumentException
     * @param \StructType\PricingIndicator $item
     * @return \StructType\PricingOverview
     */
    public function addToPricingIndicator(\StructType\PricingIndicator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PricingIndicator) {
            throw new \InvalidArgumentException(sprintf('The PricingIndicator property can only contain items of type \StructType\PricingIndicator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->PricingIndicator) && count($this->PricingIndicator) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->PricingIndicator)), __LINE__);
        }
        $this->PricingIndicator[] = $item;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\Account[]|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * This method is responsible for validating the values passed to the setAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountForArrayConstraintsFromSetAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingOverviewAccountItem) {
            // validation for constraint: itemType
            if (!$pricingOverviewAccountItem instanceof \StructType\Account) {
                $invalidValues[] = is_object($pricingOverviewAccountItem) ? get_class($pricingOverviewAccountItem) : sprintf('%s(%s)', gettype($pricingOverviewAccountItem), var_export($pricingOverviewAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Account property can only contain items of type \StructType\Account, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Account value
     * @throws \InvalidArgumentException
     * @param \StructType\Account[] $account
     * @return \StructType\PricingOverview
     */
    public function setAccount(array $account = array())
    {
        // validation for constraint: array
        if ('' !== ($accountArrayErrorMessage = self::validateAccountForArrayConstraintsFromSetAccount($account))) {
            throw new \InvalidArgumentException($accountArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($account) && count($account) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($account)), __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Add item to Account value
     * @throws \InvalidArgumentException
     * @param \StructType\Account $item
     * @return \StructType\PricingOverview
     */
    public function addToAccount(\StructType\Account $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Account) {
            throw new \InvalidArgumentException(sprintf('The Account property can only contain items of type \StructType\Account, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Account) && count($this->Account) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Account)), __LINE__);
        }
        $this->Account[] = $item;
        return $this;
    }
    /**
     * Get Comment value
     * @return \StructType\FreeTextType[]|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * This method is responsible for validating the values passed to the setComment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommentForArrayConstraintsFromSetComment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingOverviewCommentItem) {
            // validation for constraint: itemType
            if (!$pricingOverviewCommentItem instanceof \StructType\FreeTextType) {
                $invalidValues[] = is_object($pricingOverviewCommentItem) ? get_class($pricingOverviewCommentItem) : sprintf('%s(%s)', gettype($pricingOverviewCommentItem), var_export($pricingOverviewCommentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Comment property can only contain items of type \StructType\FreeTextType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Comment value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType[] $comment
     * @return \StructType\PricingOverview
     */
    public function setComment(array $comment = array())
    {
        // validation for constraint: array
        if ('' !== ($commentArrayErrorMessage = self::validateCommentForArrayConstraintsFromSetComment($comment))) {
            throw new \InvalidArgumentException($commentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($comment) && count($comment) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Add item to Comment value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType $item
     * @return \StructType\PricingOverview
     */
    public function addToComment(\StructType\FreeTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FreeTextType) {
            throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of type \StructType\FreeTextType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->Comment) && count($this->Comment) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->Comment)), __LINE__);
        }
        $this->Comment[] = $item;
        return $this;
    }
    /**
     * Get StatisticalCode value
     * @return string|null
     */
    public function getStatisticalCode()
    {
        return $this->StatisticalCode;
    }
    /**
     * Set StatisticalCode value
     * @param string $statisticalCode
     * @return \StructType\PricingOverview
     */
    public function setStatisticalCode($statisticalCode = null)
    {
        // validation for constraint: string
        if (!is_null($statisticalCode) && !is_string($statisticalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statisticalCode, true), gettype($statisticalCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,8})
        if (!is_null($statisticalCode) && !preg_match('/[0-9a-zA-Z]{1,8}/', $statisticalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,8}', var_export($statisticalCode, true)), __LINE__);
        }
        $this->StatisticalCode = $statisticalCode;
        return $this;
    }
    /**
     * Get ValidatingAirlineCode value
     * @return string|null
     */
    public function getValidatingAirlineCode()
    {
        return $this->ValidatingAirlineCode;
    }
    /**
     * Set ValidatingAirlineCode value
     * @param string $validatingAirlineCode
     * @return \StructType\PricingOverview
     */
    public function setValidatingAirlineCode($validatingAirlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($validatingAirlineCode) && !is_string($validatingAirlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validatingAirlineCode, true), gettype($validatingAirlineCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,8})
        if (!is_null($validatingAirlineCode) && !preg_match('/[0-9a-zA-Z]{1,8}/', $validatingAirlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,8}', var_export($validatingAirlineCode, true)), __LINE__);
        }
        $this->ValidatingAirlineCode = $validatingAirlineCode;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * This method is responsible for validating the value passed to the setDepartureDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepartureDate method
     * This is a set of validation rules based on the union types associated to the property being set by the setDepartureDate method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepartureDateForUnionConstraintsFromSetDepartureDate($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\PricingOverview
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($departureDateUnionErrorMessage = self::validateDepartureDateForUnionConstraintsFromSetDepartureDate($departureDate))) {
            throw new \InvalidArgumentException($departureDateUnionErrorMessage, __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get PriceType value
     * @return string|null
     */
    public function getPriceType()
    {
        return $this->PriceType;
    }
    /**
     * Set PriceType value
     * @param string $priceType
     * @return \StructType\PricingOverview
     */
    public function setPriceType($priceType = null)
    {
        // validation for constraint: string
        if (!is_null($priceType) && !is_string($priceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceType, true), gettype($priceType)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,8})
        if (!is_null($priceType) && !preg_match('/[0-9a-zA-Z]{1,8}/', $priceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,8}', var_export($priceType, true)), __LINE__);
        }
        $this->PriceType = $priceType;
        return $this;
    }
    /**
     * Get NUC_Rate value
     * @return float|null
     */
    public function getNUC_Rate()
    {
        return $this->NUC_Rate;
    }
    /**
     * Set NUC_Rate value
     * @param float $nUC_Rate
     * @return \StructType\PricingOverview
     */
    public function setNUC_Rate($nUC_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($nUC_Rate) && !(is_float($nUC_Rate) || is_numeric($nUC_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nUC_Rate, true), gettype($nUC_Rate)), __LINE__);
        }
        $this->NUC_Rate = $nUC_Rate;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \StructType\PricingOverview
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PricingOverview
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
