<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedItineraryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Itinerary with pricing information.
 * @subpackage Structs
 */
class PricedItineraryType extends AbstractStructBase
{
    /**
     * The AirItinerary
     * Meta information extracted from the WSDL
     * - documentation: Specifies the origin and destination of the traveler. Attributes: DirectionInd - A directional indicator that identifies a type of air booking, either one-way, round-trip, or open-jaw with the enumeration of (OneWay | RT | OpenJaw)
     * respectively. ActionCode - Indicates the status of the booking, such as OK or Wait-List. NumberInParty - Indicates the traveler count.
     * - minOccurs: 0
     * @var \StructType\AirItineraryType
     */
    public $AirItinerary;
    /**
     * The AirItineraryPricingInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AirItineraryPricingInfo
     */
    public $AirItineraryPricingInfo;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - documentation: Provides for free form descriptive information for the priced itinerary.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\FreeTextType[]
     */
    public $Notes;
    /**
     * The TicketingInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TicketingInfo
     */
    public $TicketingInfo;
    /**
     * The SequenceNumber
     * Meta information extracted from the WSDL
     * - documentation: Assigns a number to priced itineraries.
     * - use: optional
     * @var int
     */
    public $SequenceNumber;
    /**
     * The PriceType
     * Meta information extracted from the WSDL
     * - documentation: Specifies how the pricing was done. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $PriceType;
    /**
     * The NUC_Rate
     * Meta information extracted from the WSDL
     * - documentation: The neutral unit currency rate.
     * - use: optional
     * @var float
     */
    public $NUC_Rate;
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - documentation: The currency exchange rate.
     * - use: optional
     * @var float
     */
    public $ExchangeRate;
    /**
     * Constructor method for PricedItineraryType
     * @uses PricedItineraryType::setAirItinerary()
     * @uses PricedItineraryType::setAirItineraryPricingInfo()
     * @uses PricedItineraryType::setNotes()
     * @uses PricedItineraryType::setTicketingInfo()
     * @uses PricedItineraryType::setSequenceNumber()
     * @uses PricedItineraryType::setPriceType()
     * @uses PricedItineraryType::setNUC_Rate()
     * @uses PricedItineraryType::setExchangeRate()
     * @param \StructType\AirItineraryType $airItinerary
     * @param \StructType\AirItineraryPricingInfo $airItineraryPricingInfo
     * @param \StructType\FreeTextType[] $notes
     * @param \StructType\TicketingInfo $ticketingInfo
     * @param int $sequenceNumber
     * @param string $priceType
     * @param float $nUC_Rate
     * @param float $exchangeRate
     */
    public function __construct(\StructType\AirItineraryType $airItinerary = null, \StructType\AirItineraryPricingInfo $airItineraryPricingInfo = null, array $notes = array(), \StructType\TicketingInfo $ticketingInfo = null, $sequenceNumber = null, $priceType = null, $nUC_Rate = null, $exchangeRate = null)
    {
        $this
            ->setAirItinerary($airItinerary)
            ->setAirItineraryPricingInfo($airItineraryPricingInfo)
            ->setNotes($notes)
            ->setTicketingInfo($ticketingInfo)
            ->setSequenceNumber($sequenceNumber)
            ->setPriceType($priceType)
            ->setNUC_Rate($nUC_Rate)
            ->setExchangeRate($exchangeRate);
    }
    /**
     * Get AirItinerary value
     * @return \StructType\AirItineraryType|null
     */
    public function getAirItinerary()
    {
        return $this->AirItinerary;
    }
    /**
     * Set AirItinerary value
     * @param \StructType\AirItineraryType $airItinerary
     * @return \StructType\PricedItineraryType
     */
    public function setAirItinerary(\StructType\AirItineraryType $airItinerary = null)
    {
        $this->AirItinerary = $airItinerary;
        return $this;
    }
    /**
     * Get AirItineraryPricingInfo value
     * @return \StructType\AirItineraryPricingInfo|null
     */
    public function getAirItineraryPricingInfo()
    {
        return $this->AirItineraryPricingInfo;
    }
    /**
     * Set AirItineraryPricingInfo value
     * @param \StructType\AirItineraryPricingInfo $airItineraryPricingInfo
     * @return \StructType\PricedItineraryType
     */
    public function setAirItineraryPricingInfo(\StructType\AirItineraryPricingInfo $airItineraryPricingInfo = null)
    {
        $this->AirItineraryPricingInfo = $airItineraryPricingInfo;
        return $this;
    }
    /**
     * Get Notes value
     * @return \StructType\FreeTextType[]|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * This method is responsible for validating the values passed to the setNotes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotesForArrayConstraintsFromSetNotes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricedItineraryTypeNotesItem) {
            // validation for constraint: itemType
            if (!$pricedItineraryTypeNotesItem instanceof \StructType\FreeTextType) {
                $invalidValues[] = is_object($pricedItineraryTypeNotesItem) ? get_class($pricedItineraryTypeNotesItem) : sprintf('%s(%s)', gettype($pricedItineraryTypeNotesItem), var_export($pricedItineraryTypeNotesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Notes property can only contain items of type \StructType\FreeTextType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Notes value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType[] $notes
     * @return \StructType\PricedItineraryType
     */
    public function setNotes(array $notes = array())
    {
        // validation for constraint: array
        if ('' !== ($notesArrayErrorMessage = self::validateNotesForArrayConstraintsFromSetNotes($notes))) {
            throw new \InvalidArgumentException($notesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($notes) && count($notes) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Add item to Notes value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType $item
     * @return \StructType\PricedItineraryType
     */
    public function addToNotes(\StructType\FreeTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FreeTextType) {
            throw new \InvalidArgumentException(sprintf('The Notes property can only contain items of type \StructType\FreeTextType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Notes) && count($this->Notes) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Notes)), __LINE__);
        }
        $this->Notes[] = $item;
        return $this;
    }
    /**
     * Get TicketingInfo value
     * @return \StructType\TicketingInfo|null
     */
    public function getTicketingInfo()
    {
        return $this->TicketingInfo;
    }
    /**
     * Set TicketingInfo value
     * @param \StructType\TicketingInfo $ticketingInfo
     * @return \StructType\PricedItineraryType
     */
    public function setTicketingInfo(\StructType\TicketingInfo $ticketingInfo = null)
    {
        $this->TicketingInfo = $ticketingInfo;
        return $this;
    }
    /**
     * Get SequenceNumber value
     * @return int|null
     */
    public function getSequenceNumber()
    {
        return $this->SequenceNumber;
    }
    /**
     * Set SequenceNumber value
     * @param int $sequenceNumber
     * @return \StructType\PricedItineraryType
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNumber) && !(is_int($sequenceNumber) || ctype_digit($sequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenceNumber, true), gettype($sequenceNumber)), __LINE__);
        }
        $this->SequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Get PriceType value
     * @return string|null
     */
    public function getPriceType()
    {
        return $this->PriceType;
    }
    /**
     * Set PriceType value
     * @param string $priceType
     * @return \StructType\PricedItineraryType
     */
    public function setPriceType($priceType = null)
    {
        // validation for constraint: string
        if (!is_null($priceType) && !is_string($priceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceType, true), gettype($priceType)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($priceType) && mb_strlen($priceType) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($priceType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($priceType) && mb_strlen($priceType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($priceType)), __LINE__);
        }
        $this->PriceType = $priceType;
        return $this;
    }
    /**
     * Get NUC_Rate value
     * @return float|null
     */
    public function getNUC_Rate()
    {
        return $this->NUC_Rate;
    }
    /**
     * Set NUC_Rate value
     * @param float $nUC_Rate
     * @return \StructType\PricedItineraryType
     */
    public function setNUC_Rate($nUC_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($nUC_Rate) && !(is_float($nUC_Rate) || is_numeric($nUC_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nUC_Rate, true), gettype($nUC_Rate)), __LINE__);
        }
        $this->NUC_Rate = $nUC_Rate;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \StructType\PricedItineraryType
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PricedItineraryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
