<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedEquip StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to indicate special equipment is returned.
 * @subpackage Structs
 */
class PricedEquip extends AbstractStructBase
{
    /**
     * The Equipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * @var \StructType\Equipment[]
     */
    public $Equipment;
    /**
     * The Charge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VehicleChargeType
     */
    public $Charge;
    /**
     * Constructor method for PricedEquip
     * @uses PricedEquip::setEquipment()
     * @uses PricedEquip::setCharge()
     * @param \StructType\Equipment[] $equipment
     * @param \StructType\VehicleChargeType $charge
     */
    public function __construct(array $equipment = array(), \StructType\VehicleChargeType $charge = null)
    {
        $this
            ->setEquipment($equipment)
            ->setCharge($charge);
    }
    /**
     * Get Equipment value
     * @return \StructType\Equipment[]|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * This method is responsible for validating the values passed to the setEquipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEquipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEquipmentForArrayConstraintsFromSetEquipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricedEquipEquipmentItem) {
            // validation for constraint: itemType
            if (!$pricedEquipEquipmentItem instanceof \StructType\Equipment) {
                $invalidValues[] = is_object($pricedEquipEquipmentItem) ? get_class($pricedEquipEquipmentItem) : sprintf('%s(%s)', gettype($pricedEquipEquipmentItem), var_export($pricedEquipEquipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Equipment property can only contain items of type \StructType\Equipment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Equipment value
     * @throws \InvalidArgumentException
     * @param \StructType\Equipment[] $equipment
     * @return \StructType\PricedEquip
     */
    public function setEquipment(array $equipment = array())
    {
        // validation for constraint: array
        if ('' !== ($equipmentArrayErrorMessage = self::validateEquipmentForArrayConstraintsFromSetEquipment($equipment))) {
            throw new \InvalidArgumentException($equipmentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($equipment) && count($equipment) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($equipment)), __LINE__);
        }
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Add item to Equipment value
     * @throws \InvalidArgumentException
     * @param \StructType\Equipment $item
     * @return \StructType\PricedEquip
     */
    public function addToEquipment(\StructType\Equipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Equipment) {
            throw new \InvalidArgumentException(sprintf('The Equipment property can only contain items of type \StructType\Equipment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->Equipment) && count($this->Equipment) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->Equipment)), __LINE__);
        }
        $this->Equipment[] = $item;
        return $this;
    }
    /**
     * Get Charge value
     * @return \StructType\VehicleChargeType|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @param \StructType\VehicleChargeType $charge
     * @return \StructType\PricedEquip
     */
    public function setCharge(\StructType\VehicleChargeType $charge = null)
    {
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PricedEquip
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
