<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Precipitation StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides average precipitation and the unit in which it is measured for a Period.
 * @subpackage Structs
 */
class Precipitation extends AbstractStructBase
{
    /**
     * The AveragePrecipitation
     * Meta information extracted from the WSDL
     * - documentation: Defines the average precipitation for the time as designated in Period and is qualified by the UnitOfMeasure.
     * - use: optional
     * @var float
     */
    public $AveragePrecipitation;
    /**
     * The UnitOfMeasure
     * Meta information extracted from the WSDL
     * - documentation: This is the unit of measure as it applies to AveragePercipitation (e.g.inches or centimeters). | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $UnitOfMeasure;
    /**
     * Constructor method for Precipitation
     * @uses Precipitation::setAveragePrecipitation()
     * @uses Precipitation::setUnitOfMeasure()
     * @param float $averagePrecipitation
     * @param string $unitOfMeasure
     */
    public function __construct($averagePrecipitation = null, $unitOfMeasure = null)
    {
        $this
            ->setAveragePrecipitation($averagePrecipitation)
            ->setUnitOfMeasure($unitOfMeasure);
    }
    /**
     * Get AveragePrecipitation value
     * @return float|null
     */
    public function getAveragePrecipitation()
    {
        return $this->AveragePrecipitation;
    }
    /**
     * Set AveragePrecipitation value
     * @param float $averagePrecipitation
     * @return \StructType\Precipitation
     */
    public function setAveragePrecipitation($averagePrecipitation = null)
    {
        // validation for constraint: float
        if (!is_null($averagePrecipitation) && !(is_float($averagePrecipitation) || is_numeric($averagePrecipitation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($averagePrecipitation, true), gettype($averagePrecipitation)), __LINE__);
        }
        $this->AveragePrecipitation = $averagePrecipitation;
        return $this;
    }
    /**
     * Get UnitOfMeasure value
     * @return string|null
     */
    public function getUnitOfMeasure()
    {
        return $this->UnitOfMeasure;
    }
    /**
     * Set UnitOfMeasure value
     * @param string $unitOfMeasure
     * @return \StructType\Precipitation
     */
    public function setUnitOfMeasure($unitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasure) && !is_string($unitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasure, true), gettype($unitOfMeasure)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($unitOfMeasure) && mb_strlen($unitOfMeasure) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($unitOfMeasure)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($unitOfMeasure) && mb_strlen($unitOfMeasure) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($unitOfMeasure)), __LINE__);
        }
        $this->UnitOfMeasure = $unitOfMeasure;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Precipitation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
