<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickUpLocation StructType
 * Meta information extracted from the WSDL
 * - documentation: A code to identify the pick up location, along with an optional code context.
 * @subpackage Structs
 */
class PickUpLocation extends LocationType
{
    /**
     * The _
     * @var \StructType\LocationType
     */
    public $_;
    /**
     * The ExtendedLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies a unique location code (e.g., ATLC10). | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ExtendedLocationCode;
    /**
     * The CounterLocation
     * Meta information extracted from the WSDL
     * - documentation: Identifies the location of a car rental site for an airport/city code. Refer to OpenTravel Code List Vehicle Where At Facility (VWF). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101,
     * 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $CounterLocation;
    /**
     * Constructor method for PickUpLocation
     * @uses PickUpLocation::set_()
     * @uses PickUpLocation::setExtendedLocationCode()
     * @uses PickUpLocation::setCounterLocation()
     * @param \StructType\LocationType $_
     * @param string $extendedLocationCode
     * @param string $counterLocation
     */
    public function __construct(\StructType\LocationType $_ = null, $extendedLocationCode = null, $counterLocation = null)
    {
        $this
            ->set_($_)
            ->setExtendedLocationCode($extendedLocationCode)
            ->setCounterLocation($counterLocation);
    }
    /**
     * Get _ value
     * @return \StructType\LocationType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\LocationType $_
     * @return \StructType\PickUpLocation
     */
    public function set_(\StructType\LocationType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ExtendedLocationCode value
     * @return string|null
     */
    public function getExtendedLocationCode()
    {
        return $this->ExtendedLocationCode;
    }
    /**
     * Set ExtendedLocationCode value
     * @param string $extendedLocationCode
     * @return \StructType\PickUpLocation
     */
    public function setExtendedLocationCode($extendedLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($extendedLocationCode) && !is_string($extendedLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedLocationCode, true), gettype($extendedLocationCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($extendedLocationCode) && mb_strlen($extendedLocationCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($extendedLocationCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($extendedLocationCode) && mb_strlen($extendedLocationCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($extendedLocationCode)), __LINE__);
        }
        $this->ExtendedLocationCode = $extendedLocationCode;
        return $this;
    }
    /**
     * Get CounterLocation value
     * @return string|null
     */
    public function getCounterLocation()
    {
        return $this->CounterLocation;
    }
    /**
     * Set CounterLocation value
     * @param string $counterLocation
     * @return \StructType\PickUpLocation
     */
    public function setCounterLocation($counterLocation = null)
    {
        // validation for constraint: string
        if (!is_null($counterLocation) && !is_string($counterLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($counterLocation, true), gettype($counterLocation)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($counterLocation) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $counterLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($counterLocation, true)), __LINE__);
        }
        $this->CounterLocation = $counterLocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PickUpLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
