<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhysChallFeaturePrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the customer's level of preference for the hotel physically challenged feature identified. | Indicates preferences for type of features required to meet the needs of persons with physical challenges, disabilities, etc. |
 * Used for Character Strings, length 1 to 128.
 * - base: xs:string
 * - maxLength: 128
 * - minLength: 1
 * @subpackage Structs
 */
class PhysChallFeaturePrefType extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The PhysChallFeatureType
     * Meta information extracted from the WSDL
     * - documentation: Identifies the types of features the hotel offers to service physically challenged guests. Refer to OpenTravel Code List Physically Challenged Feature Code (PHY). | Used for codes in the OpenTravel Code tables. Possible values of
     * this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $PhysChallFeatureType;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for PhysChallFeaturePrefType
     * @uses PhysChallFeaturePrefType::set_()
     * @uses PhysChallFeaturePrefType::setPhysChallFeatureType()
     * @uses PhysChallFeaturePrefType::setPreferLevel()
     * @param string $_
     * @param string $physChallFeatureType
     * @param string $preferLevel
     */
    public function __construct($_ = null, $physChallFeatureType = null, $preferLevel = null)
    {
        $this
            ->set_($_)
            ->setPhysChallFeatureType($physChallFeatureType)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\PhysChallFeaturePrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($_) && mb_strlen($_) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($_) && mb_strlen($_) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PhysChallFeatureType value
     * @return string|null
     */
    public function getPhysChallFeatureType()
    {
        return $this->PhysChallFeatureType;
    }
    /**
     * Set PhysChallFeatureType value
     * @param string $physChallFeatureType
     * @return \StructType\PhysChallFeaturePrefType
     */
    public function setPhysChallFeatureType($physChallFeatureType = null)
    {
        // validation for constraint: string
        if (!is_null($physChallFeatureType) && !is_string($physChallFeatureType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($physChallFeatureType, true), gettype($physChallFeatureType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($physChallFeatureType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $physChallFeatureType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($physChallFeatureType, true)), __LINE__);
        }
        $this->PhysChallFeatureType = $physChallFeatureType;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\PhysChallFeaturePrefType
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PhysChallFeaturePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
