<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonNameType StructType
 * Meta information extracted from the WSDL
 * - documentation: Allows for control of the sharing of person name data between parties. | This provides name information for a person.
 * @subpackage Structs
 */
class PersonNameType extends AbstractStructBase
{
    /**
     * The NamePrefix
     * Meta information extracted from the WSDL
     * - documentation: Salutation of honorific (e.g. Mr., Mrs., Ms., Miss, Dr.) | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - maxOccurs: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $NamePrefix;
    /**
     * The GivenName
     * Meta information extracted from the WSDL
     * - documentation: Given name, first name or names. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - maxOccurs: 5
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $GivenName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - documentation: The middle name of the person name. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - maxOccurs: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $MiddleName;
    /**
     * The SurnamePrefix
     * Meta information extracted from the WSDL
     * - documentation: e.g "van der", "von", "de". | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurnamePrefix;
    /**
     * The Surname
     * Meta information extracted from the WSDL
     * - documentation: Family name, last name. May also be used for full name if the sending system does not have the ability to separate a full name into its parts, e.g. the surname element may be used to pass the full name. | Used for Character Strings,
     * length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $Surname;
    /**
     * The NameSuffix
     * Meta information extracted from the WSDL
     * - documentation: Hold various name suffixes and letters (e.g. Jr., Sr., III, Ret., Esq.) | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - maxOccurs: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $NameSuffix;
    /**
     * The NameTitle
     * Meta information extracted from the WSDL
     * - documentation: Degree or honors (e.g., Ph.D., M.D.) | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - maxOccurs: 5
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $NameTitle;
    /**
     * The NameType
     * Meta information extracted from the WSDL
     * - documentation: Type of name of the individual, such as former, nickname, alternate or alias name. Refer to OpenTravel Code List Name Type (NAM). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or
     * 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $NameType;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for PersonNameType
     * @uses PersonNameType::setNamePrefix()
     * @uses PersonNameType::setGivenName()
     * @uses PersonNameType::setMiddleName()
     * @uses PersonNameType::setSurnamePrefix()
     * @uses PersonNameType::setSurname()
     * @uses PersonNameType::setNameSuffix()
     * @uses PersonNameType::setNameTitle()
     * @uses PersonNameType::setNameType()
     * @uses PersonNameType::setShareSynchInd()
     * @uses PersonNameType::setShareMarketInd()
     * @param string[] $namePrefix
     * @param string[] $givenName
     * @param string[] $middleName
     * @param string $surnamePrefix
     * @param string $surname
     * @param string[] $nameSuffix
     * @param string[] $nameTitle
     * @param string $nameType
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     */
    public function __construct(array $namePrefix = array(), array $givenName = array(), array $middleName = array(), $surnamePrefix = null, $surname = null, array $nameSuffix = array(), array $nameTitle = array(), $nameType = null, $shareSynchInd = null, $shareMarketInd = null)
    {
        $this
            ->setNamePrefix($namePrefix)
            ->setGivenName($givenName)
            ->setMiddleName($middleName)
            ->setSurnamePrefix($surnamePrefix)
            ->setSurname($surname)
            ->setNameSuffix($nameSuffix)
            ->setNameTitle($nameTitle)
            ->setNameType($nameType)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get NamePrefix value
     * @return string[]|null
     */
    public function getNamePrefix()
    {
        return $this->NamePrefix;
    }
    /**
     * This method is responsible for validating the values passed to the setNamePrefix method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNamePrefix method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNamePrefixForArrayConstraintsFromSetNamePrefix(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeNamePrefixItem) {
            // validation for constraint: itemType
            if (!is_string($personNameTypeNamePrefixItem)) {
                $invalidValues[] = is_object($personNameTypeNamePrefixItem) ? get_class($personNameTypeNamePrefixItem) : sprintf('%s(%s)', gettype($personNameTypeNamePrefixItem), var_export($personNameTypeNamePrefixItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NamePrefix property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setNamePrefix method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNamePrefix method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNamePrefixForMaxLengthConstraintFromSetNamePrefix($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeNamePrefixItem) {
            // validation for constraint: maxLength(16)
            if (mb_strlen($personNameTypeNamePrefixItem) > 16) {
                $invalidValues[] = var_export($personNameTypeNamePrefixItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 16', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setNamePrefix method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNamePrefix method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNamePrefixForMinLengthConstraintFromSetNamePrefix($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeNamePrefixItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($personNameTypeNamePrefixItem) < 1) {
                $invalidValues[] = var_export($personNameTypeNamePrefixItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NamePrefix value
     * @throws \InvalidArgumentException
     * @param string[] $namePrefix
     * @return \StructType\PersonNameType
     */
    public function setNamePrefix(array $namePrefix = array())
    {
        // validation for constraint: array
        if ('' !== ($namePrefixArrayErrorMessage = self::validateNamePrefixForArrayConstraintsFromSetNamePrefix($namePrefix))) {
            throw new \InvalidArgumentException($namePrefixArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(16)
        if ('' !== ($namePrefixMaxLengthErrorMessage = self::validateNamePrefixForMaxLengthConstraintFromSetNamePrefix($namePrefix))) {
            throw new \InvalidArgumentException($namePrefixMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($namePrefix) && count($namePrefix) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($namePrefix)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($namePrefixMinLengthErrorMessage = self::validateNamePrefixForMinLengthConstraintFromSetNamePrefix($namePrefix))) {
            throw new \InvalidArgumentException($namePrefixMinLengthErrorMessage, __LINE__);
        }
        $this->NamePrefix = $namePrefix;
        return $this;
    }
    /**
     * Add item to NamePrefix value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PersonNameType
     */
    public function addToNamePrefix($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The NamePrefix property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (mb_strlen($item) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->NamePrefix) && count($this->NamePrefix) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->NamePrefix)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->NamePrefix[] = $item;
        return $this;
    }
    /**
     * Get GivenName value
     * @return string[]|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * This method is responsible for validating the values passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForArrayConstraintsFromSetGivenName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeGivenNameItem) {
            // validation for constraint: itemType
            if (!is_string($personNameTypeGivenNameItem)) {
                $invalidValues[] = is_object($personNameTypeGivenNameItem) ? get_class($personNameTypeGivenNameItem) : sprintf('%s(%s)', gettype($personNameTypeGivenNameItem), var_export($personNameTypeGivenNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GivenName property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForMaxLengthConstraintFromSetGivenName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeGivenNameItem) {
            // validation for constraint: maxLength(64)
            if (mb_strlen($personNameTypeGivenNameItem) > 64) {
                $invalidValues[] = var_export($personNameTypeGivenNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 64', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForMinLengthConstraintFromSetGivenName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeGivenNameItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($personNameTypeGivenNameItem) < 1) {
                $invalidValues[] = var_export($personNameTypeGivenNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GivenName value
     * @throws \InvalidArgumentException
     * @param string[] $givenName
     * @return \StructType\PersonNameType
     */
    public function setGivenName(array $givenName = array())
    {
        // validation for constraint: array
        if ('' !== ($givenNameArrayErrorMessage = self::validateGivenNameForArrayConstraintsFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(64)
        if ('' !== ($givenNameMaxLengthErrorMessage = self::validateGivenNameForMaxLengthConstraintFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($givenName) && count($givenName) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($givenName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($givenNameMinLengthErrorMessage = self::validateGivenNameForMinLengthConstraintFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameMinLengthErrorMessage, __LINE__);
        }
        $this->GivenName = $givenName;
        return $this;
    }
    /**
     * Add item to GivenName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PersonNameType
     */
    public function addToGivenName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The GivenName property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (mb_strlen($item) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->GivenName) && count($this->GivenName) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->GivenName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->GivenName[] = $item;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string[]|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * This method is responsible for validating the values passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForArrayConstraintsFromSetMiddleName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeMiddleNameItem) {
            // validation for constraint: itemType
            if (!is_string($personNameTypeMiddleNameItem)) {
                $invalidValues[] = is_object($personNameTypeMiddleNameItem) ? get_class($personNameTypeMiddleNameItem) : sprintf('%s(%s)', gettype($personNameTypeMiddleNameItem), var_export($personNameTypeMiddleNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MiddleName property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForMaxLengthConstraintFromSetMiddleName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeMiddleNameItem) {
            // validation for constraint: maxLength(64)
            if (mb_strlen($personNameTypeMiddleNameItem) > 64) {
                $invalidValues[] = var_export($personNameTypeMiddleNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 64', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForMinLengthConstraintFromSetMiddleName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeMiddleNameItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($personNameTypeMiddleNameItem) < 1) {
                $invalidValues[] = var_export($personNameTypeMiddleNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MiddleName value
     * @throws \InvalidArgumentException
     * @param string[] $middleName
     * @return \StructType\PersonNameType
     */
    public function setMiddleName(array $middleName = array())
    {
        // validation for constraint: array
        if ('' !== ($middleNameArrayErrorMessage = self::validateMiddleNameForArrayConstraintsFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(64)
        if ('' !== ($middleNameMaxLengthErrorMessage = self::validateMiddleNameForMaxLengthConstraintFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($middleName) && count($middleName) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($middleName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($middleNameMinLengthErrorMessage = self::validateMiddleNameForMinLengthConstraintFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameMinLengthErrorMessage, __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Add item to MiddleName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PersonNameType
     */
    public function addToMiddleName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The MiddleName property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (mb_strlen($item) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->MiddleName) && count($this->MiddleName) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->MiddleName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->MiddleName[] = $item;
        return $this;
    }
    /**
     * Get SurnamePrefix value
     * @return string|null
     */
    public function getSurnamePrefix()
    {
        return $this->SurnamePrefix;
    }
    /**
     * Set SurnamePrefix value
     * @param string $surnamePrefix
     * @return \StructType\PersonNameType
     */
    public function setSurnamePrefix($surnamePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($surnamePrefix) && !is_string($surnamePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surnamePrefix, true), gettype($surnamePrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($surnamePrefix) && mb_strlen($surnamePrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($surnamePrefix)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($surnamePrefix) && mb_strlen($surnamePrefix) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($surnamePrefix)), __LINE__);
        }
        $this->SurnamePrefix = $surnamePrefix;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\PersonNameType
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($surname) && mb_strlen($surname) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($surname)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($surname) && mb_strlen($surname) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get NameSuffix value
     * @return string[]|null
     */
    public function getNameSuffix()
    {
        return $this->NameSuffix;
    }
    /**
     * This method is responsible for validating the values passed to the setNameSuffix method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameSuffix method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameSuffixForArrayConstraintsFromSetNameSuffix(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeNameSuffixItem) {
            // validation for constraint: itemType
            if (!is_string($personNameTypeNameSuffixItem)) {
                $invalidValues[] = is_object($personNameTypeNameSuffixItem) ? get_class($personNameTypeNameSuffixItem) : sprintf('%s(%s)', gettype($personNameTypeNameSuffixItem), var_export($personNameTypeNameSuffixItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NameSuffix property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setNameSuffix method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameSuffix method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameSuffixForMaxLengthConstraintFromSetNameSuffix($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeNameSuffixItem) {
            // validation for constraint: maxLength(16)
            if (mb_strlen($personNameTypeNameSuffixItem) > 16) {
                $invalidValues[] = var_export($personNameTypeNameSuffixItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 16', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setNameSuffix method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameSuffix method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameSuffixForMinLengthConstraintFromSetNameSuffix($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeNameSuffixItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($personNameTypeNameSuffixItem) < 1) {
                $invalidValues[] = var_export($personNameTypeNameSuffixItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NameSuffix value
     * @throws \InvalidArgumentException
     * @param string[] $nameSuffix
     * @return \StructType\PersonNameType
     */
    public function setNameSuffix(array $nameSuffix = array())
    {
        // validation for constraint: array
        if ('' !== ($nameSuffixArrayErrorMessage = self::validateNameSuffixForArrayConstraintsFromSetNameSuffix($nameSuffix))) {
            throw new \InvalidArgumentException($nameSuffixArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(16)
        if ('' !== ($nameSuffixMaxLengthErrorMessage = self::validateNameSuffixForMaxLengthConstraintFromSetNameSuffix($nameSuffix))) {
            throw new \InvalidArgumentException($nameSuffixMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($nameSuffix) && count($nameSuffix) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($nameSuffix)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($nameSuffixMinLengthErrorMessage = self::validateNameSuffixForMinLengthConstraintFromSetNameSuffix($nameSuffix))) {
            throw new \InvalidArgumentException($nameSuffixMinLengthErrorMessage, __LINE__);
        }
        $this->NameSuffix = $nameSuffix;
        return $this;
    }
    /**
     * Add item to NameSuffix value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PersonNameType
     */
    public function addToNameSuffix($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The NameSuffix property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (mb_strlen($item) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->NameSuffix) && count($this->NameSuffix) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->NameSuffix)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->NameSuffix[] = $item;
        return $this;
    }
    /**
     * Get NameTitle value
     * @return string[]|null
     */
    public function getNameTitle()
    {
        return $this->NameTitle;
    }
    /**
     * This method is responsible for validating the values passed to the setNameTitle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameTitle method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameTitleForArrayConstraintsFromSetNameTitle(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeNameTitleItem) {
            // validation for constraint: itemType
            if (!is_string($personNameTypeNameTitleItem)) {
                $invalidValues[] = is_object($personNameTypeNameTitleItem) ? get_class($personNameTypeNameTitleItem) : sprintf('%s(%s)', gettype($personNameTypeNameTitleItem), var_export($personNameTypeNameTitleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NameTitle property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setNameTitle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameTitle method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameTitleForMaxLengthConstraintFromSetNameTitle($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeNameTitleItem) {
            // validation for constraint: maxLength(16)
            if (mb_strlen($personNameTypeNameTitleItem) > 16) {
                $invalidValues[] = var_export($personNameTypeNameTitleItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 16', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setNameTitle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameTitle method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameTitleForMinLengthConstraintFromSetNameTitle($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeNameTitleItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($personNameTypeNameTitleItem) < 1) {
                $invalidValues[] = var_export($personNameTypeNameTitleItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NameTitle value
     * @throws \InvalidArgumentException
     * @param string[] $nameTitle
     * @return \StructType\PersonNameType
     */
    public function setNameTitle(array $nameTitle = array())
    {
        // validation for constraint: array
        if ('' !== ($nameTitleArrayErrorMessage = self::validateNameTitleForArrayConstraintsFromSetNameTitle($nameTitle))) {
            throw new \InvalidArgumentException($nameTitleArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(16)
        if ('' !== ($nameTitleMaxLengthErrorMessage = self::validateNameTitleForMaxLengthConstraintFromSetNameTitle($nameTitle))) {
            throw new \InvalidArgumentException($nameTitleMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($nameTitle) && count($nameTitle) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($nameTitle)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($nameTitleMinLengthErrorMessage = self::validateNameTitleForMinLengthConstraintFromSetNameTitle($nameTitle))) {
            throw new \InvalidArgumentException($nameTitleMinLengthErrorMessage, __LINE__);
        }
        $this->NameTitle = $nameTitle;
        return $this;
    }
    /**
     * Add item to NameTitle value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PersonNameType
     */
    public function addToNameTitle($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The NameTitle property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (mb_strlen($item) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->NameTitle) && count($this->NameTitle) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->NameTitle)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->NameTitle[] = $item;
        return $this;
    }
    /**
     * Get NameType value
     * @return string|null
     */
    public function getNameType()
    {
        return $this->NameType;
    }
    /**
     * Set NameType value
     * @param string $nameType
     * @return \StructType\PersonNameType
     */
    public function setNameType($nameType = null)
    {
        // validation for constraint: string
        if (!is_null($nameType) && !is_string($nameType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameType, true), gettype($nameType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($nameType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $nameType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($nameType, true)), __LINE__);
        }
        $this->NameType = $nameType;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\PersonNameType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\PersonNameType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
