<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentDetails StructType
 * Meta information extracted from the WSDL
 * - documentation: Container for Payment Detail.
 * @subpackage Structs
 */
class PaymentDetails extends AbstractStructBase
{
    /**
     * The PaymentDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\PaymentDetail[]
     */
    public $PaymentDetail;
    /**
     * Constructor method for PaymentDetails
     * @uses PaymentDetails::setPaymentDetail()
     * @param \StructType\PaymentDetail[] $paymentDetail
     */
    public function __construct(array $paymentDetail = array())
    {
        $this
            ->setPaymentDetail($paymentDetail);
    }
    /**
     * Get PaymentDetail value
     * @return \StructType\PaymentDetail[]|null
     */
    public function getPaymentDetail()
    {
        return $this->PaymentDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentDetailForArrayConstraintsFromSetPaymentDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentDetailsPaymentDetailItem) {
            // validation for constraint: itemType
            if (!$paymentDetailsPaymentDetailItem instanceof \StructType\PaymentDetail) {
                $invalidValues[] = is_object($paymentDetailsPaymentDetailItem) ? get_class($paymentDetailsPaymentDetailItem) : sprintf('%s(%s)', gettype($paymentDetailsPaymentDetailItem), var_export($paymentDetailsPaymentDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentDetail property can only contain items of type \StructType\PaymentDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentDetail[] $paymentDetail
     * @return \StructType\PaymentDetails
     */
    public function setPaymentDetail(array $paymentDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentDetailArrayErrorMessage = self::validatePaymentDetailForArrayConstraintsFromSetPaymentDetail($paymentDetail))) {
            throw new \InvalidArgumentException($paymentDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($paymentDetail) && count($paymentDetail) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($paymentDetail)), __LINE__);
        }
        $this->PaymentDetail = $paymentDetail;
        return $this;
    }
    /**
     * Add item to PaymentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentDetail $item
     * @return \StructType\PaymentDetails
     */
    public function addToPaymentDetail(\StructType\PaymentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentDetail) {
            throw new \InvalidArgumentException(sprintf('The PaymentDetail property can only contain items of type \StructType\PaymentDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->PaymentDetail) && count($this->PaymentDetail) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->PaymentDetail)), __LINE__);
        }
        $this->PaymentDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
