<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentCardType StructType
 * Meta information extracted from the WSDL
 * - documentation: Date the card becomes valid for use (optional) and the date the card expires (required) in ISO 8601 prescribed format. | Allows for control of the sharing of payment card data between parties. | Identification about a specific credit
 * card.
 * @subpackage Structs
 */
class PaymentCardType extends AbstractStructBase
{
    /**
     * The CardHolderName
     * Meta information extracted from the WSDL
     * - documentation: Name of the card holder. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardHolderName;
    /**
     * The CardIssuerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CardIssuerName
     */
    public $CardIssuerName;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Card holder's address used for additional authorization checks.
     * - minOccurs: 0
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Telephone[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - documentation: Card holder's email address(es) used for additional authorization checks.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\EmailType[]
     */
    public $Email;
    /**
     * The CustLoyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The SignatureOnFile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SignatureOnFile
     */
    public $SignatureOnFile;
    /**
     * The MagneticStripe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MagneticStripe
     */
    public $MagneticStripe;
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - documentation: Indicates the type of magnetic striped card. Refer to OpenTravel Code List Card Type (CDT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $CardType;
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - documentation: The 2 character code of the credit card issuer.
     * - use: optional
     * @var string
     */
    public $CardCode;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - documentation: Credit card number embossed on the card. | Used for Numeric Strings, length 1 to 19.
     * - base: xs:string
     * - pattern: [0-9]{1,19}
     * - use: optional
     * @var string
     */
    public $CardNumber;
    /**
     * The SeriesCode
     * Meta information extracted from the WSDL
     * - documentation: Verification digits printed on the card following the embossed number. This may also accommodate the customer identification/batch number (CID), card verification value (CVV2 ), card validation code number (CVC2) on credit card. |
     * Used for Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $SeriesCode;
    /**
     * The MaskedCardNumber
     * Meta information extracted from the WSDL
     * - documentation: May be used to send a concealed credit card number (e.g., xxxxxxxxxxxx9922). | Used forAlpha-Numeric Strings, length 1 to 19.
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,19}
     * - use: optional
     * @var string
     */
    public $MaskedCardNumber;
    /**
     * The CardHolderRPH
     * Meta information extracted from the WSDL
     * - documentation: Provides a reference pointer that links the payment card to the payment card holder. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual
     * passengers or clients to particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $CardHolderRPH;
    /**
     * The ExtendPaymentIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, the credit card company is requested to delay the date on which the amount of this transaction is applied to the customer's account.
     * - use: optional
     * @var bool
     */
    public $ExtendPaymentIndicator;
    /**
     * The CountryOfIssue
     * Meta information extracted from the WSDL
     * - documentation: Code for the country where the credit card was issued. | Specifies a 2 character country code as defined in ISO3166.
     * - base: xs:string
     * - pattern: [a-zA-Z]{2}
     * - use: optional
     * @var string
     */
    public $CountryOfIssue;
    /**
     * The ExtendedPaymentQuantity
     * Meta information extracted from the WSDL
     * - documentation: A code used to specifiy the installment payment plan or number of payment installments. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $ExtendedPaymentQuantity;
    /**
     * The SignatureOnFileIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, the cardholder signature is on file.
     * - use: optional
     * @var bool
     */
    public $SignatureOnFileIndicator;
    /**
     * The CompanyCardReference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the company sponsor for this particular card (e.g. a Universal Airline Travel Plan (UATP) card or any loyalty scheme sponsored card). | Used forAlpha-Numeric Strings, length 1 to 19.
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,19}
     * - use: optional
     * @var string
     */
    public $CompanyCardReference;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: A remark associated with this payment card. | Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Remark;
    /**
     * The EncryptionKey
     * Meta information extracted from the WSDL
     * - documentation: Database key necessary to retrieve the full credit card (compliant with PCI DSS standards).
     * - use: optional
     * @var string
     */
    public $EncryptionKey;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the starting date. | Month and year information.
     * - base: xs:string
     * - pattern: (0[1-9]|1[0-2])[0-9][0-9]
     * - type: MMYYDate
     * - use: optional
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the ending date. | Month and year information.
     * - base: xs:string
     * - pattern: (0[1-9]|1[0-2])[0-9][0-9]
     * - type: MMYYDate
     * - use: optional
     * @var string
     */
    public $ExpireDate;
    /**
     * Constructor method for PaymentCardType
     * @uses PaymentCardType::setCardHolderName()
     * @uses PaymentCardType::setCardIssuerName()
     * @uses PaymentCardType::setAddress()
     * @uses PaymentCardType::setTelephone()
     * @uses PaymentCardType::setEmail()
     * @uses PaymentCardType::setCustLoyalty()
     * @uses PaymentCardType::setSignatureOnFile()
     * @uses PaymentCardType::setMagneticStripe()
     * @uses PaymentCardType::setCardType()
     * @uses PaymentCardType::setCardCode()
     * @uses PaymentCardType::setCardNumber()
     * @uses PaymentCardType::setSeriesCode()
     * @uses PaymentCardType::setMaskedCardNumber()
     * @uses PaymentCardType::setCardHolderRPH()
     * @uses PaymentCardType::setExtendPaymentIndicator()
     * @uses PaymentCardType::setCountryOfIssue()
     * @uses PaymentCardType::setExtendedPaymentQuantity()
     * @uses PaymentCardType::setSignatureOnFileIndicator()
     * @uses PaymentCardType::setCompanyCardReference()
     * @uses PaymentCardType::setRemark()
     * @uses PaymentCardType::setEncryptionKey()
     * @uses PaymentCardType::setShareSynchInd()
     * @uses PaymentCardType::setShareMarketInd()
     * @uses PaymentCardType::setEffectiveDate()
     * @uses PaymentCardType::setExpireDate()
     * @param string $cardHolderName
     * @param \StructType\CardIssuerName $cardIssuerName
     * @param \StructType\AddressType $address
     * @param \StructType\Telephone[] $telephone
     * @param \StructType\EmailType[] $email
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @param \StructType\SignatureOnFile $signatureOnFile
     * @param \StructType\MagneticStripe $magneticStripe
     * @param string $cardType
     * @param string $cardCode
     * @param string $cardNumber
     * @param string $seriesCode
     * @param string $maskedCardNumber
     * @param string $cardHolderRPH
     * @param bool $extendPaymentIndicator
     * @param string $countryOfIssue
     * @param int $extendedPaymentQuantity
     * @param bool $signatureOnFileIndicator
     * @param string $companyCardReference
     * @param string $remark
     * @param string $encryptionKey
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $effectiveDate
     * @param string $expireDate
     */
    public function __construct($cardHolderName = null, \StructType\CardIssuerName $cardIssuerName = null, \StructType\AddressType $address = null, array $telephone = array(), array $email = array(), array $custLoyalty = array(), \StructType\SignatureOnFile $signatureOnFile = null, \StructType\MagneticStripe $magneticStripe = null, $cardType = null, $cardCode = null, $cardNumber = null, $seriesCode = null, $maskedCardNumber = null, $cardHolderRPH = null, $extendPaymentIndicator = null, $countryOfIssue = null, $extendedPaymentQuantity = null, $signatureOnFileIndicator = null, $companyCardReference = null, $remark = null, $encryptionKey = null, $shareSynchInd = null, $shareMarketInd = null, $effectiveDate = null, $expireDate = null)
    {
        $this
            ->setCardHolderName($cardHolderName)
            ->setCardIssuerName($cardIssuerName)
            ->setAddress($address)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setCustLoyalty($custLoyalty)
            ->setSignatureOnFile($signatureOnFile)
            ->setMagneticStripe($magneticStripe)
            ->setCardType($cardType)
            ->setCardCode($cardCode)
            ->setCardNumber($cardNumber)
            ->setSeriesCode($seriesCode)
            ->setMaskedCardNumber($maskedCardNumber)
            ->setCardHolderRPH($cardHolderRPH)
            ->setExtendPaymentIndicator($extendPaymentIndicator)
            ->setCountryOfIssue($countryOfIssue)
            ->setExtendedPaymentQuantity($extendedPaymentQuantity)
            ->setSignatureOnFileIndicator($signatureOnFileIndicator)
            ->setCompanyCardReference($companyCardReference)
            ->setRemark($remark)
            ->setEncryptionKey($encryptionKey)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate);
    }
    /**
     * Get CardHolderName value
     * @return string|null
     */
    public function getCardHolderName()
    {
        return $this->CardHolderName;
    }
    /**
     * Set CardHolderName value
     * @param string $cardHolderName
     * @return \StructType\PaymentCardType
     */
    public function setCardHolderName($cardHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderName) && !is_string($cardHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolderName, true), gettype($cardHolderName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cardHolderName) && mb_strlen($cardHolderName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($cardHolderName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($cardHolderName) && mb_strlen($cardHolderName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($cardHolderName)), __LINE__);
        }
        $this->CardHolderName = $cardHolderName;
        return $this;
    }
    /**
     * Get CardIssuerName value
     * @return \StructType\CardIssuerName|null
     */
    public function getCardIssuerName()
    {
        return $this->CardIssuerName;
    }
    /**
     * Set CardIssuerName value
     * @param \StructType\CardIssuerName $cardIssuerName
     * @return \StructType\PaymentCardType
     */
    public function setCardIssuerName(\StructType\CardIssuerName $cardIssuerName = null)
    {
        $this->CardIssuerName = $cardIssuerName;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\PaymentCardType
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentCardTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$paymentCardTypeTelephoneItem instanceof \StructType\Telephone) {
                $invalidValues[] = is_object($paymentCardTypeTelephoneItem) ? get_class($paymentCardTypeTelephoneItem) : sprintf('%s(%s)', gettype($paymentCardTypeTelephoneItem), var_export($paymentCardTypeTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone[] $telephone
     * @return \StructType\PaymentCardType
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($telephone) && count($telephone) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone $item
     * @return \StructType\PaymentCardType
     */
    public function addToTelephone(\StructType\Telephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Telephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Telephone) && count($this->Telephone) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Telephone)), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \StructType\EmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentCardTypeEmailItem) {
            // validation for constraint: itemType
            if (!$paymentCardTypeEmailItem instanceof \StructType\EmailType) {
                $invalidValues[] = is_object($paymentCardTypeEmailItem) ? get_class($paymentCardTypeEmailItem) : sprintf('%s(%s)', gettype($paymentCardTypeEmailItem), var_export($paymentCardTypeEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type \StructType\EmailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailType[] $email
     * @return \StructType\PaymentCardType
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($email) && count($email) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailType $item
     * @return \StructType\PaymentCardType
     */
    public function addToEmail(\StructType\EmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmailType) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type \StructType\EmailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->Email) && count($this->Email) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->Email)), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \StructType\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * This method is responsible for validating the values passed to the setCustLoyalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustLoyalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentCardTypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$paymentCardTypeCustLoyaltyItem instanceof \StructType\CustLoyalty) {
                $invalidValues[] = is_object($paymentCardTypeCustLoyaltyItem) ? get_class($paymentCardTypeCustLoyaltyItem) : sprintf('%s(%s)', gettype($paymentCardTypeCustLoyaltyItem), var_export($paymentCardTypeCustLoyaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @return \StructType\PaymentCardType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        // validation for constraint: array
        if ('' !== ($custLoyaltyArrayErrorMessage = self::validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty($custLoyalty))) {
            throw new \InvalidArgumentException($custLoyaltyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($custLoyalty) && count($custLoyalty) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($custLoyalty)), __LINE__);
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty $item
     * @return \StructType\PaymentCardType
     */
    public function addToCustLoyalty(\StructType\CustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->CustLoyalty) && count($this->CustLoyalty) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->CustLoyalty)), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get SignatureOnFile value
     * @return \StructType\SignatureOnFile|null
     */
    public function getSignatureOnFile()
    {
        return $this->SignatureOnFile;
    }
    /**
     * Set SignatureOnFile value
     * @param \StructType\SignatureOnFile $signatureOnFile
     * @return \StructType\PaymentCardType
     */
    public function setSignatureOnFile(\StructType\SignatureOnFile $signatureOnFile = null)
    {
        $this->SignatureOnFile = $signatureOnFile;
        return $this;
    }
    /**
     * Get MagneticStripe value
     * @return \StructType\MagneticStripe|null
     */
    public function getMagneticStripe()
    {
        return $this->MagneticStripe;
    }
    /**
     * Set MagneticStripe value
     * @param \StructType\MagneticStripe $magneticStripe
     * @return \StructType\PaymentCardType
     */
    public function setMagneticStripe(\StructType\MagneticStripe $magneticStripe = null)
    {
        $this->MagneticStripe = $magneticStripe;
        return $this;
    }
    /**
     * Get CardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->CardType;
    }
    /**
     * Set CardType value
     * @param string $cardType
     * @return \StructType\PaymentCardType
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardType, true), gettype($cardType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($cardType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($cardType, true)), __LINE__);
        }
        $this->CardType = $cardType;
        return $this;
    }
    /**
     * Get CardCode value
     * @return string|null
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @uses \EnumType\PaymentCardCodeType::valueIsValid()
     * @uses \EnumType\PaymentCardCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cardCode
     * @return \StructType\PaymentCardType
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentCardCodeType::valueIsValid($cardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentCardCodeType', is_array($cardCode) ? implode(', ', $cardCode) : var_export($cardCode, true), implode(', ', \EnumType\PaymentCardCodeType::getValidValues())), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \StructType\PaymentCardType
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,19})
        if (!is_null($cardNumber) && !preg_match('/[0-9]{1,19}/', $cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,19}', var_export($cardNumber, true)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get SeriesCode value
     * @return string|null
     */
    public function getSeriesCode()
    {
        return $this->SeriesCode;
    }
    /**
     * Set SeriesCode value
     * @param string $seriesCode
     * @return \StructType\PaymentCardType
     */
    public function setSeriesCode($seriesCode = null)
    {
        // validation for constraint: string
        if (!is_null($seriesCode) && !is_string($seriesCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesCode, true), gettype($seriesCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($seriesCode) && !preg_match('/[0-9]{1,8}/', $seriesCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($seriesCode, true)), __LINE__);
        }
        $this->SeriesCode = $seriesCode;
        return $this;
    }
    /**
     * Get MaskedCardNumber value
     * @return string|null
     */
    public function getMaskedCardNumber()
    {
        return $this->MaskedCardNumber;
    }
    /**
     * Set MaskedCardNumber value
     * @param string $maskedCardNumber
     * @return \StructType\PaymentCardType
     */
    public function setMaskedCardNumber($maskedCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($maskedCardNumber) && !is_string($maskedCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maskedCardNumber, true), gettype($maskedCardNumber)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,19})
        if (!is_null($maskedCardNumber) && !preg_match('/[0-9a-zA-Z]{1,19}/', $maskedCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,19}', var_export($maskedCardNumber, true)), __LINE__);
        }
        $this->MaskedCardNumber = $maskedCardNumber;
        return $this;
    }
    /**
     * Get CardHolderRPH value
     * @return string|null
     */
    public function getCardHolderRPH()
    {
        return $this->CardHolderRPH;
    }
    /**
     * Set CardHolderRPH value
     * @param string $cardHolderRPH
     * @return \StructType\PaymentCardType
     */
    public function setCardHolderRPH($cardHolderRPH = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderRPH) && !is_string($cardHolderRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolderRPH, true), gettype($cardHolderRPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($cardHolderRPH) && !preg_match('/[0-9]{1,8}/', $cardHolderRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($cardHolderRPH, true)), __LINE__);
        }
        $this->CardHolderRPH = $cardHolderRPH;
        return $this;
    }
    /**
     * Get ExtendPaymentIndicator value
     * @return bool|null
     */
    public function getExtendPaymentIndicator()
    {
        return $this->ExtendPaymentIndicator;
    }
    /**
     * Set ExtendPaymentIndicator value
     * @param bool $extendPaymentIndicator
     * @return \StructType\PaymentCardType
     */
    public function setExtendPaymentIndicator($extendPaymentIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($extendPaymentIndicator) && !is_bool($extendPaymentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($extendPaymentIndicator, true), gettype($extendPaymentIndicator)), __LINE__);
        }
        $this->ExtendPaymentIndicator = $extendPaymentIndicator;
        return $this;
    }
    /**
     * Get CountryOfIssue value
     * @return string|null
     */
    public function getCountryOfIssue()
    {
        return $this->CountryOfIssue;
    }
    /**
     * Set CountryOfIssue value
     * @param string $countryOfIssue
     * @return \StructType\PaymentCardType
     */
    public function setCountryOfIssue($countryOfIssue = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfIssue) && !is_string($countryOfIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfIssue, true), gettype($countryOfIssue)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{2})
        if (!is_null($countryOfIssue) && !preg_match('/[a-zA-Z]{2}/', $countryOfIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{2}', var_export($countryOfIssue, true)), __LINE__);
        }
        $this->CountryOfIssue = $countryOfIssue;
        return $this;
    }
    /**
     * Get ExtendedPaymentQuantity value
     * @return int|null
     */
    public function getExtendedPaymentQuantity()
    {
        return $this->ExtendedPaymentQuantity;
    }
    /**
     * Set ExtendedPaymentQuantity value
     * @param int $extendedPaymentQuantity
     * @return \StructType\PaymentCardType
     */
    public function setExtendedPaymentQuantity($extendedPaymentQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($extendedPaymentQuantity) && !(is_int($extendedPaymentQuantity) || ctype_digit($extendedPaymentQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($extendedPaymentQuantity, true), gettype($extendedPaymentQuantity)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($extendedPaymentQuantity) && $extendedPaymentQuantity > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($extendedPaymentQuantity, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($extendedPaymentQuantity) && $extendedPaymentQuantity < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($extendedPaymentQuantity, true)), __LINE__);
        }
        $this->ExtendedPaymentQuantity = $extendedPaymentQuantity;
        return $this;
    }
    /**
     * Get SignatureOnFileIndicator value
     * @return bool|null
     */
    public function getSignatureOnFileIndicator()
    {
        return $this->SignatureOnFileIndicator;
    }
    /**
     * Set SignatureOnFileIndicator value
     * @param bool $signatureOnFileIndicator
     * @return \StructType\PaymentCardType
     */
    public function setSignatureOnFileIndicator($signatureOnFileIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($signatureOnFileIndicator) && !is_bool($signatureOnFileIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($signatureOnFileIndicator, true), gettype($signatureOnFileIndicator)), __LINE__);
        }
        $this->SignatureOnFileIndicator = $signatureOnFileIndicator;
        return $this;
    }
    /**
     * Get CompanyCardReference value
     * @return string|null
     */
    public function getCompanyCardReference()
    {
        return $this->CompanyCardReference;
    }
    /**
     * Set CompanyCardReference value
     * @param string $companyCardReference
     * @return \StructType\PaymentCardType
     */
    public function setCompanyCardReference($companyCardReference = null)
    {
        // validation for constraint: string
        if (!is_null($companyCardReference) && !is_string($companyCardReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyCardReference, true), gettype($companyCardReference)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,19})
        if (!is_null($companyCardReference) && !preg_match('/[0-9a-zA-Z]{1,19}/', $companyCardReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,19}', var_export($companyCardReference, true)), __LINE__);
        }
        $this->CompanyCardReference = $companyCardReference;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\PaymentCardType
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($remark) && mb_strlen($remark) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($remark)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($remark) && mb_strlen($remark) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get EncryptionKey value
     * @return string|null
     */
    public function getEncryptionKey()
    {
        return $this->EncryptionKey;
    }
    /**
     * Set EncryptionKey value
     * @param string $encryptionKey
     * @return \StructType\PaymentCardType
     */
    public function setEncryptionKey($encryptionKey = null)
    {
        // validation for constraint: string
        if (!is_null($encryptionKey) && !is_string($encryptionKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encryptionKey, true), gettype($encryptionKey)), __LINE__);
        }
        $this->EncryptionKey = $encryptionKey;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\PaymentCardType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\PaymentCardType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\PaymentCardType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        // validation for constraint: pattern((0[1-9]|1[0-2])[0-9][0-9])
        if (!is_null($effectiveDate) && !preg_match('/(0[1-9]|1[0-2])[0-9][0-9]/', $effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (0[1-9]|1[0-2])[0-9][0-9]', var_export($effectiveDate, true)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\PaymentCardType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        // validation for constraint: pattern((0[1-9]|1[0-2])[0-9][0-9])
        if (!is_null($expireDate) && !preg_match('/(0[1-9]|1[0-2])[0-9][0-9]/', $expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (0[1-9]|1[0-2])[0-9][0-9]', var_export($expireDate, true)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentCardType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
