<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParagraphType StructType
 * Meta information extracted from the WSDL
 * - documentation: The language for this paragraph. | Creation date time, Creator ID, last modification date time and last modifier ID for the paragraph. | An indication of a new paragraph for a sub-section of a formatted text message.
 * @subpackage Structs
 */
class ParagraphType extends AbstractStructBase
{
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: Formatted text content.
     * - choice: Text | Image | URL | ListItem
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var \StructType\FormattedTextTextType
     */
    public $Text;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - documentation: An image for this paragraph.
     * - choice: Text | Image | URL | ListItem
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var string
     */
    public $Image;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: A URL for this paragraph.
     * - choice: Text | Image | URL | ListItem
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The ListItem
     * Meta information extracted from the WSDL
     * - choice: Text | Image | URL | ListItem
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var \StructType\ListItem
     */
    public $ListItem;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: In many cases the description repeats, this will allow you to define the information that is being sent, typically used when multiple occurrences of ParagraphType are being sent. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The ParagraphNumber
     * Meta information extracted from the WSDL
     * - documentation: The sequence number for the paragraph.
     * - use: optional
     * @var int
     */
    public $ParagraphNumber;
    /**
     * The CreateDateTime
     * Meta information extracted from the WSDL
     * - documentation: Time stamp of the creation.
     * - type: xs:dateTime
     * - use: optional
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CreatorID
     * Meta information extracted from the WSDL
     * - documentation: ID of creator. The creator could be a software system identifier or an identifier of an employee resposible for the creation. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $CreatorID;
    /**
     * The LastModifyDateTime
     * Meta information extracted from the WSDL
     * - documentation: Time stamp of last modification.
     * - type: xs:dateTime
     * - use: optional
     * @var string
     */
    public $LastModifyDateTime;
    /**
     * The LastModifierID
     * Meta information extracted from the WSDL
     * - documentation: Identifies the last software system or person to modify a record. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $LastModifierID;
    /**
     * The PurgeDate
     * Meta information extracted from the WSDL
     * - documentation: Date an item will be purged from a database (e.g., from a live database to an archive).
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $PurgeDate;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: Language identification.
     * - type: xs:language
     * - use: optional
     * @var string
     */
    public $Language;
    /**
     * Constructor method for ParagraphType
     * @uses ParagraphType::setText()
     * @uses ParagraphType::setImage()
     * @uses ParagraphType::setURL()
     * @uses ParagraphType::setListItem()
     * @uses ParagraphType::setName()
     * @uses ParagraphType::setParagraphNumber()
     * @uses ParagraphType::setCreateDateTime()
     * @uses ParagraphType::setCreatorID()
     * @uses ParagraphType::setLastModifyDateTime()
     * @uses ParagraphType::setLastModifierID()
     * @uses ParagraphType::setPurgeDate()
     * @uses ParagraphType::setLanguage()
     * @param \StructType\FormattedTextTextType $text
     * @param string $image
     * @param string $uRL
     * @param \StructType\ListItem $listItem
     * @param string $name
     * @param int $paragraphNumber
     * @param string $createDateTime
     * @param string $creatorID
     * @param string $lastModifyDateTime
     * @param string $lastModifierID
     * @param string $purgeDate
     * @param string $language
     */
    public function __construct(\StructType\FormattedTextTextType $text = null, $image = null, $uRL = null, \StructType\ListItem $listItem = null, $name = null, $paragraphNumber = null, $createDateTime = null, $creatorID = null, $lastModifyDateTime = null, $lastModifierID = null, $purgeDate = null, $language = null)
    {
        $this
            ->setText($text)
            ->setImage($image)
            ->setURL($uRL)
            ->setListItem($listItem)
            ->setName($name)
            ->setParagraphNumber($paragraphNumber)
            ->setCreateDateTime($createDateTime)
            ->setCreatorID($creatorID)
            ->setLastModifyDateTime($lastModifyDateTime)
            ->setLastModifierID($lastModifierID)
            ->setPurgeDate($purgeDate)
            ->setLanguage($language);
    }
    /**
     * Get Text value
     * @return \StructType\FormattedTextTextType|null
     */
    public function getText()
    {
        return isset($this->Text) ? $this->Text : null;
    }
    /**
     * This method is responsible for validating the value passed to the setText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setText method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTextForChoiceConstraintsFromSetText($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Image',
            'URL',
            'ListItem',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Text can\'t be set as the property %s is already set. Only one property must be set among these properties: Text, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Text value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FormattedTextTextType $text
     * @return \StructType\ParagraphType
     */
    public function setText(\StructType\FormattedTextTextType $text = null)
    {
        // validation for constraint: choice(Text, Image, URL, ListItem)
        if ('' !== ($textChoiceErrorMessage = self::validateTextForChoiceConstraintsFromSetText($text))) {
            throw new \InvalidArgumentException($textChoiceErrorMessage, __LINE__);
        }
        if (is_null($text) || (is_array($text) && empty($text))) {
            unset($this->Text);
        } else {
            $this->Text = $text;
        }
        return $this;
    }
    /**
     * Get Image value
     * @return string|null
     */
    public function getImage()
    {
        return isset($this->Image) ? $this->Image : null;
    }
    /**
     * This method is responsible for validating the value passed to the setImage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImage method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateImageForChoiceConstraintsFromSetImage($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Text',
            'URL',
            'ListItem',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Image can\'t be set as the property %s is already set. Only one property must be set among these properties: Image, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Image value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $image
     * @return \StructType\ParagraphType
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        // validation for constraint: choice(Text, Image, URL, ListItem)
        if ('' !== ($imageChoiceErrorMessage = self::validateImageForChoiceConstraintsFromSetImage($image))) {
            throw new \InvalidArgumentException($imageChoiceErrorMessage, __LINE__);
        }
        if (is_null($image) || (is_array($image) && empty($image))) {
            unset($this->Image);
        } else {
            $this->Image = $image;
        }
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return isset($this->URL) ? $this->URL : null;
    }
    /**
     * This method is responsible for validating the value passed to the setURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setURL method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateURLForChoiceConstraintsFromSetURL($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Text',
            'Image',
            'ListItem',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property URL can\'t be set as the property %s is already set. Only one property must be set among these properties: URL, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set URL value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uRL
     * @return \StructType\ParagraphType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        // validation for constraint: choice(Text, Image, URL, ListItem)
        if ('' !== ($uRLChoiceErrorMessage = self::validateURLForChoiceConstraintsFromSetURL($uRL))) {
            throw new \InvalidArgumentException($uRLChoiceErrorMessage, __LINE__);
        }
        if (is_null($uRL) || (is_array($uRL) && empty($uRL))) {
            unset($this->URL);
        } else {
            $this->URL = $uRL;
        }
        return $this;
    }
    /**
     * Get ListItem value
     * @return \StructType\ListItem|null
     */
    public function getListItem()
    {
        return isset($this->ListItem) ? $this->ListItem : null;
    }
    /**
     * This method is responsible for validating the value passed to the setListItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListItem method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateListItemForChoiceConstraintsFromSetListItem($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Text',
            'Image',
            'URL',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ListItem can\'t be set as the property %s is already set. Only one property must be set among these properties: ListItem, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ListItem value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ListItem $listItem
     * @return \StructType\ParagraphType
     */
    public function setListItem(\StructType\ListItem $listItem = null)
    {
        // validation for constraint: choice(Text, Image, URL, ListItem)
        if ('' !== ($listItemChoiceErrorMessage = self::validateListItemForChoiceConstraintsFromSetListItem($listItem))) {
            throw new \InvalidArgumentException($listItemChoiceErrorMessage, __LINE__);
        }
        if (is_null($listItem) || (is_array($listItem) && empty($listItem))) {
            unset($this->ListItem);
        } else {
            $this->ListItem = $listItem;
        }
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ParagraphType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($name) && mb_strlen($name) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name) && mb_strlen($name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ParagraphNumber value
     * @return int|null
     */
    public function getParagraphNumber()
    {
        return $this->ParagraphNumber;
    }
    /**
     * Set ParagraphNumber value
     * @param int $paragraphNumber
     * @return \StructType\ParagraphType
     */
    public function setParagraphNumber($paragraphNumber = null)
    {
        // validation for constraint: int
        if (!is_null($paragraphNumber) && !(is_int($paragraphNumber) || ctype_digit($paragraphNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paragraphNumber, true), gettype($paragraphNumber)), __LINE__);
        }
        $this->ParagraphNumber = $paragraphNumber;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \StructType\ParagraphType
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateTime, true), gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CreatorID value
     * @return string|null
     */
    public function getCreatorID()
    {
        return $this->CreatorID;
    }
    /**
     * Set CreatorID value
     * @param string $creatorID
     * @return \StructType\ParagraphType
     */
    public function setCreatorID($creatorID = null)
    {
        // validation for constraint: string
        if (!is_null($creatorID) && !is_string($creatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorID, true), gettype($creatorID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($creatorID) && mb_strlen($creatorID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($creatorID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($creatorID) && mb_strlen($creatorID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($creatorID)), __LINE__);
        }
        $this->CreatorID = $creatorID;
        return $this;
    }
    /**
     * Get LastModifyDateTime value
     * @return string|null
     */
    public function getLastModifyDateTime()
    {
        return $this->LastModifyDateTime;
    }
    /**
     * Set LastModifyDateTime value
     * @param string $lastModifyDateTime
     * @return \StructType\ParagraphType
     */
    public function setLastModifyDateTime($lastModifyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifyDateTime) && !is_string($lastModifyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifyDateTime, true), gettype($lastModifyDateTime)), __LINE__);
        }
        $this->LastModifyDateTime = $lastModifyDateTime;
        return $this;
    }
    /**
     * Get LastModifierID value
     * @return string|null
     */
    public function getLastModifierID()
    {
        return $this->LastModifierID;
    }
    /**
     * Set LastModifierID value
     * @param string $lastModifierID
     * @return \StructType\ParagraphType
     */
    public function setLastModifierID($lastModifierID = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifierID) && !is_string($lastModifierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifierID, true), gettype($lastModifierID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($lastModifierID) && mb_strlen($lastModifierID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($lastModifierID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lastModifierID) && mb_strlen($lastModifierID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lastModifierID)), __LINE__);
        }
        $this->LastModifierID = $lastModifierID;
        return $this;
    }
    /**
     * Get PurgeDate value
     * @return string|null
     */
    public function getPurgeDate()
    {
        return $this->PurgeDate;
    }
    /**
     * Set PurgeDate value
     * @param string $purgeDate
     * @return \StructType\ParagraphType
     */
    public function setPurgeDate($purgeDate = null)
    {
        // validation for constraint: string
        if (!is_null($purgeDate) && !is_string($purgeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purgeDate, true), gettype($purgeDate)), __LINE__);
        }
        $this->PurgeDate = $purgeDate;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\ParagraphType
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ParagraphType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
