<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherServiceInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Other Service Information (OSI) for relevant airlines
 * @subpackage Structs
 */
class OtherServiceInfoType extends AbstractStructBase
{
    /**
     * The TravelerRefNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TravelerRefNumber[]
     */
    public $TravelerRefNumber;
    /**
     * The Airline
     * Meta information extracted from the WSDL
     * - documentation: The airline to which the OSI applies. When applicable to all airlines or an unknown airline use Code="YY".
     * @var \StructType\CompanyNameType
     */
    public $Airline;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: The OSI text. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $Text;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: A proprietary code used between systems to identify an Other Service Information (OSI) item. | Used for an Alpha String, length exactly 4.
     * - base: xs:string
     * - pattern: [a-zA-Z]{4}
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * Constructor method for OtherServiceInfoType
     * @uses OtherServiceInfoType::setTravelerRefNumber()
     * @uses OtherServiceInfoType::setAirline()
     * @uses OtherServiceInfoType::setText()
     * @uses OtherServiceInfoType::setCode()
     * @param \StructType\TravelerRefNumber[] $travelerRefNumber
     * @param \StructType\CompanyNameType $airline
     * @param string $text
     * @param string $code
     */
    public function __construct(array $travelerRefNumber = array(), \StructType\CompanyNameType $airline = null, $text = null, $code = null)
    {
        $this
            ->setTravelerRefNumber($travelerRefNumber)
            ->setAirline($airline)
            ->setText($text)
            ->setCode($code);
    }
    /**
     * Get TravelerRefNumber value
     * @return \StructType\TravelerRefNumber[]|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelerRefNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelerRefNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelerRefNumberForArrayConstraintsFromSetTravelerRefNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $otherServiceInfoTypeTravelerRefNumberItem) {
            // validation for constraint: itemType
            if (!$otherServiceInfoTypeTravelerRefNumberItem instanceof \StructType\TravelerRefNumber) {
                $invalidValues[] = is_object($otherServiceInfoTypeTravelerRefNumberItem) ? get_class($otherServiceInfoTypeTravelerRefNumberItem) : sprintf('%s(%s)', gettype($otherServiceInfoTypeTravelerRefNumberItem), var_export($otherServiceInfoTypeTravelerRefNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelerRefNumber property can only contain items of type \StructType\TravelerRefNumber, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelerRefNumber[] $travelerRefNumber
     * @return \StructType\OtherServiceInfoType
     */
    public function setTravelerRefNumber(array $travelerRefNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($travelerRefNumberArrayErrorMessage = self::validateTravelerRefNumberForArrayConstraintsFromSetTravelerRefNumber($travelerRefNumber))) {
            throw new \InvalidArgumentException($travelerRefNumberArrayErrorMessage, __LINE__);
        }
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Add item to TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelerRefNumber $item
     * @return \StructType\OtherServiceInfoType
     */
    public function addToTravelerRefNumber(\StructType\TravelerRefNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TravelerRefNumber) {
            throw new \InvalidArgumentException(sprintf('The TravelerRefNumber property can only contain items of type \StructType\TravelerRefNumber, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelerRefNumber[] = $item;
        return $this;
    }
    /**
     * Get Airline value
     * @return \StructType\CompanyNameType|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param \StructType\CompanyNameType $airline
     * @return \StructType\OtherServiceInfoType
     */
    public function setAirline(\StructType\CompanyNameType $airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\OtherServiceInfoType
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($text) && mb_strlen($text) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($text)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($text) && mb_strlen($text) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\OtherServiceInfoType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{4})
        if (!is_null($code) && !preg_match('/[a-zA-Z]{4}/', $code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{4}', var_export($code, true)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OtherServiceInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
