<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginalIssueInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: The original ticket/document issue information.
 * @subpackage Structs
 */
class OriginalIssueInfo extends AbstractStructBase
{
    /**
     * The TicketDocumentNbr
     * Meta information extracted from the WSDL
     * - documentation: The original ticket/document number. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TicketDocumentNbr;
    /**
     * The IssuingAgentID
     * Meta information extracted from the WSDL
     * - documentation: ID of the original issuer of the ticket/document. | Used for Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $IssuingAgentID;
    /**
     * The DateOfIssue
     * Meta information extracted from the WSDL
     * - documentation: Date the ticket/document was originally issued.
     * - use: optional
     * @var string
     */
    public $DateOfIssue;
    /**
     * The LocationCode
     * Meta information extracted from the WSDL
     * - documentation: Location of original issue. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $LocationCode;
    /**
     * The IssuingAirlineCode
     * Meta information extracted from the WSDL
     * - documentation: The code of the original issuing airline. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $IssuingAirlineCode;
    /**
     * Constructor method for OriginalIssueInfo
     * @uses OriginalIssueInfo::setTicketDocumentNbr()
     * @uses OriginalIssueInfo::setIssuingAgentID()
     * @uses OriginalIssueInfo::setDateOfIssue()
     * @uses OriginalIssueInfo::setLocationCode()
     * @uses OriginalIssueInfo::setIssuingAirlineCode()
     * @param string $ticketDocumentNbr
     * @param string $issuingAgentID
     * @param string $dateOfIssue
     * @param string $locationCode
     * @param string $issuingAirlineCode
     */
    public function __construct($ticketDocumentNbr = null, $issuingAgentID = null, $dateOfIssue = null, $locationCode = null, $issuingAirlineCode = null)
    {
        $this
            ->setTicketDocumentNbr($ticketDocumentNbr)
            ->setIssuingAgentID($issuingAgentID)
            ->setDateOfIssue($dateOfIssue)
            ->setLocationCode($locationCode)
            ->setIssuingAirlineCode($issuingAirlineCode);
    }
    /**
     * Get TicketDocumentNbr value
     * @return string|null
     */
    public function getTicketDocumentNbr()
    {
        return $this->TicketDocumentNbr;
    }
    /**
     * Set TicketDocumentNbr value
     * @param string $ticketDocumentNbr
     * @return \StructType\OriginalIssueInfo
     */
    public function setTicketDocumentNbr($ticketDocumentNbr = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDocumentNbr) && !is_string($ticketDocumentNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDocumentNbr, true), gettype($ticketDocumentNbr)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($ticketDocumentNbr) && mb_strlen($ticketDocumentNbr) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($ticketDocumentNbr)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ticketDocumentNbr) && mb_strlen($ticketDocumentNbr) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ticketDocumentNbr)), __LINE__);
        }
        $this->TicketDocumentNbr = $ticketDocumentNbr;
        return $this;
    }
    /**
     * Get IssuingAgentID value
     * @return string|null
     */
    public function getIssuingAgentID()
    {
        return $this->IssuingAgentID;
    }
    /**
     * Set IssuingAgentID value
     * @param string $issuingAgentID
     * @return \StructType\OriginalIssueInfo
     */
    public function setIssuingAgentID($issuingAgentID = null)
    {
        // validation for constraint: string
        if (!is_null($issuingAgentID) && !is_string($issuingAgentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuingAgentID, true), gettype($issuingAgentID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($issuingAgentID) && !preg_match('/[0-9]{1,8}/', $issuingAgentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($issuingAgentID, true)), __LINE__);
        }
        $this->IssuingAgentID = $issuingAgentID;
        return $this;
    }
    /**
     * Get DateOfIssue value
     * @return string|null
     */
    public function getDateOfIssue()
    {
        return $this->DateOfIssue;
    }
    /**
     * Set DateOfIssue value
     * @param string $dateOfIssue
     * @return \StructType\OriginalIssueInfo
     */
    public function setDateOfIssue($dateOfIssue = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfIssue) && !is_string($dateOfIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfIssue, true), gettype($dateOfIssue)), __LINE__);
        }
        $this->DateOfIssue = $dateOfIssue;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \StructType\OriginalIssueInfo
     */
    public function setLocationCode($locationCode = null)
    {
        // validation for constraint: string
        if (!is_null($locationCode) && !is_string($locationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationCode, true), gettype($locationCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($locationCode) && mb_strlen($locationCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($locationCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($locationCode) && mb_strlen($locationCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($locationCode)), __LINE__);
        }
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get IssuingAirlineCode value
     * @return string|null
     */
    public function getIssuingAirlineCode()
    {
        return $this->IssuingAirlineCode;
    }
    /**
     * Set IssuingAirlineCode value
     * @param string $issuingAirlineCode
     * @return \StructType\OriginalIssueInfo
     */
    public function setIssuingAirlineCode($issuingAirlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($issuingAirlineCode) && !is_string($issuingAirlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuingAirlineCode, true), gettype($issuingAirlineCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($issuingAirlineCode) && mb_strlen($issuingAirlineCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($issuingAirlineCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($issuingAirlineCode) && mb_strlen($issuingAirlineCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($issuingAirlineCode)), __LINE__);
        }
        $this->IssuingAirlineCode = $issuingAirlineCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OriginalIssueInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
