<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Order StructType
 * Meta information extracted from the WSDL
 * - documentation: Information pertaining to a specific order.
 * @subpackage Structs
 */
class Order extends AbstractStructBase
{
    /**
     * The Products
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Products
     */
    public $Products;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - documentation: Identifies the type of order. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $OrderType;
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - documentation: The identification number associated to the orders. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $OrderID;
    /**
     * The ListOfRecipientRPH
     * Meta information extracted from the WSDL
     * - documentation: The recipient(s) to whom the order pertains. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary
     * items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $ListOfRecipientRPH;
    /**
     * Constructor method for Order
     * @uses Order::setProducts()
     * @uses Order::setOrderType()
     * @uses Order::setOrderID()
     * @uses Order::setListOfRecipientRPH()
     * @param \StructType\Products $products
     * @param string $orderType
     * @param string $orderID
     * @param string[] $listOfRecipientRPH
     */
    public function __construct(\StructType\Products $products = null, $orderType = null, $orderID = null, array $listOfRecipientRPH = array())
    {
        $this
            ->setProducts($products)
            ->setOrderType($orderType)
            ->setOrderID($orderID)
            ->setListOfRecipientRPH($listOfRecipientRPH);
    }
    /**
     * Get Products value
     * @return \StructType\Products|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \StructType\Products $products
     * @return \StructType\Order
     */
    public function setProducts(\StructType\Products $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get OrderType value
     * @return string|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param string $orderType
     * @return \StructType\Order
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: string
        if (!is_null($orderType) && !is_string($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderType, true), gettype($orderType)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($orderType) && mb_strlen($orderType) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($orderType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($orderType) && mb_strlen($orderType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($orderType)), __LINE__);
        }
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get OrderID value
     * @return string|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \StructType\Order
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($orderID) && mb_strlen($orderID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($orderID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($orderID) && mb_strlen($orderID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get ListOfRecipientRPH value
     * @return string[]|null
     */
    public function getListOfRecipientRPH()
    {
        return $this->ListOfRecipientRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setListOfRecipientRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListOfRecipientRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListOfRecipientRPHForArrayConstraintsFromSetListOfRecipientRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderListOfRecipientRPHItem) {
            // validation for constraint: itemType
            if (!is_string($orderListOfRecipientRPHItem)) {
                $invalidValues[] = is_object($orderListOfRecipientRPHItem) ? get_class($orderListOfRecipientRPHItem) : sprintf('%s(%s)', gettype($orderListOfRecipientRPHItem), var_export($orderListOfRecipientRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ListOfRecipientRPH property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ListOfRecipientRPH value
     * @param string[] $listOfRecipientRPH
     * @return \StructType\Order
     */
    public function setListOfRecipientRPH(array $listOfRecipientRPH = array())
    {
        // validation for constraint: list
        if ('' !== ($listOfRecipientRPHArrayErrorMessage = self::validateListOfRecipientRPHForArrayConstraintsFromSetListOfRecipientRPH($listOfRecipientRPH))) {
            throw new \InvalidArgumentException($listOfRecipientRPHArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($listOfRecipientRPH) && !preg_match('/[0-9]{1,8}/', $listOfRecipientRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($listOfRecipientRPH, true)), __LINE__);
        }
        $this->ListOfRecipientRPH = is_array($listOfRecipientRPH) ? implode(' ', $listOfRecipientRPH) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Order
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
